/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.util;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.util.Set;

public class JpsPathUtil {
    public static boolean isUnder(Set<File> ancestors, File file) {
        if (ancestors.isEmpty()) {
            return false;
        }
        File current = file;
        while (current != null) {
            if (ancestors.contains(current)) {
                return true;
            }
            current = FileUtilRt.getParentFile((File)current);
        }
        return false;
    }

    public static File urlToFile(String url) {
        return new File(JpsPathUtil.urlToOsPath(url));
    }

    public static String urlToOsPath(String url) {
        return FileUtilRt.toSystemDependentName((String)JpsPathUtil.urlToPath(url));
    }

    public static String urlToPath(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("file://")) {
            return url.substring("file://".length());
        }
        if (url.startsWith("jar://") && (url = url.substring("jar://".length())).endsWith("!/")) {
            url = url.substring(0, url.length() - "!/".length());
        }
        return url;
    }

    public static String fixURLforIDEA(String url) {
        int idx = url.indexOf(":/");
        if (idx >= 0 && idx + 2 < url.length() && url.charAt(idx + 2) != '/') {
            String prefix = url.substring(0, idx);
            String suffix = url.substring(idx + 2);
            url = SystemInfoRt.isWindows ? prefix + "://" + suffix : prefix + ":///" + suffix;
        }
        return url;
    }

    public static String pathToUrl(String path) {
        return "file://" + path;
    }

    public static String getLibraryRootUrl(File file) {
        String path = FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath());
        if (file.isDirectory()) {
            return "file://" + path;
        }
        return "jar://" + path + "!/";
    }
}

