/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import com.intellij.openapi.util.Comparing;
import org.jetbrains.jps.model.ex.JpsElementBase;

public class JavaResourceRootProperties
extends JpsElementBase<JavaResourceRootProperties> {
    private String myRelativeOutputPath = "";
    private boolean myForGeneratedSources;

    public JavaResourceRootProperties(String relativeOutputPath, boolean forGeneratedSources) {
        this.myRelativeOutputPath = relativeOutputPath;
        this.myForGeneratedSources = forGeneratedSources;
    }

    public String getRelativeOutputPath() {
        return this.myRelativeOutputPath;
    }

    @Override
    public JavaResourceRootProperties createCopy() {
        return new JavaResourceRootProperties(this.myRelativeOutputPath, this.myForGeneratedSources);
    }

    public boolean isForGeneratedSources() {
        return this.myForGeneratedSources;
    }

    public void setRelativeOutputPath(String relativeOutputPath) {
        if (!Comparing.equal((String)this.myRelativeOutputPath, (String)relativeOutputPath)) {
            this.myRelativeOutputPath = relativeOutputPath;
            this.fireElementChanged();
        }
    }

    public void setForGeneratedSources(boolean forGeneratedSources) {
        if (this.myForGeneratedSources != forGeneratedSources) {
            this.myForGeneratedSources = forGeneratedSources;
            this.fireElementChanged();
        }
    }

    @Override
    public void applyChanges(JavaResourceRootProperties modified) {
        this.setRelativeOutputPath(modified.myRelativeOutputPath);
        this.setForGeneratedSources(modified.myForGeneratedSources);
    }
}

