/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.Collection;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CountDownConsumer;
import org.jetbrains.concurrency.DonePromise;
import org.jetbrains.concurrency.RejectedPromise;

public abstract class Promise<T> {
    public static final Promise<Void> DONE = new DonePromise<Object>(null);
    public static final Promise<Void> REJECTED = new RejectedPromise<Void>(Promise.createError("rejected"));

    public static RuntimeException createError(String error) {
        return new MessageError(error);
    }

    public static <T> Promise<T> resolve(T result) {
        if (result == null) {
            return DONE;
        }
        return new DonePromise<T>(result);
    }

    public static <T> Promise<T> reject(String error) {
        return Promise.reject(Promise.createError(error));
    }

    public static <T> Promise<T> reject(Throwable error) {
        if (error == null) {
            return REJECTED;
        }
        return new RejectedPromise(error);
    }

    public static Promise<Void> all(Collection<Promise<?>> promises) {
        return Promise.all(promises, null);
    }

    public static <T> Promise<T> all(Collection<Promise<?>> promises, T totalResult) {
        if (promises.isEmpty()) {
            return DONE;
        }
        final AsyncPromise totalPromise = new AsyncPromise();
        CountDownConsumer done = new CountDownConsumer(promises.size(), totalPromise, totalResult);
        Consumer<Throwable> rejected = new Consumer<Throwable>(){

            public void consume(Throwable error) {
                if (totalPromise.state == State.PENDING) {
                    totalPromise.setError(error);
                }
            }
        };
        for (Promise<?> promise : promises) {
            promise.done(done);
            promise.rejected(rejected);
        }
        return totalPromise;
    }

    public static Promise<Void> wrapAsVoid(ActionCallback asyncResult) {
        final AsyncPromise<Void> promise = new AsyncPromise<Void>();
        asyncResult.doWhenDone(new Runnable(){

            @Override
            public void run() {
                promise.setResult(null);
            }
        }).doWhenRejected(new Consumer<String>(){

            public void consume(String error) {
                promise.setError(Promise.createError(error));
            }
        });
        return promise;
    }

    public static <T> Promise<T> wrap(AsyncResult<T> asyncResult) {
        final AsyncPromise promise = new AsyncPromise();
        asyncResult.doWhenDone(new Consumer<T>(){

            public void consume(T result) {
                promise.setResult(result);
            }
        }).doWhenRejected(new Consumer<String>(){

            public void consume(String error) {
                promise.setError(Promise.createError(error));
            }
        });
        return promise;
    }

    public abstract Promise<T> done(Consumer<T> var1);

    public abstract Promise<T> processed(AsyncPromise<T> var1);

    public abstract Promise<T> rejected(Consumer<Throwable> var1);

    public abstract Promise<T> processed(Consumer<T> var1);

    public abstract <SUB_RESULT> Promise<SUB_RESULT> then(Function<T, SUB_RESULT> var1);

    public abstract <SUB_RESULT> Promise<SUB_RESULT> then(AsyncFunction<T, SUB_RESULT> var1);

    public abstract State getState();

    abstract void notify(AsyncPromise<T> var1);

    public static class MessageError
    extends RuntimeException {
        public MessageError(String error) {
            super(error);
        }

        @Override
        public final synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    public static enum State {
        PENDING,
        FULFILLED,
        REJECTED;

    }
}

