/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlTagUtilBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class XmlTagUtil
extends XmlTagUtilBase {
    private static final Map<String, Character> ourCharacterEntities = new HashMap<String, Character>();

    public static String getCDATAQuote(String text) {
        if (text == null) {
            return null;
        }
        String offensiveChars = "<>&\n";
        int textLength = text.length();
        if (textLength > 0 && (Character.isWhitespace(text.charAt(0)) || Character.isWhitespace(text.charAt(textLength - 1)))) {
            return "<![CDATA[" + text + "]]>";
        }
        for (int i = 0; i < offensiveChars.length(); ++i) {
            char c = offensiveChars.charAt(i);
            if (text.indexOf(c) == -1) continue;
            return "<![CDATA[" + text + "]]>";
        }
        return text;
    }

    public static String getInlineQuote(String text) {
        if (text == null) {
            return null;
        }
        String offensiveChars = "<>&";
        for (int i = 0; i < offensiveChars.length(); ++i) {
            char c = offensiveChars.charAt(i);
            if (text.indexOf(c) == -1) continue;
            return "<![CDATA[" + text + "]]>";
        }
        return text;
    }

    public static CharSequence composeTagText(String tagName, String tagValue) {
        StringBuilder builder = new StringBuilder();
        builder.append('<').append(tagName);
        if (StringUtil.isEmpty((String)tagValue)) {
            builder.append("/>");
        } else {
            builder.append('>').append(XmlTagUtil.getCDATAQuote(tagValue)).append("</").append(tagName).append('>');
        }
        return builder;
    }

    public static String[] getCharacterEntityNames() {
        Set<String> strings = ourCharacterEntities.keySet();
        return ArrayUtil.toStringArray(strings);
    }

    public static Character getCharacterByEntityName(String entityName) {
        return ourCharacterEntities.get(entityName);
    }

    public static XmlToken getStartTagNameElement(XmlTag tag) {
        IElementType elementType;
        ASTNode current;
        ASTNode node = tag.getNode();
        if (node == null) {
            return null;
        }
        for (current = node.getFirstChildNode(); current != null && (elementType = current.getElementType()) != XmlTokenType.XML_NAME && elementType != XmlTokenType.XML_TAG_NAME; current = current.getTreeNext()) {
        }
        return current == null ? null : (XmlToken)current.getPsi();
    }

    public static XmlToken getEndTagNameElement(XmlTag tag) {
        ASTNode current;
        ASTNode node = tag.getNode();
        if (node == null) {
            return null;
        }
        ASTNode prev = current = node.getLastChildNode();
        while (current != null) {
            IElementType elementType = prev.getElementType();
            if ((elementType == XmlTokenType.XML_NAME || elementType == XmlTokenType.XML_TAG_NAME) && current.getElementType() == XmlTokenType.XML_END_TAG_START) {
                return (XmlToken)prev.getPsi();
            }
            prev = current;
            current = current.getTreePrev();
        }
        return null;
    }

    public static TextRange getTrimmedValueRange(XmlTag tag) {
        XmlTagValue tagValue = tag.getValue();
        String text = tagValue.getText();
        String trimmed = text.trim();
        int index = text.indexOf(trimmed);
        int startOffset = tagValue.getTextRange().getStartOffset() - tag.getTextRange().getStartOffset() + index;
        return new TextRange(startOffset, startOffset + trimmed.length());
    }

    public static TextRange getStartTagRange(XmlTag tag) {
        XmlToken tagName = XmlTagUtil.getStartTagNameElement(tag);
        return XmlTagUtil.getTag(tagName, XmlTokenType.XML_START_TAG_START);
    }

    public static TextRange getEndTagRange(XmlTag tag) {
        XmlToken tagName = XmlTagUtil.getEndTagNameElement(tag);
        return XmlTagUtil.getTag(tagName, XmlTokenType.XML_END_TAG_START);
    }

    private static TextRange getTag(XmlToken tagName, IElementType tagStart) {
        if (tagName != null) {
            PsiElement f;
            PsiElement s;
            for (s = tagName.getPrevSibling(); s != null && s.getNode().getElementType() != tagStart; s = s.getPrevSibling()) {
            }
            for (f = tagName.getNextSibling(); f != null && f.getNode().getElementType() != XmlTokenType.XML_TAG_END && f.getNode().getElementType() != XmlTokenType.XML_EMPTY_ELEMENT_END; f = f.getNextSibling()) {
            }
            if (s != null && f != null) {
                return new TextRange(s.getTextRange().getStartOffset(), f.getTextRange().getEndOffset());
            }
        }
        return null;
    }

    static {
        ourCharacterEntities.put("lt", Character.valueOf('<'));
        ourCharacterEntities.put("gt", Character.valueOf('>'));
        ourCharacterEntities.put("apos", Character.valueOf('\''));
        ourCharacterEntities.put("quot", Character.valueOf('\"'));
        ourCharacterEntities.put("nbsp", Character.valueOf('\u00a0'));
        ourCharacterEntities.put("amp", Character.valueOf('&'));
    }
}

