/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.evaluation;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import java.util.Collection;
import java.util.Collections;

public abstract class XDebuggerEditorsProvider {
    public abstract FileType getFileType();

    public abstract Document createDocument(Project var1, String var2, XSourcePosition var3, EvaluationMode var4);

    public Document createDocument(Project project, XExpression expression, XSourcePosition sourcePosition, EvaluationMode mode) {
        return this.createDocument(project, expression.getExpression(), sourcePosition, mode);
    }

    public Collection<Language> getSupportedLanguages(Project project, XSourcePosition sourcePosition) {
        FileType type = this.getFileType();
        if (type instanceof LanguageFileType) {
            return Collections.singleton(((LanguageFileType)type).getLanguage());
        }
        return Collections.emptyList();
    }

    public XExpression createExpression(Project project, Document document, Language language, EvaluationMode mode) {
        return XDebuggerUtil.getInstance().createExpression(document.getText(), language, null, mode);
    }

    public InlineDebuggerHelper getInlineDebuggerHelper() {
        return InlineDebuggerHelper.DEFAULT;
    }
}

