/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class XBreakpointType<B extends XBreakpoint<P>, P extends XBreakpointProperties> {
    public static final ExtensionPointName<XBreakpointType> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.xdebugger.breakpointType");
    private final String myId;
    private final String myTitle;
    private final boolean mySuspendThreadSupported;

    protected XBreakpointType(String id, String title) {
        this(id, title, false);
    }

    protected XBreakpointType(String id, String title, boolean suspendThreadSupported) {
        this.myId = id;
        this.myTitle = title;
        this.mySuspendThreadSupported = suspendThreadSupported;
    }

    public P createProperties() {
        return null;
    }

    public boolean isSuspendThreadSupported() {
        return this.mySuspendThreadSupported;
    }

    public EnumSet<StandardPanels> getVisibleStandardPanels() {
        return EnumSet.allOf(StandardPanels.class);
    }

    public final String getId() {
        return this.myId;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public Icon getEnabledIcon() {
        return AllIcons.Debugger.Db_set_breakpoint;
    }

    public Icon getDisabledIcon() {
        return AllIcons.Debugger.Db_disabled_breakpoint;
    }

    public Icon getMutedEnabledIcon() {
        return AllIcons.Debugger.Db_muted_breakpoint;
    }

    public Icon getMutedDisabledIcon() {
        return AllIcons.Debugger.Db_muted_disabled_breakpoint;
    }

    public Icon getInactiveDependentIcon() {
        return this.getDisabledDependentIcon();
    }

    public Icon getDisabledDependentIcon() {
        return AllIcons.Debugger.Db_dep_line_breakpoint;
    }

    public abstract String getDisplayText(B var1);

    public XBreakpointCustomPropertiesPanel<B> createCustomConditionsPanel() {
        return null;
    }

    public XBreakpointCustomPropertiesPanel<B> createCustomPropertiesPanel() {
        return null;
    }

    public XBreakpointCustomPropertiesPanel<B> createCustomRightPropertiesPanel(Project project) {
        return null;
    }

    public XBreakpointCustomPropertiesPanel<B> createCustomTopPropertiesPanel(Project project) {
        return null;
    }

    public XDebuggerEditorsProvider getEditorsProvider() {
        return null;
    }

    public XDebuggerEditorsProvider getEditorsProvider(B breakpoint, Project project) {
        return this.getEditorsProvider();
    }

    public List<XBreakpointGroupingRule<B, ?>> getGroupingRules() {
        return Collections.emptyList();
    }

    public Comparator<B> getBreakpointComparator() {
        return new Comparator<B>(){

            @Override
            public int compare(B b, B b1) {
                return (int)(b1.getTimeStamp() - b.getTimeStamp());
            }
        };
    }

    public boolean isAddBreakpointButtonVisible() {
        return false;
    }

    public B addBreakpoint(Project project, JComponent parentComponent) {
        return null;
    }

    public XBreakpoint<P> createDefaultBreakpoint(XBreakpointCreator<P> creator) {
        return null;
    }

    public boolean shouldShowInBreakpointsDialog(Project project) {
        return true;
    }

    public String getBreakpointsDialogHelpTopic() {
        return null;
    }

    public XSourcePosition getSourcePosition(XBreakpoint<P> breakpoint) {
        return null;
    }

    public String getShortText(B breakpoint) {
        return this.getDisplayText(breakpoint);
    }

    public static interface XBreakpointCreator<P extends XBreakpointProperties> {
        public XBreakpoint<P> createBreakpoint(P var1);
    }

    public static enum StandardPanels {
        SUSPEND_POLICY,
        ACTIONS,
        DEPENDENCY;

    }
}

