/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ui.CommitListener;
import com.intellij.util.xml.ui.DomUIControl;
import com.intellij.util.xml.ui.DomWrapper;
import com.intellij.util.xml.ui.Highlightable;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.InvocationTargetException;
import java.util.EventListener;
import javax.swing.JComponent;

public abstract class BaseControl<Bound extends JComponent, T>
extends DomUIControl
implements Highlightable {
    public static final Color ERROR_BACKGROUND = new Color(255, 204, 204);
    public static final Color ERROR_FOREGROUND = SimpleTextAttributes.ERROR_ATTRIBUTES.getFgColor();
    public static final Color WARNING_BACKGROUND = new Color(255, 255, 204);
    private final EventDispatcher<CommitListener> myDispatcher = EventDispatcher.create(CommitListener.class);
    private Bound myBoundComponent;
    private final DomWrapper<T> myDomWrapper;
    private boolean myCommitting;
    private Color myDefaultForeground;
    private Color myDefaultBackground;

    protected BaseControl(DomWrapper<T> domWrapper) {
        this.myDomWrapper = domWrapper;
    }

    private void checkInitialized() {
        if (this.myBoundComponent != null) {
            return;
        }
        this.initialize(null);
    }

    protected JComponent getHighlightedComponent(Bound component) {
        return component;
    }

    protected final Color getDefaultBackground() {
        return this.myDefaultBackground;
    }

    protected final Color getDefaultForeground() {
        return this.myDefaultForeground;
    }

    protected final Color getErrorBackground() {
        return ERROR_BACKGROUND;
    }

    protected final Color getWarningBackground() {
        return WARNING_BACKGROUND;
    }

    protected final Color getErrorForeground() {
        return ERROR_FOREGROUND;
    }

    private void initialize(Bound boundComponent) {
        this.myBoundComponent = this.createMainComponent(boundComponent);
        JComponent highlightedComponent = this.getHighlightedComponent(this.myBoundComponent);
        this.myDefaultForeground = highlightedComponent.getForeground();
        this.myDefaultBackground = highlightedComponent.getBackground();
        JComponent component = this.getComponentToListenFocusLost(this.myBoundComponent);
        if (component != null) {
            component.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!e.isTemporary() && BaseControl.this.isValid()) {
                        BaseControl.this.commit();
                    }
                }
            });
        }
        this.updateComponent();
    }

    protected JComponent getComponentToListenFocusLost(Bound component) {
        return null;
    }

    protected abstract Bound createMainComponent(Bound var1);

    @Override
    public void bind(JComponent component) {
        this.initialize(component);
    }

    @Override
    public void addCommitListener(CommitListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeCommitListener(CommitListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public final DomElement getDomElement() {
        return this.myDomWrapper.getWrappedElement();
    }

    public final DomWrapper<T> getDomWrapper() {
        return this.myDomWrapper;
    }

    public final Bound getComponent() {
        this.checkInitialized();
        return this.myBoundComponent;
    }

    public void dispose() {
    }

    @Override
    public final void commit() {
        if (this.isValid() && !this.isCommitted()) {
            this.setValueToXml(this.getValue());
            this.updateComponent();
        }
    }

    protected final boolean isValid() {
        return this.myDomWrapper.isValid();
    }

    private static boolean valuesAreEqual(Object valueInXml, Object valueInControl) {
        return "".equals(valueInControl) && null == valueInXml || BaseControl.equalModuloTrim(valueInXml, valueInControl) || Comparing.equal((Object)valueInXml, (Object)valueInControl);
    }

    private static boolean equalModuloTrim(Object valueInXml, Object valueInControl) {
        return valueInXml instanceof String && valueInControl instanceof String && ((String)valueInXml).trim().equals(((String)valueInControl).trim());
    }

    @Override
    public final void reset() {
        if (!this.myCommitting) {
            this.doReset();
            this.updateComponent();
        }
    }

    @Override
    public void updateHighlighting() {
        this.updateComponent();
    }

    protected void updateComponent() {
    }

    protected void doReset() {
        if (this.valuesDiffer()) {
            this.setValue(this.getValueFromXml());
        }
    }

    protected boolean isCommitted() {
        return !this.valuesDiffer();
    }

    private boolean valuesDiffer() {
        return !BaseControl.valuesAreEqual(this.getValueFromXml(), this.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValueToXml(final T value) {
        if (this.myCommitting) {
            return;
        }
        this.myCommitting = true;
        try {
            CommitListener multicaster = (CommitListener)this.myDispatcher.getMulticaster();
            multicaster.beforeCommit(this);
            new WriteCommandAction(this.getProject(), new PsiFile[]{this.getDomWrapper().getFile()}){

                @Override
                protected void run(Result result) throws Throwable {
                    BaseControl.this.doCommit(value);
                }
            }.execute();
            multicaster.afterCommit(this);
        }
        finally {
            this.myCommitting = false;
        }
    }

    protected void doCommit(T value) throws IllegalAccessException, InvocationTargetException {
        this.myDomWrapper.setValue("".equals(value) ? null : (Object)value);
    }

    protected final Project getProject() {
        return this.myDomWrapper.getProject();
    }

    private T getValueFromXml() {
        try {
            return this.myDomWrapper.getValue();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean canNavigate(DomElement element) {
        return false;
    }

    @Override
    public void navigate(DomElement element) {
    }

    protected abstract T getValue();

    protected abstract void setValue(T var1);
}

