/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.model.DomModel;
import com.intellij.util.xml.model.impl.BaseDomModelFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class DomModelFactory<T extends DomElement, M extends DomModel<T>, C extends PsiElement>
extends BaseDomModelFactory<Module, T, M, C> {
    protected DomModelFactory(Class<T> aClass, Project project, String name) {
        super(aClass, project, name);
    }

    @Override
    protected Module getModelScope(XmlFile file) {
        return ModuleUtil.findModuleForPsiElement(file);
    }

    public Set<XmlFile> getConfigFiles(C context) {
        if (context == null) {
            return Collections.emptySet();
        }
        Object model = this.getModel(context);
        if (model == null) {
            return Collections.emptySet();
        }
        return model.getConfigFiles();
    }

    public List<DomFileElement<T>> getFileElements(M model) {
        ArrayList<DomFileElement<T>> list = new ArrayList<DomFileElement<T>>(model.getConfigFiles().size());
        for (XmlFile configFile : model.getConfigFiles()) {
            DomFileElement element = DomManager.getDomManager(configFile.getProject()).getFileElement(configFile, this.myClass);
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }
}

