/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomCustomAnnotationChecker;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;

public abstract class DomHighlightingHelper {
    private final DomCustomAnnotationChecker[] myCustomCheckers = (DomCustomAnnotationChecker[])Extensions.getExtensions(DomCustomAnnotationChecker.EP_NAME);

    public abstract List<DomElementProblemDescriptor> checkRequired(DomElement var1, DomElementAnnotationHolder var2);

    public abstract List<DomElementProblemDescriptor> checkResolveProblems(GenericDomValue var1, DomElementAnnotationHolder var2);

    public abstract List<DomElementProblemDescriptor> checkNameIdentity(DomElement var1, DomElementAnnotationHolder var2);

    public abstract void runAnnotators(DomElement var1, DomElementAnnotationHolder var2, Class<? extends DomElement> var3);

    public List<DomElementProblemDescriptor> checkCustomAnnotations(DomElement element, DomElementAnnotationHolder holder) {
        List result = null;
        for (DomCustomAnnotationChecker checker : this.myCustomCheckers) {
            List<DomElementProblemDescriptor> list = this.checkAnno(element, checker, holder);
            if (list.isEmpty()) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.addAll(list);
        }
        return result == null ? Collections.emptyList() : result;
    }

    private <T extends Annotation> List<DomElementProblemDescriptor> checkAnno(DomElement element, DomCustomAnnotationChecker<T> checker, DomElementAnnotationHolder holder) {
        T annotation = element.getAnnotation(checker.getAnnotationClass());
        return annotation != null ? checker.checkForProblems(annotation, element, holder, this) : Collections.emptyList();
    }
}

