/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class DomElementsInspection<T extends DomElement>
extends XmlSuppressableInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.highlighting.DomElementsInspection");
    private final Set<Class<? extends T>> myDomClasses;

    public DomElementsInspection(Class<? extends T> domClass, Class<? extends T> ... additionalClasses) {
        this.myDomClasses = new THashSet(Arrays.asList(additionalClasses));
        this.myDomClasses.add(domClass);
    }

    public void checkFileElement(DomFileElement<T> domFileElement, final DomElementAnnotationHolder holder) {
        final DomHighlightingHelper helper = DomElementAnnotationsManager.getInstance(domFileElement.getManager().getProject()).getHighlightingHelper();
        Consumer<DomElement> consumer = new Consumer<DomElement>(){

            public void consume(DomElement element) {
                DomElementsInspection.this.checkChildren(element, this);
                DomElementsInspection.this.checkDomElement(element, holder, helper);
            }
        };
        consumer.consume(domFileElement.getRootElement());
    }

    protected void checkChildren(DomElement element, Consumer<DomElement> visitor) {
        XmlElement xmlElement = element.getXmlElement();
        if (xmlElement instanceof XmlTag) {
            for (DomElement domElement : DomUtil.getDefinedChildren(element, true, true)) {
                XmlElement element1 = domElement.getXmlElement();
                if (element1 == null) {
                    LOG.error("child=" + domElement + " of class " + domElement.getClass() + "; parent=" + element);
                }
                if (!element1.isPhysical()) continue;
                visitor.consume((Object)domElement);
            }
            for (AbstractDomChildrenDescription abstractDomChildrenDescription : element.getGenericInfo().getChildrenDescriptions()) {
                if (abstractDomChildrenDescription.getAnnotation(Required.class) == null) continue;
                for (DomElement domElement : abstractDomChildrenDescription.getValues(element)) {
                    if (DomUtil.hasXml(domElement)) continue;
                    visitor.consume((Object)domElement);
                }
            }
        }
    }

    public final Set<Class<? extends T>> getDomClasses() {
        return this.myDomClasses;
    }

    @Override
    public ProblemDescriptor[] checkFile(PsiFile file, InspectionManager manager, boolean isOnTheFly) {
        if (file instanceof XmlFile && (file.isPhysical() || ApplicationManager.getApplication().isUnitTestMode())) {
            for (Class<? extends T> clazz : this.myDomClasses) {
                DomFileElement<? extends T> fileElement = DomManager.getDomManager(file.getProject()).getFileElement((XmlFile)file, clazz);
                if (fileElement == null) continue;
                return this.checkDomFile(fileElement, manager, isOnTheFly);
            }
        }
        return null;
    }

    @Override
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    protected ProblemDescriptor[] checkDomFile(DomFileElement<T> domFileElement, final InspectionManager manager, boolean isOnTheFly) {
        final DomElementAnnotationsManager annotationsManager = DomElementAnnotationsManager.getInstance(manager.getProject());
        List<DomElementProblemDescriptor> list = annotationsManager.checkFileElement(domFileElement, this, isOnTheFly);
        if (list.isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        List problems = ContainerUtil.concat(list, (Function)new Function<DomElementProblemDescriptor, Collection<? extends ProblemDescriptor>>(){

            public Collection<ProblemDescriptor> fun(DomElementProblemDescriptor s) {
                return annotationsManager.createProblemDescriptors(manager, s);
            }
        });
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        throw new UnsupportedOperationException("checkDomElement() is not implemented in " + this.getClass().getName());
    }
}

