/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.lang.reflect.Type;

public abstract class BasicDomElementsInspection<T extends DomElement>
extends DomElementsInspection<T> {
    public BasicDomElementsInspection(Class<? extends T> domClass, Class<? extends T> ... additionalClasses) {
        super(domClass, additionalClasses);
    }

    protected boolean shouldCheckResolveProblems(GenericDomValue value) {
        return true;
    }

    @Override
    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        GenericDomValue genericDomValue;
        int oldSize = holder.getSize();
        if (element instanceof GenericDomValue && this.shouldCheckResolveProblems(genericDomValue = (GenericDomValue)element)) {
            helper.checkResolveProblems(genericDomValue, holder);
        }
        for (Class aClass : this.getDomClasses()) {
            helper.runAnnotators(element, holder, aClass);
        }
        if (oldSize != holder.getSize()) {
            return;
        }
        if (!helper.checkRequired(element, holder).isEmpty()) {
            return;
        }
        if (!(element instanceof GenericAttributeValue || GenericDomValue.class.equals((Object)ReflectionUtil.getRawType((Type)element.getDomElementType())) || helper.checkNameIdentity(element, holder).isEmpty())) {
            return;
        }
        helper.checkCustomAnnotations(element, holder);
    }
}

