/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters.values;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomBundle;

public class CharacterValueConverter
extends Converter<String> {
    private static final String UNICODE_PREFIX = "\\u";
    private static final int UNICODE_LENGTH = 6;
    private final boolean myAllowEmpty;

    public CharacterValueConverter(boolean allowEmpty) {
        this.myAllowEmpty = allowEmpty;
    }

    @Override
    public String fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        if (this.myAllowEmpty && s.trim().length() == 0) {
            return s;
        }
        if (s.trim().length() == 1) {
            return s;
        }
        if (CharacterValueConverter.isUnicodeCharacterSequence(s)) {
            try {
                Integer.parseInt(s.substring(UNICODE_PREFIX.length()), 16);
                return s;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isUnicodeCharacterSequence(String sequence) {
        return sequence.startsWith(UNICODE_PREFIX) && sequence.length() == 6;
    }

    @Override
    public String toString(String s, ConvertContext context) {
        return s;
    }

    @Override
    public String getErrorMessage(String s, ConvertContext context) {
        return DomBundle.message("value.converter.format.exception", s, "char");
    }
}

