/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.actions.generate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.actions.generate.DefaultGenerateElementProvider;
import com.intellij.util.xml.actions.generate.DomTemplateRunner;
import java.util.Arrays;
import java.util.Map;

public abstract class AbstractDomGenerateProvider<T extends DomElement>
extends DefaultGenerateElementProvider<T> {
    public static final String NAMESPACE_PREFIX_VAR = "NS_PREFIX";
    private final String myMappingId;

    public AbstractDomGenerateProvider(String description, Class<T> aClass) {
        this(description, aClass, null);
    }

    public AbstractDomGenerateProvider(String description, Class<T> aClass, String mappingId) {
        super(description, aClass);
        this.myMappingId = mappingId;
    }

    @Override
    public T generate(Project project, Editor editor, PsiFile file) {
        DomElement parentDomElement = this.getParentDomElement(project, editor, file);
        Object t = this.generate(parentDomElement, editor);
        this.runTemplate(editor, file, t, this.getPredefinedVars(parentDomElement, t, editor, file));
        return t;
    }

    protected Map<String, String> getPredefinedVars(DomElement parentDomElement, T t, Editor editor, PsiFile file) {
        return AbstractDomGenerateProvider.createNamespacePrefixMap(parentDomElement);
    }

    public static Map<String, String> createNamespacePrefixMap(DomElement domElement) {
        HashMap vars = new HashMap();
        AbstractDomGenerateProvider.addNamespacePrefix(domElement, (Map<String, String>)vars);
        return vars;
    }

    public static void addNamespacePrefix(DomElement domElement, Map<String, String> vars) {
        String namespacePrefix;
        XmlTag tag;
        if (domElement != null && (tag = domElement.getXmlTag()) != null && !StringUtil.isEmptyOrSpaces((String)(namespacePrefix = tag.getNamespacePrefix()))) {
            vars.put(NAMESPACE_PREFIX_VAR, namespacePrefix + ":");
        }
    }

    protected void runTemplate(Editor editor, PsiFile file, T t, Map<String, String> predefinedVars) {
        DomTemplateRunner.getInstance(file.getProject()).runTemplate(t, this.myMappingId, editor, predefinedVars);
    }

    @Override
    protected abstract DomElement getParentDomElement(Project var1, Editor var2, PsiFile var3);

    @Override
    protected void doNavigate(DomElementNavigationProvider navigateProvider, DomElement copy) {
        DomElement element = this.getElementToNavigate(copy);
        if (element != null) {
            super.doNavigate(navigateProvider, element);
        }
    }

    protected DomElement getElementToNavigate(T t) {
        return t;
    }

    protected static String getDescription(Class<? extends DomElement> aClass) {
        return StringUtil.join(Arrays.asList(NameUtil.nameToWords((String)aClass.getSimpleName())), (String)" ");
    }

    public String getMappingId() {
        return this.myMappingId;
    }
}

