/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CompositeModificationTracker;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.lang.reflect.Type;

public abstract class DomManager
extends CompositeModificationTracker
implements ModificationTracker {
    public static final Key<Module> MOCK_ELEMENT_MODULE = Key.create((String)"MockElementModule");
    private static final NotNullLazyKey<DomManager, Project> INSTANCE_CACHE = ServiceManager.createLazyKey(DomManager.class);

    public static DomManager getDomManager(Project project) {
        return (DomManager)INSTANCE_CACHE.getValue((UserDataHolder)project);
    }

    public DomManager(Project project) {
        super(PsiManager.getInstance(project).getModificationTracker().getOutOfCodeBlockModificationTracker());
    }

    public abstract Project getProject();

    public abstract <T extends DomElement> DomFileElement<T> getFileElement(XmlFile var1, Class<T> var2);

    @Deprecated
    public abstract <T extends DomElement> DomFileElement<T> getFileElement(XmlFile var1);

    @Deprecated
    public abstract <T extends DomElement> DomFileElement<T> getFileElement(XmlFile var1, Class<T> var2, String var3);

    public abstract void addDomEventListener(DomEventListener var1, Disposable var2);

    public abstract DomGenericInfo getGenericInfo(Type var1);

    public abstract DomElement getDomElement(XmlTag var1);

    public abstract GenericAttributeValue getDomElement(XmlAttribute var1);

    public abstract <T extends DomElement> T createMockElement(Class<T> var1, Module var2, boolean var3);

    public abstract boolean isMockElement(DomElement var1);

    public abstract <T extends DomElement> T createStableValue(Factory<T> var1);

    public abstract <T> T createStableValue(Factory<T> var1, Condition<T> var2);

    public abstract void registerFileDescription(DomFileDescription var1);

    public abstract ConverterManager getConverterManager();

    @Deprecated
    public abstract void addPsiReferenceFactoryForClass(Class var1, PsiReferenceFactory var2);

    public abstract ModelMerger createModelMerger();

    public abstract DomElement getResolvingScope(GenericDomValue var1);

    public abstract DomElement getIdentityScope(DomElement var1);

    public abstract TypeChooserManager getTypeChooserManager();

    public abstract AbstractDomChildrenDescription findChildrenDescription(XmlTag var1, DomElement var2);

    public final DomFileDescription<?> getDomFileDescription(XmlFile xmlFile) {
        DomFileElement element = this.getFileElement(xmlFile);
        return element != null ? element.getFileDescription() : null;
    }
}

