/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;

public class MergingUpdateQueue
implements Runnable,
Disposable,
Activatable {
    public static final JComponent ANY_COMPONENT = new JComponent(){};
    private volatile boolean myActive;
    private volatile boolean mySuspended;
    private final Map<Update, Update> myScheduledUpdates = new TreeMap<Update, Update>();
    private final Alarm myWaiterForMerge;
    private volatile boolean myFlushing;
    private final String myName;
    private int myMergingTimeSpan;
    private JComponent myModalityStateComponent;
    private final boolean myExecuteInDispatchThread;
    private boolean myPassThrough;
    private boolean myDisposed;
    private UiNotifyConnector myUiNotifyConnector;
    private boolean myRestartOnAdd;
    private boolean myTrackUiActivity;
    private UiActivity myUiActivity;

    public MergingUpdateQueue(String name, int mergingTimeSpan, boolean isActive, JComponent modalityStateComponent) {
        this(name, mergingTimeSpan, isActive, modalityStateComponent, null);
    }

    public MergingUpdateQueue(String name, int mergingTimeSpan, boolean isActive, JComponent modalityStateComponent, Disposable parent) {
        this(name, mergingTimeSpan, isActive, modalityStateComponent, parent, null);
    }

    public MergingUpdateQueue(String name, int mergingTimeSpan, boolean isActive, JComponent modalityStateComponent, Disposable parent, JComponent activationComponent) {
        this(name, mergingTimeSpan, isActive, modalityStateComponent, parent, activationComponent, true);
    }

    public MergingUpdateQueue(String name, int mergingTimeSpan, boolean isActive, JComponent modalityStateComponent, Disposable parent, JComponent activationComponent, boolean executeInDispatchThread) {
        this(name, mergingTimeSpan, isActive, modalityStateComponent, parent, activationComponent, executeInDispatchThread ? Alarm.ThreadToUse.SWING_THREAD : Alarm.ThreadToUse.POOLED_THREAD);
    }

    public MergingUpdateQueue(String name, int mergingTimeSpan, boolean isActive, JComponent modalityStateComponent, Disposable parent, JComponent activationComponent, Alarm.ThreadToUse thread) {
        this.myMergingTimeSpan = mergingTimeSpan;
        this.myModalityStateComponent = modalityStateComponent;
        this.myName = name;
        this.myPassThrough = ApplicationManager.getApplication().isUnitTestMode();
        this.myExecuteInDispatchThread = thread == Alarm.ThreadToUse.SWING_THREAD;
        this.myWaiterForMerge = this.createAlarm(thread, this.myExecuteInDispatchThread ? null : this);
        if (isActive) {
            this.showNotify();
        }
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
        if (activationComponent != null) {
            this.setActivationComponent(activationComponent);
        }
    }

    protected Alarm createAlarm(Alarm.ThreadToUse thread, Disposable parent) {
        return new Alarm(thread, parent);
    }

    public void setMergingTimeSpan(int timeSpan) {
        this.myMergingTimeSpan = timeSpan;
        if (this.myActive) {
            this.restartTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllUpdates() {
        Map<Update, Update> map = this.myScheduledUpdates;
        synchronized (map) {
            Update[] updates;
            for (Update each : updates = this.myScheduledUpdates.keySet().toArray(new Update[this.myScheduledUpdates.size()])) {
                try {
                    each.setRejected();
                }
                catch (ProcessCanceledException ignored) {
                    // empty catch block
                }
            }
            this.myScheduledUpdates.clear();
            this.finishActivity();
        }
    }

    public final boolean isPassThrough() {
        return this.myPassThrough;
    }

    public final void setPassThrough(boolean passThrough) {
        this.myPassThrough = passThrough;
    }

    public void activate() {
        this.showNotify();
    }

    public void deactivate() {
        this.hideNotify();
    }

    public void suspend() {
        this.mySuspended = true;
    }

    public void resume() {
        this.mySuspended = false;
        this.restartTimer();
    }

    @Override
    public void hideNotify() {
        if (!this.myActive) {
            return;
        }
        this.myActive = false;
        this.finishActivity();
        this.clearWaiter();
    }

    @Override
    public void showNotify() {
        if (this.myActive) {
            return;
        }
        this.myActive = true;
        this.restartTimer();
        this.flush();
    }

    public void restartTimer() {
        this.restart(this.myMergingTimeSpan);
    }

    private void restart(int mergingTimeSpan) {
        if (!this.myActive) {
            return;
        }
        this.clearWaiter();
        if (this.myExecuteInDispatchThread) {
            this.myWaiterForMerge.addRequest((Runnable)this, mergingTimeSpan, this.getMergerModalityState());
        } else {
            this.myWaiterForMerge.addRequest((Runnable)this, mergingTimeSpan);
        }
    }

    @Override
    public void run() {
        if (this.mySuspended) {
            return;
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map<Update, Update> map = this.myScheduledUpdates;
        synchronized (map) {
            if (this.myScheduledUpdates.isEmpty()) {
                this.finishActivity();
                return;
            }
        }
        this.flush(true);
    }

    public void flush(boolean invokeLaterIfNotDispatch) {
        if (this.myFlushing) {
            return;
        }
        if (!this.isModalityStateCorrect()) {
            return;
        }
        this.myFlushing = true;
        Runnable toRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Update[] all;
                    Map map = MergingUpdateQueue.this.myScheduledUpdates;
                    synchronized (map) {
                        all = MergingUpdateQueue.this.myScheduledUpdates.keySet().toArray(new Update[MergingUpdateQueue.this.myScheduledUpdates.size()]);
                        MergingUpdateQueue.this.myScheduledUpdates.clear();
                    }
                    for (Update each : all) {
                        each.setProcessed();
                    }
                    MergingUpdateQueue.this.execute(all);
                }
                finally {
                    MergingUpdateQueue.this.myFlushing = false;
                    if (MergingUpdateQueue.this.isEmpty()) {
                        MergingUpdateQueue.this.finishActivity();
                    }
                }
            }
        };
        if (this.myExecuteInDispatchThread && invokeLaterIfNotDispatch) {
            UIUtil.invokeLaterIfNeeded((Runnable)toRun);
        } else {
            toRun.run();
        }
    }

    public void setModalityStateComponent(JComponent modalityStateComponent) {
        this.myModalityStateComponent = modalityStateComponent;
    }

    protected boolean isModalityStateCorrect() {
        ModalityState modalityState;
        if (!this.myExecuteInDispatchThread) {
            return true;
        }
        if (this.myModalityStateComponent == ANY_COMPONENT) {
            return true;
        }
        ModalityState current = ApplicationManager.getApplication().getCurrentModalityState();
        return !current.dominates(modalityState = this.getModalityState());
    }

    public boolean isSuspended() {
        return this.mySuspended;
    }

    private static boolean isExpired(Update each) {
        return each.isDisposed() || each.isExpired();
    }

    protected void execute(Update[] update) {
        for (final Update each : update) {
            if (MergingUpdateQueue.isExpired(each)) {
                each.setRejected();
                continue;
            }
            if (each.executeInWriteAction()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        MergingUpdateQueue.this.execute(each);
                    }
                });
                continue;
            }
            this.execute(each);
        }
    }

    private void execute(Update each) {
        if (this.myDisposed) {
            each.setRejected();
        } else {
            each.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(Update update) {
        if (this.myDisposed) {
            return;
        }
        if (this.myTrackUiActivity) {
            this.startActivity();
        }
        if (this.myPassThrough) {
            update.run();
            this.finishActivity();
            return;
        }
        boolean active = this.myActive;
        Map<Update, Update> map = this.myScheduledUpdates;
        synchronized (map) {
            try {
                if (this.eatThisOrOthers(update)) {
                    return;
                }
                if (active && this.myScheduledUpdates.isEmpty()) {
                    this.restartTimer();
                }
                this.put(update);
                if (this.myRestartOnAdd) {
                    this.restartTimer();
                }
            }
            finally {
                if (this.isEmpty()) {
                    this.finishActivity();
                }
            }
        }
    }

    private boolean eatThisOrOthers(Update update) {
        Update[] updates;
        if (this.myScheduledUpdates.containsKey(update)) {
            return false;
        }
        for (Update eachInQueue : updates = this.myScheduledUpdates.keySet().toArray(new Update[this.myScheduledUpdates.size()])) {
            if (eachInQueue.canEat(update)) {
                return true;
            }
            if (!update.canEat(eachInQueue)) continue;
            this.myScheduledUpdates.remove(eachInQueue);
            eachInQueue.setRejected();
        }
        return false;
    }

    public final void run(Update update) {
        this.execute(new Update[]{update});
    }

    private void put(Update update) {
        Update existing = this.myScheduledUpdates.remove(update);
        if (existing != null && existing != update) {
            existing.setProcessed();
            existing.setRejected();
        }
        this.myScheduledUpdates.put(update, update);
    }

    public boolean isActive() {
        return this.myActive;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myActive = false;
        this.finishActivity();
        this.clearWaiter();
    }

    private void clearWaiter() {
        this.myWaiterForMerge.cancelAllRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<Update, Update> map = this.myScheduledUpdates;
        synchronized (map) {
            return this.myName + " active=" + this.myActive + " scheduled=" + this.myScheduledUpdates.size();
        }
    }

    private ModalityState getMergerModalityState() {
        return this.myModalityStateComponent == ANY_COMPONENT ? null : this.getModalityState();
    }

    public ModalityState getModalityState() {
        if (this.myModalityStateComponent == null) {
            return ModalityState.NON_MODAL;
        }
        return ModalityState.stateForComponent(this.myModalityStateComponent);
    }

    public void setActivationComponent(JComponent c) {
        if (this.myUiNotifyConnector != null) {
            Disposer.dispose((Disposable)this.myUiNotifyConnector);
        }
        UiNotifyConnector connector = new UiNotifyConnector(c, this);
        Disposer.register((Disposable)this, (Disposable)connector);
        this.myUiNotifyConnector = connector;
    }

    public MergingUpdateQueue setRestartTimerOnAdd(boolean restart) {
        this.myRestartOnAdd = restart;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<Update, Update> map = this.myScheduledUpdates;
        synchronized (map) {
            return this.myScheduledUpdates.isEmpty();
        }
    }

    public void sendFlush() {
        this.restart(0);
    }

    public boolean isFlushing() {
        return this.myFlushing;
    }

    public void setTrackUiActivity(boolean trackUiActivity) {
        if (this.myTrackUiActivity && !trackUiActivity) {
            this.finishActivity();
        }
        this.myTrackUiActivity = trackUiActivity;
    }

    private void startActivity() {
        if (!this.myTrackUiActivity) {
            return;
        }
        UiActivityMonitor.getInstance().addActivity(this.getActivityId(), this.getModalityState());
    }

    private void finishActivity() {
        if (!this.myTrackUiActivity) {
            return;
        }
        UiActivityMonitor.getInstance().removeActivity(this.getActivityId());
    }

    protected UiActivity getActivityId() {
        if (this.myUiActivity == null) {
            this.myUiActivity = new UiActivity.AsyncBgOperation("UpdateQueue:" + this.myName + this.hashCode());
        }
        return this.myUiActivity;
    }
}

