/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.util.ui.OptionsMessageDialog;
import javax.swing.Icon;

public class ConfirmationDialog
extends OptionsMessageDialog {
    private final VcsShowConfirmationOption myOption;
    private String myDoNotShowAgainMessage;
    private final String myOkActionName;
    private final String myCancelActionName;

    public static boolean requestForConfirmation(VcsShowConfirmationOption option, Project project, String message, String title, Icon icon) {
        return ConfirmationDialog.requestForConfirmation(option, project, message, title, icon, null, null);
    }

    public static boolean requestForConfirmation(VcsShowConfirmationOption option, Project project, String message, String title, Icon icon, String okActionName, String cancelActionName) {
        if (option.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return false;
        }
        ConfirmationDialog dialog = new ConfirmationDialog(project, message, title, icon, option, okActionName, cancelActionName);
        if (!option.isPersistent()) {
            dialog.setDoNotAskOption(null);
        } else {
            dialog.setDoNotShowAgainMessage(CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]));
        }
        return dialog.showAndGet();
    }

    public ConfirmationDialog(Project project, String message, String title, Icon icon, VcsShowConfirmationOption option) {
        this(project, message, title, icon, option, null, null);
    }

    public ConfirmationDialog(Project project, String message, String title, Icon icon, VcsShowConfirmationOption option, String okActionName, String cancelActionName) {
        super(project, message, title, icon);
        this.myOption = option;
        this.myOkActionName = okActionName != null ? okActionName : CommonBundle.getYesButtonText();
        this.myCancelActionName = cancelActionName != null ? cancelActionName : CommonBundle.getNoButtonText();
        this.init();
    }

    public void setDoNotShowAgainMessage(String doNotShowAgainMessage) {
        this.myDoNotShowAgainMessage = doNotShowAgainMessage;
        this.myCheckBoxDoNotShowDialog.setText(doNotShowAgainMessage);
    }

    @Override
    protected String getDoNotShowMessage() {
        return this.myDoNotShowAgainMessage == null ? super.getDoNotShowMessage() : this.myDoNotShowAgainMessage;
    }

    @Override
    protected String getOkActionName() {
        return this.myOkActionName;
    }

    @Override
    protected String getCancelActionName() {
        return this.myCancelActionName;
    }

    @Override
    protected boolean isToBeShown() {
        return this.myOption.getValue() == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
    }

    @Override
    protected void setToBeShown(boolean value, boolean onOk) {
        VcsShowConfirmationOption.Value optionValue = value ? VcsShowConfirmationOption.Value.SHOW_CONFIRMATION : (onOk ? VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY : VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY);
        this.myOption.setValue(optionValue);
    }

    @Override
    protected boolean shouldSaveOptionsOnCancel() {
        return true;
    }
}

