/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;

public class PsiNavigateUtil {
    public static void navigate(PsiElement psiElement) {
        if (psiElement != null && psiElement.isValid()) {
            PsiElement navigationElement = psiElement.getNavigationElement();
            int offset = navigationElement instanceof PsiFile ? -1 : navigationElement.getTextOffset();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile(psiElement);
            if (virtualFile != null && virtualFile.isValid()) {
                new OpenFileDescriptor(navigationElement.getProject(), virtualFile, offset).navigate(true);
            } else if (navigationElement instanceof Navigatable) {
                ((Navigatable)((Object)navigationElement)).navigate(true);
            }
        }
    }
}

