/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.DefaultResultConsumer;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.concurrency.SameThreadExecutor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class MergeQuery<T>
implements Query<T> {
    private final Query<? extends T> myQuery1;
    private final Query<? extends T> myQuery2;

    public MergeQuery(Query<? extends T> query1, Query<? extends T> query2) {
        this.myQuery1 = query1;
        this.myQuery2 = query2;
    }

    @Override
    public Collection<T> findAll() {
        ArrayList results = new ArrayList();
        this.forEach((Processor<T>)new CommonProcessors.CollectProcessor(results));
        return results;
    }

    @Override
    public T findFirst() {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<T>)processor);
        return (T)processor.getFoundValue();
    }

    @Override
    public boolean forEach(Processor<T> consumer) {
        return this.processSubQuery(consumer, this.myQuery1) && this.processSubQuery(consumer, this.myQuery2);
    }

    @Override
    public AsyncFuture<Boolean> forEachAsync(final Processor<T> consumer) {
        final AsyncFutureResult<Boolean> result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        AsyncFuture<Boolean> fq = this.processSubQueryAsync(consumer, this.myQuery1);
        fq.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer<Boolean>)new DefaultResultConsumer<Boolean>(result){

            @Override
            public void onSuccess(Boolean value) {
                if (value.booleanValue()) {
                    AsyncFuture fq2 = MergeQuery.this.processSubQueryAsync(consumer, MergeQuery.this.myQuery2);
                    fq2.addConsumer(SameThreadExecutor.INSTANCE, new DefaultResultConsumer(result));
                } else {
                    result.set(false);
                }
            }
        });
        return result;
    }

    private <V extends T> boolean processSubQuery(Processor<T> consumer, Query<V> query1) {
        return query1.forEach(consumer);
    }

    private <V extends T> AsyncFuture<Boolean> processSubQueryAsync(Processor<T> consumer, Query<V> query1) {
        return query1.forEachAsync(consumer);
    }

    @Override
    public T[] toArray(T[] a) {
        Collection<T> results = this.findAll();
        return results.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }
}

