/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.util.OpenSourceUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;

public class EditSourceOnEnterKeyHandler {
    public static void install(final JTree tree) {
        tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    DataContext dataContext = DataManager.getInstance().getDataContext(tree);
                    Project project = CommonDataKeys.PROJECT.getData(dataContext);
                    if (project == null) {
                        return;
                    }
                    OpenSourceUtil.openSourcesFrom(dataContext, false);
                }
            }
        });
    }

    public static void install(final JComponent component, final Runnable whenPerformed) {
        component.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext(component);
                OpenSourceUtil.openSourcesFrom(dataContext, true);
                if (whenPerformed != null) {
                    whenPerformed.run();
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
    }

    public static void install(final Runnable before, final JComponent component, final Runnable whenPerformed) {
        component.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext(component);
                if (before != null) {
                    before.run();
                }
                OpenSourceUtil.openSourcesFrom(dataContext, true);
                if (whenPerformed != null) {
                    whenPerformed.run();
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
    }
}

