/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class EditSourceOnDoubleClickHandler {
    private EditSourceOnDoubleClickHandler() {
    }

    public static void install(JTree tree, Runnable whenPerformed) {
        new TreeMouseListener(tree, whenPerformed).installOn(tree);
    }

    public static void install(JTree tree) {
        EditSourceOnDoubleClickHandler.install(tree, null);
    }

    public static void install(final TreeTable treeTable) {
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(MouseEvent e) {
                if (ModalityState.current().dominates(ModalityState.NON_MODAL)) {
                    return false;
                }
                if (treeTable.getTree().getPathForLocation(e.getX(), e.getY()) == null) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(treeTable);
                Project project = CommonDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return false;
                }
                OpenSourceUtil.openSourcesFrom(dataContext, true);
                return true;
            }
        }.installOn(treeTable);
    }

    public static void install(final JTable table) {
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(MouseEvent e) {
                if (ModalityState.current().dominates(ModalityState.NON_MODAL)) {
                    return false;
                }
                if (table.columnAtPoint(e.getPoint()) < 0) {
                    return false;
                }
                if (table.rowAtPoint(e.getPoint()) < 0) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(table);
                Project project = CommonDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return false;
                }
                OpenSourceUtil.openSourcesFrom(dataContext, true);
                return true;
            }
        }.installOn(table);
    }

    public static void install(final JList list, final Runnable whenPerformed) {
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(MouseEvent e) {
                Point point = e.getPoint();
                int index = list.locationToIndex(point);
                if (index == -1) {
                    return false;
                }
                if (!list.getCellBounds(index, index).contains(point)) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(list);
                OpenSourceUtil.openSourcesFrom(dataContext, true);
                whenPerformed.run();
                return true;
            }
        }.installOn(list);
    }

    public static class TreeMouseListener
    extends DoubleClickListener {
        private final JTree myTree;
        private final Runnable myWhenPerformed;

        public TreeMouseListener(JTree tree) {
            this(tree, null);
        }

        public TreeMouseListener(JTree tree, Runnable whenPerformed) {
            this.myTree = tree;
            this.myWhenPerformed = whenPerformed;
        }

        @Override
        public boolean onDoubleClick(MouseEvent e) {
            TreePath clickPath;
            TreePath treePath = clickPath = this.myTree.getUI() instanceof WideSelectionTreeUI ? this.myTree.getClosestPathForLocation(e.getX(), e.getY()) : this.myTree.getPathForLocation(e.getX(), e.getY());
            if (clickPath == null) {
                return false;
            }
            DataContext dataContext = DataManager.getInstance().getDataContext(this.myTree);
            Project project = CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return false;
            }
            TreePath selectionPath = this.myTree.getSelectionPath();
            if (selectionPath == null || !clickPath.equals(selectionPath)) {
                return false;
            }
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (((TreeNode)lastPathComponent).isLeaf() || !TreeMouseListener.expandOnDoubleClick((TreeNode)lastPathComponent)) {
                this.processDoubleClick(e, dataContext, (TreeNode)lastPathComponent);
                return true;
            }
            return false;
        }

        protected void processDoubleClick(MouseEvent e, DataContext dataContext, TreeNode lastPathComponent) {
            OpenSourceUtil.openSourcesFrom(dataContext, true);
            if (this.myWhenPerformed != null) {
                this.myWhenPerformed.run();
            }
        }

        private static boolean expandOnDoubleClick(TreeNode treeNode) {
            Object userObject;
            if (treeNode instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)treeNode).getUserObject()) instanceof NodeDescriptor) {
                return ((NodeDescriptor)userObject).expandOnDoubleClick();
            }
            return true;
        }
    }
}

