/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.usages.UsageView;
import com.intellij.util.BitUtil;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public abstract class Node
extends DefaultMutableTreeNode {
    protected final DefaultTreeModel myTreeModel;
    private String myCachedText;
    private byte myCachedFlags;
    private static final byte INVALID_MASK = 1;
    private static final byte READ_ONLY_MASK = 2;
    private static final byte READ_ONLY_COMPUTED_MASK = 4;
    private static final byte EXCLUDED_MASK = 8;
    private static final byte UPDATED_MASK = 16;

    private boolean isFlagSet(@FlagConstant byte mask) {
        return BitUtil.isSet((byte)this.myCachedFlags, (byte)mask);
    }

    private void setFlag(@FlagConstant byte mask, boolean value) {
        this.myCachedFlags = BitUtil.set((byte)this.myCachedFlags, (byte)mask, (boolean)value);
    }

    protected Node(DefaultTreeModel model) {
        this.myTreeModel = model;
    }

    public abstract String tree2string(int var1, String var2);

    protected abstract boolean isDataValid();

    protected abstract boolean isDataReadOnly();

    protected abstract boolean isDataExcluded();

    protected abstract String getText(UsageView var1);

    public final boolean isValid() {
        return !this.isFlagSet((byte)1);
    }

    public final boolean isReadOnly() {
        boolean result;
        boolean computed = this.isFlagSet((byte)4);
        if (computed) {
            result = this.isFlagSet((byte)2);
        } else {
            result = this.isDataReadOnly();
            this.setFlag((byte)4, true);
            this.setFlag((byte)2, result);
        }
        return result;
    }

    public final boolean isExcluded() {
        return this.isFlagSet((byte)8);
    }

    public final void update(UsageView view) {
        boolean isDataValid = this.isDataValid();
        boolean isReadOnly = this.isDataReadOnly();
        boolean isExcluded = this.isDataExcluded();
        String text = this.getText(view);
        boolean cachedValid = this.isValid();
        boolean cachedReadOnly = this.isFlagSet((byte)2);
        boolean cachedExcluded = this.isFlagSet((byte)8);
        if (isDataValid != cachedValid || isReadOnly != cachedReadOnly || isExcluded != cachedExcluded || !Comparing.equal((String)this.myCachedText, (String)text)) {
            this.setFlag((byte)1, !isDataValid);
            this.setFlag((byte)2, isReadOnly);
            this.setFlag((byte)8, isExcluded);
            this.myCachedText = text;
            this.updateNotify();
            this.myTreeModel.nodeChanged(this);
        }
        this.setFlag((byte)16, true);
    }

    void markNeedUpdate() {
        this.setFlag((byte)16, false);
    }

    boolean needsUpdate() {
        return !this.isFlagSet((byte)16);
    }

    protected void updateNotify() {
    }

    private static @interface FlagConstant {
    }
}

