/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiElement;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.rules.PsiElementUsage;

public abstract class UsageViewManager {
    public static UsageViewManager getInstance(Project project) {
        return ServiceManager.getService(project, UsageViewManager.class);
    }

    public abstract UsageView createUsageView(UsageTarget[] var1, Usage[] var2, UsageViewPresentation var3, Factory<UsageSearcher> var4);

    public abstract UsageView showUsages(UsageTarget[] var1, Usage[] var2, UsageViewPresentation var3, Factory<UsageSearcher> var4);

    public abstract UsageView showUsages(UsageTarget[] var1, Usage[] var2, UsageViewPresentation var3);

    public abstract UsageView searchAndShowUsages(UsageTarget[] var1, Factory<UsageSearcher> var2, boolean var3, boolean var4, UsageViewPresentation var5, UsageViewStateListener var6);

    public abstract void searchAndShowUsages(UsageTarget[] var1, Factory<UsageSearcher> var2, FindUsagesProcessPresentation var3, UsageViewPresentation var4, UsageViewStateListener var5);

    public abstract UsageView getSelectedUsageView();

    public static boolean isSelfUsage(final Usage usage, final UsageTarget[] searchForTarget) {
        if (!(usage instanceof PsiElementUsage)) {
            return false;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            public Boolean compute() {
                PsiElement element = ((PsiElementUsage)usage).getElement();
                if (element == null) {
                    return false;
                }
                for (UsageTarget ut : searchForTarget) {
                    if (!(ut instanceof PsiElementUsageTarget) || !UsageViewManager.isSelfUsage(element, ((PsiElementUsageTarget)ut).getElement())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private static boolean isSelfUsage(PsiElement element, PsiElement psiElement) {
        return element.getParent() == psiElement;
    }

    public static interface UsageViewStateListener {
        public void usageViewCreated(UsageView var1);

        public void findingUsagesFinished(UsageView var1);
    }
}

