/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageViewPresentation;

public class UsageLimitUtil {
    public static final int USAGES_LIMIT = 1000;

    public static void showAndCancelIfAborted(Project project, String message, UsageViewPresentation usageViewPresentation) {
        Result retCode = UsageLimitUtil.showTooManyUsagesWarning(project, message, usageViewPresentation);
        if (retCode != Result.CONTINUE) {
            throw new ProcessCanceledException();
        }
    }

    public static Result showTooManyUsagesWarning(final Project project, final String message, final UsageViewPresentation usageViewPresentation) {
        int result = UsageLimitUtil.runOrInvokeAndWait(new Computable<Integer>(){

            public Integer compute() {
                String title = UsageViewBundle.message("find.excessive.usages.title", StringUtil.capitalize((String)StringUtil.pluralize((String)usageViewPresentation.getUsagesWord())));
                return Messages.showOkCancelDialog(project, message, title, UsageViewBundle.message("button.text.continue", new Object[0]), UsageViewBundle.message("button.text.abort", new Object[0]), Messages.getWarningIcon());
            }
        });
        return result == 0 ? Result.CONTINUE : Result.ABORT;
    }

    private static int runOrInvokeAndWait(final Computable<Integer> f) {
        final int[] answer = new int[1];
        try {
            GuiUtils.runOrInvokeAndWait(new Runnable(){

                @Override
                public void run() {
                    answer[0] = (Integer)f.compute();
                }
            });
        }
        catch (Exception e) {
            answer[0] = 0;
        }
        return answer[0];
    }

    public static enum Result {
        CONTINUE,
        ABORT;

    }
}

