/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.impl.rules.UsageType;

public class TextChunk {
    public static final TextChunk[] EMPTY_ARRAY = new TextChunk[0];
    private final AttributesFlyweight myAttributes;
    private final String myText;
    private final UsageType myType;

    public TextChunk(TextAttributes attributes, String text) {
        this(attributes, text, null);
    }

    public TextChunk(TextAttributes attributes, String text, UsageType type) {
        this.myAttributes = attributes.getFlyweight();
        this.myText = text;
        this.myType = type;
    }

    public TextAttributes getAttributes() {
        return TextAttributes.fromFlyweight(this.myAttributes);
    }

    public String getText() {
        return this.myText;
    }

    public String toString() {
        return this.getText();
    }

    public UsageType getType() {
        return this.myType;
    }

    public SimpleTextAttributes getSimpleAttributesIgnoreBackground() {
        SimpleTextAttributes simples = SimpleTextAttributes.fromTextAttributes(this.getAttributes());
        simples = new SimpleTextAttributes(null, simples.getFgColor(), simples.getWaveColor(), simples.getStyle());
        return simples;
    }
}

