/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.tabs.impl.ShapeTransform;
import com.intellij.ui.tabs.impl.TabLabel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class TabLayout {
    public ShapeTransform createShapeTransform(Dimension dimension) {
        return this.createShapeTransform(new Rectangle(0, 0, dimension.width, dimension.height));
    }

    public ShapeTransform createShapeTransform(Rectangle rectangle) {
        return new ShapeTransform.Top(rectangle);
    }

    public boolean isDragOut(TabLabel tabLabel, int deltaX, int deltaY) {
        return (double)Math.abs(deltaY) > (double)tabLabel.getSize().height * TabLayout.getDragOutMultiplier();
    }

    public boolean isSideComponentOnTabs() {
        return false;
    }

    public static double getDragOutMultiplier() {
        return Registry.doubleValue((String)"ide.tabbedPane.dragOutMultiplier");
    }

    public abstract int getDropIndexFor(Point var1);
}

