/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.switcher.SwitchProvider;
import com.intellij.ui.switcher.SwitchTarget;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.JBTabsPresentation;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.DragHelper;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.ShapeTransform;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.TabsBorder;
import com.intellij.ui.tabs.impl.singleRow.ScrollableSingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import com.intellij.ui.tabs.impl.table.TableLayout;
import com.intellij.ui.tabs.impl.table.TablePassInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FluentIterable;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.LazyUiDisposable;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;

public class JBTabsImpl
extends JComponent
implements JBTabs,
PropertyChangeListener,
TimerListener,
DataProvider,
PopupMenuListener,
Disposable,
JBTabsPresentation,
Queryable,
QuickActionProvider {
    public static final DataKey<JBTabsImpl> NAVIGATION_ACTIONS_KEY = DataKey.create("JBTabs");
    public static final Color MAC_AQUA_BG_COLOR = Gray._200;
    private static final Comparator<TabInfo> ABC_COMPARATOR = new Comparator<TabInfo>(){

        @Override
        public int compare(TabInfo o1, TabInfo o2) {
            return StringUtil.naturalCompare((String)o1.getText(), (String)o2.getText());
        }
    };
    final ActionManager myActionManager;
    private final List<TabInfo> myVisibleInfos = new ArrayList<TabInfo>();
    private final Map<TabInfo, Integer> myHiddenInfos = new HashMap<TabInfo, Integer>();
    private TabInfo mySelectedInfo;
    public final Map<TabInfo, TabLabel> myInfo2Label = new HashMap<TabInfo, TabLabel>();
    public final Map<TabInfo, Toolbar> myInfo2Toolbar = new HashMap<TabInfo, Toolbar>();
    public Dimension myHeaderFitSize;
    private Insets myInnerInsets = JBUI.emptyInsets();
    private final List<EventListener> myTabMouseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<TabsListener> myTabListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myFocused;
    private Getter<ActionGroup> myPopupGroup;
    private String myPopupPlace;
    TabInfo myPopupInfo;
    final DefaultActionGroup myNavigationActions;
    final PopupMenuListener myPopupListener;
    JPopupMenu myActivePopup;
    public boolean myHorizontalSide = true;
    private boolean myStealthTabMode = false;
    private boolean mySideComponentOnTabs = true;
    private boolean mySizeBySelected;
    private DataProvider myDataProvider;
    private final WeakHashMap<Component, Component> myDeferredToRemove = new WeakHashMap();
    private SingleRowLayout mySingleRowLayout;
    private final TableLayout myTableLayout = new TableLayout(this);
    private TabLayout myLayout;
    private LayoutPassInfo myLastLayoutPass;
    private TabInfo myLastPaintedSelection;
    public boolean myForcedRelayout;
    private UiDecorator myUiDecorator;
    static final UiDecorator ourDefaultDecorator = new DefaultDecorator();
    private boolean myPaintFocus;
    private boolean myHideTabs = false;
    private Project myProject;
    private boolean myRequestFocusOnLastFocusedComponent = false;
    private boolean myListenerAdded;
    final Set<TabInfo> myAttractions = new HashSet<TabInfo>();
    private final Animator myAnimator;
    private List<TabInfo> myAllTabs;
    private boolean myPaintBlocked;
    private BufferedImage myImage;
    private IdeFocusManager myFocusManager;
    private final boolean myAdjustBorders = true;
    boolean myAddNavigationGroup = true;
    private boolean myGhostsAlwaysVisible = false;
    private boolean myDisposed;
    private boolean myToDrawBorderIfTabsHidden = true;
    private Color myActiveTabFillIn;
    private boolean myTabLabelActionsAutoHide;
    private final TabActionsAutoHideListener myTabActionsAutoHideListener = new TabActionsAutoHideListener();
    private IdeGlassPane myGlassPane;
    private static final String LAYOUT_DONE = "Layout.done";
    public static final String STRETCHED_BY_WIDTH = "Layout.stretchedByWidth";
    private TimedDeadzone.Length myTabActionsMouseDeadzone = TimedDeadzone.DEFAULT;
    private long myRemoveDeferredRequest;
    private boolean myTestMode;
    private JBTabsPosition myPosition = JBTabsPosition.top;
    private final TabsBorder myBorder = new TabsBorder(this);
    private final BaseNavigationAction myNextAction;
    private final BaseNavigationAction myPrevAction;
    private boolean myTabDraggingEnabled;
    private DragHelper myDragHelper;
    private boolean myNavigationActionsEnabled = true;
    private boolean myUseBufferedPaint = true;
    private boolean myOwnSwitchProvider = true;
    private SwitchProvider mySwitchDelegate;
    protected TabInfo myDropInfo;
    private int myDropInfoIndex;
    protected boolean myShowDropLocation = true;
    private TabInfo myOldSelection;
    private JBTabs.SelectionChangeHandler mySelectionChangeHandler;
    private Runnable myDeferredFocusRequest;
    private boolean myAlwaysPaintSelectedTab;
    private int myFirstTabOffset;

    public JBTabsImpl(Project project) {
        this(project, project);
    }

    private JBTabsImpl(Project project, Disposable parent) {
        this(project, ActionManager.getInstance(), IdeFocusManager.getInstance(project), parent);
    }

    public JBTabsImpl(Project project, IdeFocusManager focusManager, Disposable parent) {
        this(project, ActionManager.getInstance(), focusManager, parent);
    }

    public JBTabsImpl(Project project, ActionManager actionManager, IdeFocusManager focusManager, Disposable parent) {
        this.myProject = project;
        this.myActionManager = actionManager;
        this.myFocusManager = focusManager != null ? focusManager : IdeFocusManager.getGlobalInstance();
        this.setOpaque(true);
        this.setPaintBorder(-1, -1, -1, -1);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myNavigationActions = new DefaultActionGroup();
        this.myNextAction = new SelectNextAction(this, this.myActionManager);
        this.myPrevAction = new SelectPreviousAction(this, this.myActionManager);
        this.myNavigationActions.add(this.myNextAction);
        this.myNavigationActions.add(this.myPrevAction);
        this.setUiDecorator(null);
        this.mySingleRowLayout = this.createSingleRowLayout();
        this.myLayout = this.mySingleRowLayout;
        this.myPopupListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                JBTabsImpl.this.disposePopupListener();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                JBTabsImpl.this.disposePopupListener();
            }
        };
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout != null && ((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout.moreRect != null && ((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout.moreRect.contains(e.getPoint())) {
                    JBTabsImpl.this.showMorePopup(e);
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout != null) {
                    JBTabsImpl.this.mySingleRowLayout.scroll(e.getUnitsToScroll() * JBTabsImpl.this.mySingleRowLayout.getScrollUnitIncrement());
                    JBTabsImpl.this.revalidateAndRepaint(false);
                }
            }
        });
        UISettings.getInstance().addUISettingsListener(new UISettingsListener(){

            @Override
            public void uiSettingsChanged(UISettings source) {
                JBTabsImpl.this.myImage = null;
                for (Map.Entry<TabInfo, TabLabel> entry : JBTabsImpl.this.myInfo2Label.entrySet()) {
                    entry.getKey().revalidate();
                    entry.getValue().setInactiveStateImage(null);
                }
                boolean oldHideTabsIfNeed = JBTabsImpl.this.mySingleRowLayout instanceof ScrollableSingleRowLayout;
                boolean newHideTabsIfNeed = UISettings.getInstance().HIDE_TABS_IF_NEED;
                boolean wasSingleRow = JBTabsImpl.this.isSingleRow();
                if (oldHideTabsIfNeed != newHideTabsIfNeed) {
                    if (JBTabsImpl.this.mySingleRowLayout != null) {
                        JBTabsImpl.this.remove(((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLeftGhost);
                        JBTabsImpl.this.remove(((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myRightGhost);
                    }
                    JBTabsImpl.this.mySingleRowLayout = JBTabsImpl.this.createSingleRowLayout();
                    if (wasSingleRow) {
                        JBTabsImpl.this.myLayout = JBTabsImpl.this.mySingleRowLayout;
                    }
                    JBTabsImpl.this.add(((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLeftGhost);
                    JBTabsImpl.this.add(((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myRightGhost);
                    JBTabsImpl.this.relayout(true, true);
                }
            }
        }, this);
        this.myAnimator = new Animator("JBTabs Attractions", 2, 500, true){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                JBTabsImpl.this.repaintAttractions();
            }
        };
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return JBTabsImpl.this.getToFocus();
            }
        });
        this.add(this.mySingleRowLayout.myLeftGhost);
        this.add(this.mySingleRowLayout.myRightGhost);
        new LazyUiDisposable<JBTabsImpl>(parent, (JComponent)this, this){

            @Override
            protected void initialize(Disposable parent, JBTabsImpl child, Project project) {
                if (JBTabsImpl.this.myProject == null && project != null) {
                    JBTabsImpl.this.myProject = project;
                }
                Disposer.register((Disposable)child, (Disposable)JBTabsImpl.this.myAnimator);
                Disposer.register((Disposable)child, (Disposable)new Disposable(){

                    public void dispose() {
                        JBTabsImpl.this.removeTimerUpdate();
                    }
                });
                if (!JBTabsImpl.this.myTestMode) {
                    IdeGlassPane gp = IdeGlassPaneUtil.find(child);
                    if (gp != null) {
                        gp.addMouseMotionPreprocessor(JBTabsImpl.this.myTabActionsAutoHideListener, child);
                        JBTabsImpl.this.myGlassPane = gp;
                    }
                    UIUtil.addAwtListener((AWTEventListener)new AWTEventListener(){

                        @Override
                        public void eventDispatched(AWTEvent event) {
                            if (((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myMorePopup != null) {
                                return;
                            }
                            JBTabsImpl.this.processFocusChange();
                        }
                    }, (long)4L, (Disposable)child);
                    JBTabsImpl.this.myDragHelper = new DragHelper(child);
                    JBTabsImpl.this.myDragHelper.start();
                }
                if (JBTabsImpl.this.myProject != null && JBTabsImpl.this.myFocusManager == IdeFocusManager.getGlobalInstance()) {
                    JBTabsImpl.this.myFocusManager = IdeFocusManager.getInstance(JBTabsImpl.this.myProject);
                }
            }
        };
        UIUtil.putClientProperty((JComponent)this, (Key)JBSwingUtilities.NOT_IN_HIERARCHY_COMPONENTS, (Object)new Iterable<JComponent>(){

            @Override
            public Iterator<JComponent> iterator() {
                return FluentIterable.from(JBTabsImpl.this.getVisibleInfos()).filter(Conditions.not((Condition)Conditions.is((Object)JBTabsImpl.this.mySelectedInfo))).transform((Function)new Function<TabInfo, JComponent>(){

                    public JComponent fun(TabInfo info) {
                        return info.getComponent();
                    }
                }).iterator();
            }
        });
    }

    protected SingleRowLayout createSingleRowLayout() {
        return new SingleRowLayout(this);
    }

    @Override
    public JBTabs setNavigationActionBinding(String prevActionId, String nextActionId) {
        if (this.myNextAction != null) {
            this.myNextAction.reconnect(nextActionId);
        }
        if (this.myPrevAction != null) {
            this.myPrevAction.reconnect(prevActionId);
        }
        return this;
    }

    public int getActiveTabUnderlineHeight() {
        return 4;
    }

    public boolean isEditorTabs() {
        return false;
    }

    public boolean supportsCompression() {
        return false;
    }

    @Override
    public JBTabs setNavigationActionsEnabled(boolean enabled) {
        this.myNavigationActionsEnabled = enabled;
        return this;
    }

    @Override
    public final boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public JBTabs setAdditionalSwitchProviderWhenOriginal(SwitchProvider delegate) {
        this.mySwitchDelegate = delegate;
        return this;
    }

    public static Image getComponentImage(TabInfo info) {
        BufferedImage img;
        JComponent cmp = info.getComponent();
        if (cmp.isShowing()) {
            int width = cmp.getWidth();
            int height = cmp.getHeight();
            img = UIUtil.createImage((int)(width > 0 ? width : 500), (int)(height > 0 ? height : 500), (int)2);
            Graphics2D g = img.createGraphics();
            cmp.paint(g);
        } else {
            img = UIUtil.createImage((int)500, (int)500, (int)2);
        }
        return img;
    }

    public void dispose() {
        this.myDisposed = true;
        this.mySelectedInfo = null;
        this.resetTabsCache();
        this.myAttractions.clear();
        this.myVisibleInfos.clear();
        this.myUiDecorator = null;
        this.myImage = null;
        this.myActivePopup = null;
        this.myInfo2Label.clear();
        this.myInfo2Toolbar.clear();
        this.myTabListeners.clear();
    }

    protected void resetTabsCache() {
        this.myAllTabs = null;
    }

    private void processFocusChange() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            this.setFocused(false);
            return;
        }
        if (owner == this || SwingUtilities.isDescendingFrom(owner, this)) {
            this.setFocused(true);
        } else {
            this.setFocused(false);
        }
    }

    private void repaintAttractions() {
        boolean needsUpdate = false;
        for (TabInfo each : this.myVisibleInfos) {
            TabLabel eachLabel = this.myInfo2Label.get(each);
            needsUpdate |= eachLabel.repaintAttraction();
        }
        if (needsUpdate) {
            this.relayout(true, false);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addTimerUpdate();
        if (this.myDeferredFocusRequest != null) {
            Runnable request = this.myDeferredFocusRequest;
            this.myDeferredFocusRequest = null;
            request.run();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.setFocused(false);
        this.removeTimerUpdate();
        if (ScreenUtil.isStandardAddRemoveNotify(this) && this.myGlassPane != null) {
            this.myGlassPane.removeMouseMotionPreprocessor(this.myTabActionsAutoHideListener);
            this.myGlassPane = null;
        }
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
    }

    private void addTimerUpdate() {
        if (!this.myListenerAdded) {
            this.myActionManager.addTimerListener(500, this);
            this.myListenerAdded = true;
        }
    }

    private void removeTimerUpdate() {
        if (this.myListenerAdded) {
            this.myActionManager.removeTimerListener(this);
            this.myListenerAdded = false;
        }
    }

    void setTestMode(boolean testMode) {
        this.myTestMode = testMode;
    }

    public void layoutComp(SingleRowPassInfo data, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
        if (data.hToolbar != null) {
            int toolbarHeight = data.hToolbar.getPreferredSize().height;
            Rectangle compRect = this.layoutComp(deltaX, toolbarHeight + deltaY, data.comp, deltaWidth, deltaHeight);
            this.layout(data.hToolbar, compRect.x, compRect.y - toolbarHeight, compRect.width, toolbarHeight);
        } else if (data.vToolbar != null) {
            int toolbarWidth = data.vToolbar.getPreferredSize().width;
            Rectangle compRect = this.layoutComp(toolbarWidth + deltaX, deltaY, data.comp, deltaWidth, deltaHeight);
            this.layout(data.vToolbar, compRect.x - toolbarWidth, compRect.y, toolbarWidth, compRect.height);
        } else {
            this.layoutComp(deltaX, deltaY, data.comp, deltaWidth, deltaHeight);
        }
    }

    public boolean isDropTarget(TabInfo info) {
        return this.myDropInfo != null && this.myDropInfo == info;
    }

    protected void setDropInfoIndex(int dropInfoIndex) {
        this.myDropInfoIndex = dropInfoIndex;
    }

    public int getFirstTabOffset() {
        return this.myFirstTabOffset;
    }

    public void setFirstTabOffset(int firstTabOffset) {
        this.myFirstTabOffset = firstTabOffset;
    }

    public int tabMSize() {
        return 20;
    }

    @Override
    public ModalityState getModalityState() {
        return ModalityState.stateForComponent(this);
    }

    @Override
    public void run() {
        this.updateTabActions(false);
    }

    public void updateTabActions(boolean validateNow) {
        final Ref changed = new Ref((Object)Boolean.FALSE);
        for (final TabInfo eachInfo : this.myInfo2Label.keySet()) {
            this.updateTab(new Computable<Boolean>(){

                public Boolean compute() {
                    boolean changes = JBTabsImpl.this.myInfo2Label.get(eachInfo).updateTabActions();
                    changed.set((Object)((Boolean)changed.get() != false || changes ? 1 : 0));
                    return changes;
                }
            }, eachInfo);
        }
        if (((Boolean)changed.get()).booleanValue() && validateNow) {
            this.validate();
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public boolean canShowMorePopup() {
        SingleRowPassInfo lastLayout = this.mySingleRowLayout.myLastSingRowLayout;
        return lastLayout != null && lastLayout.moreRect != null;
    }

    public void showMorePopup(MouseEvent e) {
        SingleRowPassInfo lastLayout = this.mySingleRowLayout.myLastSingRowLayout;
        if (lastLayout == null) {
            return;
        }
        this.mySingleRowLayout.myMorePopup = new JBPopupMenu();
        for (final TabInfo each : this.getVisibleInfos()) {
            if (!this.mySingleRowLayout.isTabHidden(each)) continue;
            JBMenuItem item = new JBMenuItem(each.getText(), each.getIcon());
            item.setForeground(each.getDefaultForeground());
            item.setBackground(each.getTabColor());
            this.mySingleRowLayout.myMorePopup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JBTabsImpl.this.select(each, true);
                }
            });
        }
        this.mySingleRowLayout.myMorePopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myMorePopup = null;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                ((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myMorePopup = null;
            }
        });
        if (e != null) {
            this.mySingleRowLayout.myMorePopup.show(this, e.getX(), e.getY());
        } else {
            Rectangle rect = lastLayout.moreRect;
            if (rect != null) {
                this.mySingleRowLayout.myMorePopup.show(this, rect.x, rect.y + rect.height);
            }
        }
    }

    private JComponent getToFocus() {
        JComponent policyToFocus;
        TabInfo info = this.getSelectedInfo();
        if (info == null) {
            return null;
        }
        JComponent toFocus = null;
        if (this.isRequestFocusOnLastFocusedComponent() && info.getLastFocusOwner() != null && !this.isMyChildIsFocusedNow()) {
            toFocus = info.getLastFocusOwner();
        }
        if (toFocus == null && info.getPreferredFocusableComponent() == null) {
            return null;
        }
        if (toFocus == null && (policyToFocus = this.myFocusManager.getFocusTargetFor(toFocus = info.getPreferredFocusableComponent())) != null) {
            toFocus = policyToFocus;
        }
        return toFocus;
    }

    @Override
    public void requestFocus() {
        JComponent toFocus = this.getToFocus();
        if (toFocus != null) {
            toFocus.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        JComponent toFocus = this.getToFocus();
        if (toFocus != null) {
            return toFocus.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public TabInfo addTab(TabInfo info, int index) {
        return this.addTab(info, index, false, true);
    }

    public TabInfo addTabSilently(TabInfo info, int index) {
        return this.addTab(info, index, false, false);
    }

    private TabInfo addTab(TabInfo info, int index, boolean isDropTarget, boolean fireEvents) {
        if (!isDropTarget && this.getTabs().contains(info)) {
            return this.getTabs().get(this.getTabs().indexOf(info));
        }
        info.getChangeSupport().addPropertyChangeListener(this);
        TabLabel label = this.createTabLabel(info);
        this.myInfo2Label.put(info, label);
        if (!isDropTarget) {
            if (index < 0 || index > this.myVisibleInfos.size() - 1) {
                this.myVisibleInfos.add(info);
            } else {
                this.myVisibleInfos.add(index, info);
            }
        }
        this.resetTabsCache();
        this.updateText(info);
        this.updateIcon(info);
        this.updateSideComponent(info);
        this.updateTabActions(info);
        this.add(label);
        this.adjust(info);
        this.updateAll(false, false);
        if (info.isHidden()) {
            this.updateHiding();
        }
        if (!isDropTarget && fireEvents && this.getTabCount() == 1) {
            this.fireBeforeSelectionChanged(null, info);
            this.fireSelectionChanged(null, info);
        }
        this.revalidateAndRepaint(false);
        return info;
    }

    protected TabLabel createTabLabel(TabInfo info) {
        return new TabLabel(this, info);
    }

    @Override
    public TabInfo addTab(TabInfo info) {
        return this.addTab(info, -1);
    }

    public ActionGroup getPopupGroup() {
        return this.myPopupGroup != null ? (ActionGroup)this.myPopupGroup.get() : null;
    }

    public String getPopupPlace() {
        return this.myPopupPlace;
    }

    @Override
    public JBTabs setPopupGroup(final ActionGroup popupGroup, String place, boolean addNavigationGroup) {
        return this.setPopupGroup(new Getter<ActionGroup>(){

            public ActionGroup get() {
                return popupGroup;
            }
        }, place, addNavigationGroup);
    }

    public JBTabs setPopupGroup(Getter<ActionGroup> popupGroup, String place, boolean addNavigationGroup) {
        this.myPopupGroup = popupGroup;
        this.myPopupPlace = place;
        this.myAddNavigationGroup = addNavigationGroup;
        return this;
    }

    private void updateAll(boolean forcedRelayout, boolean now) {
        this.mySelectedInfo = this.getSelectedInfo();
        this.updateContainer(forcedRelayout, now);
        this.removeDeferred();
        this.updateListeners();
        this.updateTabActions(false);
        this.updateEnabling();
    }

    private boolean isMyChildIsFocusedNow() {
        JComponent owner = JBTabsImpl.getFocusOwner();
        if (owner == null) {
            return false;
        }
        if (this.mySelectedInfo != null && !SwingUtilities.isDescendingFrom(owner, this.mySelectedInfo.getComponent())) {
            return false;
        }
        return SwingUtilities.isDescendingFrom(owner, this);
    }

    private static JComponent getFocusOwner() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return (JComponent)(owner instanceof JComponent ? owner : null);
    }

    @Override
    public ActionCallback select(TabInfo info, boolean requestFocus) {
        return this._setSelected(info, requestFocus);
    }

    private ActionCallback _setSelected(final TabInfo info, final boolean requestFocus) {
        if (!this.isEnabled()) {
            return ActionCallback.REJECTED;
        }
        if (this.mySelectionChangeHandler != null) {
            return this.mySelectionChangeHandler.execute(info, requestFocus, new ActiveRunnable(){

                @Override
                public ActionCallback run() {
                    return JBTabsImpl.this.executeSelectionChange(info, requestFocus);
                }
            });
        }
        return this.executeSelectionChange(info, requestFocus);
    }

    private ActionCallback executeSelectionChange(TabInfo info, boolean requestFocus) {
        if (this.mySelectedInfo != null && this.mySelectedInfo.equals(info)) {
            if (!requestFocus) {
                return new ActionCallback.Done();
            }
            Component owner = this.myFocusManager.getFocusOwner();
            JComponent c = info.getComponent();
            if (c != null && owner != null && (c == owner || SwingUtilities.isDescendingFrom(owner, c))) {
                return new ActionCallback.Done();
            }
            return this.requestFocus(this.getToFocus());
        }
        if (this.myRequestFocusOnLastFocusedComponent && this.mySelectedInfo != null && this.isMyChildIsFocusedNow()) {
            this.mySelectedInfo.setLastFocusOwner(JBTabsImpl.getFocusOwner());
        }
        TabInfo oldInfo = this.mySelectedInfo;
        this.mySelectedInfo = info;
        TabInfo newInfo = this.getSelectedInfo();
        this.fireBeforeSelectionChanged(oldInfo, newInfo);
        this.updateContainer(false, true);
        this.fireSelectionChanged(oldInfo, newInfo);
        if (requestFocus) {
            JComponent toFocus = this.getToFocus();
            if (this.myProject != null && toFocus != null) {
                final ActionCallback result = new ActionCallback();
                this.requestFocus(toFocus).doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        if (JBTabsImpl.this.myDisposed) {
                            result.setRejected();
                        } else {
                            JBTabsImpl.this.removeDeferred().notifyWhenDone(result);
                        }
                    }
                });
                return result;
            }
            this.requestFocus();
            return this.removeDeferred();
        }
        return this.removeDeferred();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBeforeSelectionChanged(TabInfo oldInfo, TabInfo newInfo) {
        if (oldInfo != newInfo) {
            this.myOldSelection = oldInfo;
            try {
                for (TabsListener eachListener : this.myTabListeners) {
                    eachListener.beforeSelectionChanged(oldInfo, newInfo);
                }
            }
            finally {
                this.myOldSelection = null;
            }
        }
    }

    private void fireSelectionChanged(TabInfo oldInfo, TabInfo newInfo) {
        if (oldInfo != newInfo) {
            for (TabsListener eachListener : this.myTabListeners) {
                if (eachListener == null) continue;
                eachListener.selectionChanged(oldInfo, newInfo);
            }
        }
    }

    void fireTabsMoved() {
        for (TabsListener eachListener : this.myTabListeners) {
            if (eachListener == null) continue;
            eachListener.tabsMoved();
        }
    }

    void fireTabRemoved(TabInfo info) {
        for (TabsListener eachListener : this.myTabListeners) {
            if (eachListener == null) continue;
            eachListener.tabRemoved(info);
        }
    }

    private ActionCallback requestFocus(final JComponent toFocus) {
        if (toFocus == null) {
            return new ActionCallback.Done();
        }
        if (this.myTestMode) {
            toFocus.requestFocus();
            return new ActionCallback.Done();
        }
        if (this.isShowing()) {
            return this.myFocusManager.requestFocus(new FocusCommand.ByComponent(toFocus, new Exception()), true);
        }
        final ActionCallback result = new ActionCallback();
        final FocusRequestor requestor = this.myFocusManager.getFurtherRequestor();
        final Ref queued = new Ref((Object)false);
        Disposer.register((Disposable)requestor, (Disposable)new Disposable(){

            public void dispose() {
                if (!((Boolean)queued.get()).booleanValue()) {
                    result.setRejected();
                }
            }
        });
        this.myDeferredFocusRequest = new Runnable(){

            @Override
            public void run() {
                queued.set((Object)true);
                requestor.requestFocus(new FocusCommand.ByComponent(toFocus, new Exception()), true).notify(result);
            }
        };
        return result;
    }

    private ActionCallback removeDeferred() {
        if (this.myDeferredToRemove.isEmpty()) {
            return ActionCallback.DONE;
        }
        final ActionCallback callback = new ActionCallback();
        final long executionRequest = ++this.myRemoveDeferredRequest;
        Runnable onDone = new Runnable(){

            @Override
            public void run() {
                if (JBTabsImpl.this.myRemoveDeferredRequest == executionRequest) {
                    JBTabsImpl.this.removeDeferredNow();
                }
                callback.setDone();
            }
        };
        this.myFocusManager.doWhenFocusSettlesDown(onDone);
        return callback;
    }

    private void queueForRemove(Component c) {
        if (c instanceof JComponent) {
            this.addToDeferredRemove(c);
        } else {
            this.remove(c);
        }
    }

    private void unqueueFromRemove(Component c) {
        this.myDeferredToRemove.remove(c);
    }

    private void removeDeferredNow() {
        for (Component each : this.myDeferredToRemove.keySet()) {
            if (each == null || each.getParent() != this) continue;
            this.remove(each);
        }
        this.myDeferredToRemove.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        TabInfo tabInfo = (TabInfo)evt.getSource();
        if ("actionGroup".equals(evt.getPropertyName())) {
            this.updateSideComponent(tabInfo);
            this.relayout(false, false);
        } else if ("component".equals(evt.getPropertyName())) {
            this.relayout(true, false);
        } else if ("text".equals(evt.getPropertyName())) {
            this.updateText(tabInfo);
        } else if ("icon".equals(evt.getPropertyName())) {
            this.updateIcon(tabInfo);
        } else if ("color".equals(evt.getPropertyName())) {
            this.updateColor(tabInfo);
        } else if ("alertStatus".equals(evt.getPropertyName())) {
            boolean start = (Boolean)evt.getNewValue();
            this.updateAttraction(tabInfo, start);
        } else if ("tabActionGroup".equals(evt.getPropertyName())) {
            this.updateTabActions(tabInfo);
            this.relayout(false, false);
        } else if ("hidden".equals(evt.getPropertyName())) {
            this.updateHiding();
            this.relayout(false, false);
        } else if ("enabled".equals(evt.getPropertyName())) {
            this.updateEnabling();
        }
    }

    private void updateEnabling() {
        TabInfo toSelect;
        List<TabInfo> all = this.getTabs();
        for (TabInfo each : all) {
            TabLabel eachLabel = this.myInfo2Label.get(each);
            eachLabel.setTabEnabled(each.isEnabled());
        }
        TabInfo selected = this.getSelectedInfo();
        if (selected != null && !selected.isEnabled() && (toSelect = this.getToSelectOnRemoveOf(selected)) != null) {
            this.select(toSelect, this.myFocusManager.getFocusedDescendantFor(this) != null);
        }
    }

    private void updateHiding() {
        boolean update = false;
        Iterator<TabInfo> visible = this.myVisibleInfos.iterator();
        while (visible.hasNext()) {
            TabInfo each = visible.next();
            if (!each.isHidden() || this.myHiddenInfos.containsKey(each)) continue;
            this.myHiddenInfos.put(each, this.myVisibleInfos.indexOf(each));
            visible.remove();
            update = true;
        }
        Iterator<TabInfo> hidden = this.myHiddenInfos.keySet().iterator();
        while (hidden.hasNext()) {
            TabInfo each = hidden.next();
            if (each.isHidden() || !this.myHiddenInfos.containsKey(each)) continue;
            this.myVisibleInfos.add(this.getIndexInVisibleArray(each), each);
            hidden.remove();
            update = true;
        }
        if (update) {
            this.resetTabsCache();
            if (this.mySelectedInfo != null && this.myHiddenInfos.containsKey(this.mySelectedInfo)) {
                this.mySelectedInfo = this.getToSelectOnRemoveOf(this.mySelectedInfo);
            }
            this.updateAll(true, false);
        }
    }

    private int getIndexInVisibleArray(TabInfo each) {
        Integer index = this.myHiddenInfos.get(each);
        if (index == null) {
            index = this.myVisibleInfos.size();
        }
        if (index > this.myVisibleInfos.size()) {
            index = this.myVisibleInfos.size();
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    private void updateIcon(final TabInfo tabInfo) {
        this.updateTab(new Computable<Boolean>(){

            public Boolean compute() {
                JBTabsImpl.this.myInfo2Label.get(tabInfo).setIcon(tabInfo.getIcon());
                return true;
            }
        }, tabInfo);
    }

    private void updateColor(TabInfo tabInfo) {
        this.myInfo2Label.get(tabInfo).setInactiveStateImage(null);
        this.updateTab(new Computable<Boolean>(){

            public Boolean compute() {
                JBTabsImpl.this.repaint();
                return true;
            }
        }, tabInfo);
    }

    private void updateTab(Computable<Boolean> update, TabInfo info) {
        TabLabel label = this.myInfo2Label.get(info);
        Boolean changes = (Boolean)update.compute();
        if (label.getRootPane() != null) {
            if (label.isValid()) {
                if (changes.booleanValue()) {
                    label.repaint();
                }
            } else {
                this.revalidateAndRepaint(false);
            }
        }
    }

    void revalidateAndRepaint(boolean layoutNow) {
        if (this.myVisibleInfos.isEmpty()) {
            this.setOpaque(false);
            Component nonOpaque = UIUtil.findUltimateParent((Component)this);
            if (nonOpaque != null && this.getParent() != null) {
                Rectangle toRepaint = SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), nonOpaque);
                nonOpaque.repaint(toRepaint.x, toRepaint.y, toRepaint.width, toRepaint.height);
            }
        } else {
            this.setOpaque(true);
        }
        if (layoutNow) {
            this.validate();
        } else {
            this.revalidate();
        }
        this.repaint();
    }

    private void updateAttraction(TabInfo tabInfo, boolean start) {
        if (start) {
            this.myAttractions.add(tabInfo);
        } else {
            this.myAttractions.remove(tabInfo);
            tabInfo.setBlinkCount(0);
        }
        if (start && !this.myAnimator.isRunning()) {
            this.myAnimator.resume();
        } else if (!start && this.myAttractions.isEmpty()) {
            this.myAnimator.suspend();
            this.repaintAttractions();
        }
    }

    private void updateText(final TabInfo tabInfo) {
        this.updateTab(new Computable<Boolean>(){

            public Boolean compute() {
                TabLabel label = JBTabsImpl.this.myInfo2Label.get(tabInfo);
                label.setText(tabInfo.getColoredText());
                label.setToolTipText(tabInfo.getTooltipText());
                return true;
            }
        }, tabInfo);
    }

    private void updateSideComponent(TabInfo tabInfo) {
        Toolbar old = this.myInfo2Toolbar.get(tabInfo);
        if (old != null) {
            this.remove(old);
        }
        Toolbar toolbar = this.createToolbarComponent(tabInfo);
        this.myInfo2Toolbar.put(tabInfo, toolbar);
        this.add(toolbar);
    }

    private void updateTabActions(TabInfo info) {
        this.myInfo2Label.get(info).setTabActions(info.getTabLabelActions());
    }

    @Override
    public TabInfo getSelectedInfo() {
        if (this.myOldSelection != null) {
            return this.myOldSelection;
        }
        if (!this.myVisibleInfos.contains(this.mySelectedInfo)) {
            this.mySelectedInfo = null;
        }
        return this.mySelectedInfo != null ? this.mySelectedInfo : (!this.myVisibleInfos.isEmpty() ? this.myVisibleInfos.get(0) : null);
    }

    private TabInfo getToSelectOnRemoveOf(TabInfo info) {
        if (!this.myVisibleInfos.contains(info)) {
            return null;
        }
        if (this.mySelectedInfo != info) {
            return null;
        }
        if (this.myVisibleInfos.size() == 1) {
            return null;
        }
        int index = this.getVisibleInfos().indexOf(info);
        TabInfo result = null;
        if (index > 0) {
            result = this.findEnabledBackward(index, false);
        }
        if (result == null) {
            result = this.findEnabledForward(index, false);
        }
        return result;
    }

    private TabInfo findEnabledForward(int from, boolean cycle) {
        block3: {
            TabInfo each;
            if (from < 0) {
                return null;
            }
            int index = from;
            List<TabInfo> infos = this.getVisibleInfos();
            do {
                if (++index == infos.size()) {
                    if (!cycle) break block3;
                    index = 0;
                }
                if (index == from) break block3;
            } while (!(each = infos.get(index)).isEnabled());
            return each;
        }
        return null;
    }

    public boolean isAlphabeticalMode() {
        return false;
    }

    private TabInfo findEnabledBackward(int from, boolean cycle) {
        block3: {
            TabInfo each;
            if (from < 0) {
                return null;
            }
            int index = from;
            List<TabInfo> infos = this.getVisibleInfos();
            do {
                if (--index == -1) {
                    if (!cycle) break block3;
                    index = infos.size() - 1;
                }
                if (index == from) break block3;
            } while (!(each = infos.get(index)).isEnabled());
            return each;
        }
        return null;
    }

    protected Toolbar createToolbarComponent(TabInfo tabInfo) {
        return new Toolbar(this, tabInfo);
    }

    @Override
    public TabInfo getTabAt(int tabIndex) {
        return this.getTabs().get(tabIndex);
    }

    public List<TabInfo> getTabs() {
        if (this.myAllTabs != null) {
            return this.myAllTabs;
        }
        ArrayList<TabInfo> result = new ArrayList<TabInfo>();
        result.addAll(this.myVisibleInfos);
        for (TabInfo each : this.myHiddenInfos.keySet()) {
            result.add(this.getIndexInVisibleArray(each), each);
        }
        if (this.isAlphabeticalMode()) {
            Collections.sort(result, ABC_COMPARATOR);
        }
        this.myAllTabs = result;
        return result;
    }

    @Override
    public TabInfo getTargetInfo() {
        return this.myPopupInfo != null ? this.myPopupInfo : this.getSelectedInfo();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.resetPopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.resetPopup();
    }

    private void resetPopup() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JBTabsImpl.this.myPopupInfo = null;
            }
        });
    }

    @Override
    public void setPaintBlocked(boolean blocked, boolean takeSnapshot) {
        if (blocked && !this.myPaintBlocked && takeSnapshot && this.getWidth() > 0 && this.getHeight() > 0) {
            this.myImage = UIUtil.createImage((int)this.getWidth(), (int)this.getHeight(), (int)2);
            Graphics2D g = this.myImage.createGraphics();
            super.paint(g);
            g.dispose();
        }
        this.myPaintBlocked = blocked;
        if (!this.myPaintBlocked) {
            if (this.myImage != null) {
                this.myImage.flush();
            }
            this.myImage = null;
            this.repaint();
        }
    }

    private void addToDeferredRemove(Component c) {
        if (!this.myDeferredToRemove.containsKey(c)) {
            this.myDeferredToRemove.put(c, c);
        }
    }

    private boolean isToDrawBorderIfTabsHidden() {
        return this.myToDrawBorderIfTabsHidden;
    }

    @Override
    public JBTabsPresentation setToDrawBorderIfTabsHidden(boolean toDrawBorderIfTabsHidden) {
        this.myToDrawBorderIfTabsHidden = toDrawBorderIfTabsHidden;
        return this;
    }

    @Override
    public JBTabs getJBTabs() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        try {
            this.myHeaderFitSize = this.computeHeaderFitSize();
            Collection<TabLabel> labels = this.myInfo2Label.values();
            for (TabLabel each : labels) {
                each.setTabActionsAutoHide(this.myTabLabelActionsAutoHide);
            }
            ArrayList<TabInfo> visible = new ArrayList<TabInfo>();
            visible.addAll(this.getVisibleInfos());
            if (this.myDropInfo != null && !visible.contains(this.myDropInfo) && this.myShowDropLocation) {
                if (this.getDropInfoIndex() >= 0 && this.getDropInfoIndex() < visible.size()) {
                    visible.add(this.getDropInfoIndex(), this.myDropInfo);
                } else {
                    visible.add(this.myDropInfo);
                }
            }
            if (this.isSingleRow()) {
                this.myLastLayoutPass = this.mySingleRowLayout.layoutSingleRow(visible);
                this.mySingleRowLayout.scroll(0);
                this.myLastLayoutPass = this.mySingleRowLayout.layoutSingleRow(visible);
                this.myTableLayout.myLastTableLayout = null;
            } else {
                this.myLastLayoutPass = this.myTableLayout.layoutTable(visible);
                this.mySingleRowLayout.myLastSingRowLayout = null;
            }
            if (this.isStealthModeEffective() && !this.isHideTabs()) {
                TabLabel label = this.getSelectedLabel();
                Rectangle bounds = label.getBounds();
                Insets insets = this.getLayoutInsets();
                this.layout(label, insets.left, bounds.y, this.getWidth() - insets.right - insets.left, bounds.height);
            }
            this.moveDraggedTabLabel();
            this.myTabActionsAutoHideListener.processMouseOver();
        }
        finally {
            this.myForcedRelayout = false;
        }
        this.applyResetComponents();
    }

    void moveDraggedTabLabel() {
        TabLabel selectedLabel;
        if (this.myDragHelper != null && this.myDragHelper.myDragRec != null && (selectedLabel = this.myInfo2Label.get(this.getSelectedInfo())) != null) {
            Rectangle bounds = selectedLabel.getBounds();
            if (this.isHorizontalTabs()) {
                selectedLabel.setBounds(this.myDragHelper.myDragRec.x, bounds.y, bounds.width, bounds.height);
            } else {
                selectedLabel.setBounds(bounds.x, this.myDragHelper.myDragRec.y, bounds.width, bounds.height);
            }
        }
    }

    private Dimension computeHeaderFitSize() {
        Max max = this.computeMaxSize();
        if (this.myPosition == JBTabsPosition.top || this.myPosition == JBTabsPosition.bottom) {
            return new Dimension(this.getSize().width, this.myHorizontalSide ? Math.max(max.myLabel.height, max.myToolbar.height) : max.myLabel.height);
        }
        return new Dimension(max.myLabel.width + (this.myHorizontalSide ? 0 : max.myToolbar.width), this.getSize().height);
    }

    public Rectangle layoutComp(int componentX, int componentY, JComponent comp, int deltaWidth, int deltaHeight) {
        Insets insets = this.getLayoutInsets();
        Insets border = this.isHideTabs() ? new Insets(0, 0, 0, 0) : this.myBorder.getEffectiveBorder();
        boolean noTabsVisible = this.isStealthModeEffective() || this.isHideTabs();
        Insets inner = this.getInnerInsets();
        border.top += inner.top;
        border.bottom += inner.bottom;
        border.left += inner.left;
        border.right += inner.right;
        int x = insets.left + componentX + border.left;
        int y = insets.top + componentY + border.top;
        int width = this.getWidth() - insets.left - insets.right - componentX - border.left - border.right;
        int height = this.getHeight() - insets.top - insets.bottom - componentY - border.top - border.bottom;
        if (!noTabsVisible) {
            width += deltaWidth;
            height += deltaHeight;
        }
        return this.layout(comp, x, y, width, height);
    }

    @Override
    public JBTabsPresentation setInnerInsets(Insets innerInsets) {
        this.myInnerInsets = innerInsets;
        return this;
    }

    private Insets getInnerInsets() {
        return this.myInnerInsets;
    }

    public Insets getLayoutInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        return insets;
    }

    public int getToolbarInset() {
        return JBTabsImpl.getArcSize() + 1;
    }

    public void resetLayout(boolean resetLabels) {
        if (resetLabels) {
            this.mySingleRowLayout.myLeftGhost.reset();
            this.mySingleRowLayout.myRightGhost.reset();
        }
        for (TabInfo each : this.myVisibleInfos) {
            this.reset(each, resetLabels);
        }
        if (this.myDropInfo != null) {
            this.reset(this.myDropInfo, resetLabels);
        }
        for (TabInfo each : this.myHiddenInfos.keySet()) {
            this.reset(each, resetLabels);
        }
        for (Component eachDeferred : this.myDeferredToRemove.keySet()) {
            JBTabsImpl.resetLayout((JComponent)eachDeferred);
        }
    }

    private void reset(TabInfo each, boolean resetLabels) {
        JComponent c = each.getComponent();
        if (c != null) {
            JBTabsImpl.resetLayout(c);
        }
        JBTabsImpl.resetLayout(this.myInfo2Toolbar.get(each));
        if (resetLabels) {
            JBTabsImpl.resetLayout(this.myInfo2Label.get(each));
        }
    }

    private static int getArcSize() {
        return 4;
    }

    private static int getEdgeArcSize() {
        return 3;
    }

    public int getGhostTabLength() {
        return 15;
    }

    protected JBTabsPosition getPosition() {
        return this.myPosition;
    }

    protected void doPaintBackground(Graphics2D g2d, Rectangle clip) {
        g2d.setColor(this.getBackground());
        g2d.fill(clip);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle compBounds;
        super.paintComponent(g);
        if (this.myVisibleInfos.isEmpty()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        GraphicsConfig config = new GraphicsConfig((Graphics)g2d);
        config.setAntialiasing(true);
        Rectangle clip = g2d.getClipBounds();
        this.doPaintBackground(g2d, clip);
        TabInfo selected = this.getSelectedInfo();
        if (selected != null && (compBounds = selected.getComponent().getBounds()).contains(clip) && !compBounds.intersects(clip)) {
            return;
        }
        boolean leftGhostExists = this.isSingleRow();
        boolean rightGhostExists = this.isSingleRow();
        if (!this.isStealthModeEffective() && !this.isHideTabs()) {
            if (this.isSingleRow() && this.mySingleRowLayout.myLastSingRowLayout.lastGhostVisible) {
                this.paintLastGhost(g2d);
            }
            this.paintNonSelectedTabs(g2d, leftGhostExists, rightGhostExists);
            if (this.isSingleRow() && this.mySingleRowLayout.myLastSingRowLayout.firstGhostVisible) {
                this.paintFirstGhost(g2d);
            }
        }
        config.setAntialiasing(false);
        Toolbar toolbarComp = this.myInfo2Toolbar.get(this.mySelectedInfo);
        if (toolbarComp != null && !toolbarComp.isEmpty()) {
            Rectangle toolBounds = toolbarComp.getBounds();
            g2d.setColor(CaptionPanel.CNT_ACTIVE_BORDER_COLOR);
            if (this.isSideComponentVertical()) {
                g2d.drawLine((int)toolBounds.getMaxX(), toolBounds.y, (int)toolBounds.getMaxX(), (int)toolBounds.getMaxY() - 1);
            } else if (!this.isSideComponentOnTabs()) {
                g2d.drawLine(toolBounds.x, (int)toolBounds.getMaxY(), (int)toolBounds.getMaxX() - 1, (int)toolBounds.getMaxY());
            }
        }
        config.restore();
    }

    protected Color getActiveTabColor(Color c) {
        TabInfo info = this.getSelectedInfo();
        if (info == null) {
            return c;
        }
        Color tabColor = info.getTabColor();
        return tabColor == null ? c : tabColor;
    }

    protected void paintSelectionAndBorder(Graphics2D g2d) {
        Color tabColor;
        Color bgColor;
        if (this.mySelectedInfo == null) {
            return;
        }
        ShapeInfo shapeInfo = this.computeSelectedLabelShape();
        if (!this.isHideTabs()) {
            g2d.setColor(this.getBackground());
            g2d.fill(shapeInfo.fillPath.getShape());
        }
        int paintTopY = shapeInfo.labelTopY;
        int paintBottomY = shapeInfo.labelBottomY;
        boolean paintFocused = this.myPaintFocus && (this.myFocused || this.myActivePopup != null || this.myAlwaysPaintSelectedTab);
        Color bgPreFill = null;
        if (paintFocused) {
            bgColor = this.getActiveTabColor(this.getActiveTabFillIn());
            if (bgColor == null) {
                shapeInfo.from = this.getFocusedTopFillColor();
                shapeInfo.to = this.getFocusedBottomFillColor();
            } else {
                bgPreFill = bgColor;
                int alpha = 255;
                paintBottomY = shapeInfo.labelTopY + shapeInfo.labelPath.deltaY(JBTabsImpl.getArcSize() - 2);
                shapeInfo.from = ColorUtil.toAlpha((Color)UIUtil.getFocusedFillColor(), (int)alpha);
                shapeInfo.to = ColorUtil.toAlpha((Color)this.getActiveTabFillIn(), (int)alpha);
            }
        } else {
            bgColor = this.getActiveTabColor(this.getActiveTabFillIn());
            if (this.isPaintFocus()) {
                if (bgColor == null) {
                    int alpha = 150;
                    shapeInfo.from = ColorUtil.toAlpha((Color)UIUtil.getPanelBackground().brighter(), (int)alpha);
                    shapeInfo.to = ColorUtil.toAlpha((Color)UIUtil.getPanelBackground(), (int)alpha);
                } else {
                    int alpha = 255;
                    shapeInfo.from = ColorUtil.toAlpha((Color)bgColor, (int)alpha);
                    shapeInfo.to = ColorUtil.toAlpha((Color)bgColor, (int)alpha);
                }
            } else {
                int alpha = 255;
                Color tabColor2 = this.getActiveTabColor(null);
                Color defaultBg = UIUtil.isUnderDarcula() ? UIUtil.getControlColor() : Color.white;
                shapeInfo.from = tabColor2 == null ? defaultBg : tabColor2;
                Color color = shapeInfo.to = tabColor2 == null ? defaultBg : tabColor2;
            }
        }
        if (!this.isHideTabs()) {
            if (bgPreFill != null) {
                g2d.setColor(bgPreFill);
                g2d.fill(shapeInfo.fillPath.getShape());
            }
            Line2D.Float gradientLine = shapeInfo.fillPath.transformLine(shapeInfo.fillPath.getX(), paintTopY, shapeInfo.fillPath.getX(), paintBottomY);
            g2d.setPaint(UIUtil.getGradientPaint((float)((float)gradientLine.getX1()), (float)((float)gradientLine.getY1()), (Color)shapeInfo.fillPath.transformY1(shapeInfo.from, shapeInfo.to), (float)((float)gradientLine.getX2()), (float)((float)gradientLine.getY2()), (Color)shapeInfo.fillPath.transformY1(shapeInfo.to, shapeInfo.from)));
            g2d.fill(shapeInfo.fillPath.getShape());
        }
        Color borderColor = (tabColor = this.getActiveTabColor(null)) == null ? UIUtil.getBoundsColor((boolean)paintFocused) : tabColor.darker();
        g2d.setColor(borderColor);
        if (!this.isHideTabs()) {
            g2d.draw(shapeInfo.path.getShape());
        }
        this.paintBorder(g2d, shapeInfo, borderColor);
    }

    protected Color getFocusedTopFillColor() {
        return UIUtil.getFocusedFillColor();
    }

    protected Color getFocusedBottomFillColor() {
        return UIUtil.getFocusedFillColor();
    }

    protected ShapeInfo computeSelectedLabelShape() {
        boolean isDraggedNow;
        ShapeInfo shape = new ShapeInfo();
        shape.path = this.getEffectiveLayout().createShapeTransform(this.getSize());
        shape.insets = shape.path.transformInsets(this.getLayoutInsets());
        shape.labelPath = shape.path.createTransform(this.getSelectedLabel().getBounds());
        shape.labelBottomY = shape.labelPath.getMaxY() + shape.labelPath.deltaY(1);
        shape.labelTopY = shape.labelPath.getY();
        shape.labelLeftX = shape.labelPath.getX();
        shape.labelRightX = shape.labelPath.getX() + shape.labelPath.deltaX(shape.labelPath.getWidth());
        Insets border = this.myBorder.getEffectiveBorder();
        TabInfo selected = this.getSelectedInfo();
        boolean first = this.myLastLayoutPass.getPreviousFor(selected) == null;
        boolean last = this.myLastLayoutPass.getNextFor(selected) == null;
        boolean leftEdge = !this.isSingleRow() && first && border.left == 0;
        boolean rightEdge = !this.isSingleRow() && last && Boolean.TRUE.equals(this.myInfo2Label.get(selected).getClientProperty(STRETCHED_BY_WIDTH)) && border.right == 0;
        boolean bl = isDraggedNow = selected != null && this.myDragHelper != null && selected.equals(this.myDragHelper.getDragSource());
        if (leftEdge && !isDraggedNow) {
            shape.path.moveTo(shape.insets.left, shape.labelTopY + shape.labelPath.deltaY(JBTabsImpl.getEdgeArcSize()));
            shape.path.quadTo(shape.labelLeftX, shape.labelTopY, shape.labelLeftX + shape.labelPath.deltaX(JBTabsImpl.getEdgeArcSize()), shape.labelTopY);
            shape.path.lineTo(shape.labelRightX - shape.labelPath.deltaX(JBTabsImpl.getArcSize()), shape.labelTopY);
        } else {
            shape.path.moveTo(shape.insets.left, shape.labelBottomY);
            shape.path.lineTo(shape.labelLeftX, shape.labelBottomY);
            shape.path.lineTo(shape.labelLeftX, shape.labelTopY + shape.labelPath.deltaY(JBTabsImpl.getArcSize()));
            shape.path.quadTo(shape.labelLeftX, shape.labelTopY, shape.labelLeftX + shape.labelPath.deltaX(JBTabsImpl.getArcSize()), shape.labelTopY);
        }
        int lastX = shape.path.getWidth() - shape.path.deltaX(shape.insets.right + 1);
        if (this.isStealthModeEffective()) {
            shape.path.lineTo(lastX - shape.path.deltaX(JBTabsImpl.getArcSize()), shape.labelTopY);
            shape.path.quadTo(lastX, shape.labelTopY, lastX, shape.labelTopY + shape.path.deltaY(JBTabsImpl.getArcSize()));
            shape.path.lineTo(lastX, shape.labelBottomY);
        } else {
            if (rightEdge) {
                shape.path.lineTo(shape.labelRightX + 1 - shape.path.deltaX(JBTabsImpl.getArcSize()), shape.labelTopY);
                shape.path.quadTo(shape.labelRightX + 1, shape.labelTopY, shape.labelRightX + 1, shape.labelTopY + shape.path.deltaY(JBTabsImpl.getArcSize()));
            } else {
                shape.path.lineTo(shape.labelRightX - shape.path.deltaX(JBTabsImpl.getArcSize()), shape.labelTopY);
                shape.path.quadTo(shape.labelRightX, shape.labelTopY, shape.labelRightX, shape.labelTopY + shape.path.deltaY(JBTabsImpl.getArcSize()));
            }
            if (this.myLastLayoutPass.hasCurveSpaceFor(selected)) {
                shape.path.lineTo(shape.labelRightX, shape.labelBottomY - shape.path.deltaY(JBTabsImpl.getArcSize()));
                shape.path.quadTo(shape.labelRightX, shape.labelBottomY, shape.labelRightX + shape.path.deltaX(JBTabsImpl.getArcSize()), shape.labelBottomY);
            } else if (rightEdge) {
                shape.path.lineTo(shape.labelRightX + 1, shape.labelBottomY);
            } else {
                shape.path.lineTo(shape.labelRightX, shape.labelBottomY);
            }
        }
        if (!rightEdge) {
            shape.path.lineTo(lastX, shape.labelBottomY);
        }
        if (this.isStealthModeEffective()) {
            shape.path.closePath();
        }
        shape.fillPath = shape.path.copy();
        if (!this.isHideTabs()) {
            shape.fillPath.lineTo(lastX, shape.labelBottomY + shape.fillPath.deltaY(1));
            shape.fillPath.lineTo(shape.labelLeftX, shape.labelBottomY + shape.fillPath.deltaY(1));
            shape.fillPath.closePath();
        }
        return shape;
    }

    protected TabLabel getSelectedLabel() {
        return this.myInfo2Label.get(this.getSelectedInfo());
    }

    protected void paintFirstGhost(Graphics2D g2d) {
        boolean isLeftFromSelection;
        ShapeTransform path = this.getEffectiveLayout().createShapeTransform(this.mySingleRowLayout.myLastSingRowLayout.firstGhost);
        int topX = path.getX() + path.deltaX(JBTabsImpl.getCurveArc());
        int topY = path.getY() + path.deltaY(JBTabsImpl.getSelectionTabVShift());
        int bottomX = path.getMaxX() + path.deltaX(1);
        int bottomY = path.getMaxY() + path.deltaY(1);
        path.moveTo(topX, topY);
        boolean bl = isLeftFromSelection = this.mySingleRowLayout.myLastSingRowLayout.toLayout.indexOf(this.getSelectedInfo()) == 0;
        if (isLeftFromSelection) {
            path.lineTo(bottomX, topY);
        } else {
            path.lineTo(bottomX - JBTabsImpl.getArcSize(), topY);
            path.quadTo(bottomX, topY, bottomX, topY + path.deltaY(JBTabsImpl.getArcSize()));
        }
        path.lineTo(bottomX, bottomY);
        path.lineTo(topX, bottomY);
        path.quadTo(topX - path.deltaX(JBTabsImpl.getCurveArc() * 2 - 1), bottomY - path.deltaY(Math.abs(bottomY - topY) / 4), topX, bottomY - path.deltaY(Math.abs(bottomY - topY) / 2));
        path.quadTo(topX + path.deltaX(JBTabsImpl.getCurveArc() - 1), topY + path.deltaY(Math.abs(bottomY - topY) / 4), topX, topY);
        path.closePath();
        g2d.setColor(this.getBackground());
        g2d.fill(path.getShape());
        g2d.setColor(JBTabsImpl.getBoundsColor());
        g2d.draw(path.getShape());
        g2d.setColor(JBTabsImpl.getTopBlockColor());
        g2d.drawLine(topX + path.deltaX(1), topY + path.deltaY(1), bottomX - path.deltaX(JBTabsImpl.getArcSize()), topY + path.deltaY(1));
        g2d.setColor(JBTabsImpl.getRightBlockColor());
        g2d.drawLine(bottomX - path.deltaX(1), topY + path.deltaY(JBTabsImpl.getArcSize()), bottomX - path.deltaX(1), bottomY - path.deltaY(1));
    }

    protected void paintLastGhost(Graphics2D g2d) {
        ShapeTransform path = this.getEffectiveLayout().createShapeTransform(this.mySingleRowLayout.myLastSingRowLayout.lastGhost);
        int topX = path.getX() - path.deltaX(JBTabsImpl.getArcSize());
        int topY = path.getY() + path.deltaY(JBTabsImpl.getSelectionTabVShift());
        int bottomX = path.getMaxX() - path.deltaX(JBTabsImpl.getCurveArc());
        int bottomY = path.getMaxY() + path.deltaY(1);
        path.moveTo(topX, topY);
        path.lineTo(bottomX, topY);
        path.quadTo(bottomX - JBTabsImpl.getCurveArc(), topY + (bottomY - topY) / 4, bottomX, topY + (bottomY - topY) / 2);
        path.quadTo(bottomX + JBTabsImpl.getCurveArc(), bottomY - (bottomY - topY) / 4, bottomX, bottomY);
        path.lineTo(topX, bottomY);
        path.closePath();
        g2d.setColor(this.getBackground());
        g2d.fill(path.getShape());
        g2d.setColor(JBTabsImpl.getBoundsColor());
        g2d.draw(path.getShape());
        g2d.setColor(JBTabsImpl.getTopBlockColor());
        g2d.drawLine(topX, topY + path.deltaY(1), bottomX - path.deltaX(JBTabsImpl.getCurveArc()), topY + path.deltaY(1));
    }

    private static int getCurveArc() {
        return 2;
    }

    private static Color getBoundsColor() {
        return new JBColor(Color.gray, Gray._0.withAlpha(80));
    }

    private static Color getRightBlockColor() {
        return new JBColor(Color.lightGray, Gray._0.withAlpha(0));
    }

    private static Color getTopBlockColor() {
        return new JBColor(Color.white, Gray._0.withAlpha(0));
    }

    private void paintNonSelectedTabs(Graphics2D g2d, boolean leftGhostExists, boolean rightGhostExists) {
        TabInfo selected = this.getSelectedInfo();
        if (this.myLastPaintedSelection == null || !this.myLastPaintedSelection.equals(selected)) {
            List<TabInfo> tabs = this.getTabs();
            for (TabInfo each : tabs) {
                this.myInfo2Label.get(each).setInactiveStateImage(null);
            }
        }
        for (int eachRow = 0; eachRow < this.myLastLayoutPass.getRowCount(); ++eachRow) {
            for (int eachColumn = this.myLastLayoutPass.getColumnCount(eachRow) - 1; eachColumn >= 0; --eachColumn) {
                TabInfo each;
                each = this.myLastLayoutPass.getTabAt(eachRow, eachColumn);
                if (this.getSelectedInfo() == each) continue;
                this.paintNonSelected(g2d, each, leftGhostExists, rightGhostExists, eachRow, eachColumn);
            }
        }
        this.myLastPaintedSelection = selected;
    }

    private void paintNonSelected(Graphics2D g2d, TabInfo each, boolean leftGhostExists, boolean rightGhostExists, int row, int column) {
        if (this.myDropInfo == each) {
            return;
        }
        TabLabel label = this.myInfo2Label.get(each);
        if (label.getBounds().width == 0) {
            return;
        }
        int imageInsets = JBTabsImpl.getArcSize() + 1;
        Rectangle bounds = label.getBounds();
        int x = bounds.x - imageInsets;
        int y = bounds.y;
        int width = bounds.width + imageInsets * 2 + 1;
        int height = bounds.height + JBTabsImpl.getArcSize() + 1;
        if (this.isToBufferPainting()) {
            BufferedImage img = label.getInactiveStateImage(bounds);
            if (img == null) {
                img = UIUtil.createImage((int)width, (int)height, (int)2);
                Graphics2D imgG2d = img.createGraphics();
                imgG2d.addRenderingHints(g2d.getRenderingHints());
                this.doPaintInactive(imgG2d, leftGhostExists, label, new Rectangle(imageInsets, 0, label.getWidth(), label.getHeight()), rightGhostExists, row, column);
                imgG2d.dispose();
            }
            g2d.drawImage(img, x, y, width, height, null);
            label.setInactiveStateImage(img);
        } else {
            this.doPaintInactive(g2d, leftGhostExists, label, label.getBounds(), rightGhostExists, row, column);
            label.setInactiveStateImage(null);
        }
    }

    private boolean isToBufferPainting() {
        return Registry.is((String)"ide.tabbedPane.bufferedPaint") && this.myUseBufferedPaint;
    }

    protected List<TabInfo> getVisibleInfos() {
        if (!this.isAlphabeticalMode()) {
            return this.myVisibleInfos;
        }
        ArrayList<TabInfo> sortedCopy = new ArrayList<TabInfo>(this.myVisibleInfos);
        Collections.sort(sortedCopy, ABC_COMPARATOR);
        return sortedCopy;
    }

    protected LayoutPassInfo getLastLayoutPass() {
        return this.myLastLayoutPass;
    }

    @Override
    public Color getBackground() {
        return UIUtil.isUnderNimbusLookAndFeel() ? UIUtil.getPanelBackground() : UIUtil.getBgFillColor((Component)this.getParent());
    }

    protected void doPaintInactive(Graphics2D g2d, boolean leftGhostExists, TabLabel label, Rectangle effectiveBounds, boolean rightGhostExists, int row, int column) {
        TablePassInfo info;
        boolean lastShowing;
        boolean firstShowing;
        int tabIndex = this.myVisibleInfos.indexOf(label.getInfo());
        int arc = JBTabsImpl.getArcSize();
        Color topBlockColor = JBTabsImpl.getTopBlockColor();
        Color rightBlockColor = JBTabsImpl.getRightBlockColor();
        Color boundsColor = JBTabsImpl.getBoundsColor();
        Color backgroundColor = this.getBackground();
        Color tabColor = label.getInfo().getTabColor();
        if (tabColor != null) {
            backgroundColor = tabColor;
            boundsColor = tabColor.darker();
            topBlockColor = tabColor.brighter().brighter();
            rightBlockColor = tabColor;
        }
        TabInfo selected = this.getSelectedInfo();
        int selectionTabVShift = JBTabsImpl.getSelectionTabVShift();
        TabInfo prev = this.myLastLayoutPass.getPreviousFor(this.myVisibleInfos.get(tabIndex));
        TabInfo next = this.myLastLayoutPass.getNextFor(this.myVisibleInfos.get(tabIndex));
        boolean bl = firstShowing = prev == null;
        if (!firstShowing && !leftGhostExists) {
            firstShowing = this.myInfo2Label.get((Object)prev).getBounds().width == 0;
        }
        boolean bl2 = lastShowing = next == null;
        if (!lastShowing) {
            lastShowing = this.myInfo2Label.get((Object)next).getBounds().width == 0;
        }
        boolean leftFromSelection = selected != null && tabIndex == this.myVisibleInfos.indexOf(selected) - 1;
        ShapeTransform shape = this.getEffectiveLayout().createShapeTransform(effectiveBounds);
        int leftX = firstShowing ? shape.getX() : shape.getX() - shape.deltaX(arc + 1);
        int topY = shape.getY() + shape.deltaY(selectionTabVShift);
        int rightX = !lastShowing && leftFromSelection ? shape.getMaxX() + shape.deltaX(arc + 1) : shape.getMaxX();
        int bottomY = shape.getMaxY() + shape.deltaY(1);
        Insets border = this.myBorder.getEffectiveBorder();
        if (border.left > 0 || leftGhostExists || !firstShowing) {
            shape.moveTo(leftX, bottomY);
            shape.lineTo(leftX, topY + shape.deltaY(arc));
            shape.quadTo(leftX, topY, leftX + shape.deltaX(arc), topY);
        } else if (firstShowing) {
            shape.moveTo(leftX, topY + shape.deltaY(JBTabsImpl.getEdgeArcSize()));
            shape.quadTo(leftX, topY, leftX + shape.deltaX(JBTabsImpl.getEdgeArcSize()), topY);
        }
        boolean rightEdge = false;
        if (border.right > 0 || rightGhostExists || !lastShowing || !Boolean.TRUE.equals(label.getClientProperty(STRETCHED_BY_WIDTH))) {
            shape.lineTo(rightX - shape.deltaX(arc), topY);
            shape.quadTo(rightX, topY, rightX, topY + shape.deltaY(arc));
            shape.lineTo(rightX, bottomY);
        } else if (lastShowing) {
            shape.lineTo(rightX - shape.deltaX(arc), topY);
            shape.quadTo(rightX + 1, topY, rightX + 1, topY + shape.deltaY(arc));
            shape.lineTo(rightX + 1, bottomY);
            rightEdge = true;
        }
        if (!this.isSingleRow() && !(info = this.myTableLayout.myLastTableLayout).isInSelectionRow(label.getInfo())) {
            shape.lineTo(rightX, bottomY + shape.deltaY(JBTabsImpl.getArcSize()));
            shape.lineTo(leftX, bottomY + shape.deltaY(JBTabsImpl.getArcSize()));
            shape.lineTo(leftX, bottomY);
        }
        if (!rightEdge) {
            shape.lineTo(leftX, bottomY);
        }
        g2d.setColor(backgroundColor);
        g2d.fill(shape.getShape());
        Line2D.Float gradientLine = shape.transformLine(0, topY, 0, topY + shape.deltaY((int)((double)shape.getHeight() / 1.5)));
        Paint gp = UIUtil.isUnderDarcula() ? UIUtil.getGradientPaint((float)gradientLine.x1, (float)gradientLine.y1, (Color)shape.transformY1(backgroundColor, backgroundColor), (float)gradientLine.x2, (float)gradientLine.y2, (Color)shape.transformY1(backgroundColor, backgroundColor)) : UIUtil.getGradientPaint((float)gradientLine.x1, (float)gradientLine.y1, (Color)shape.transformY1(backgroundColor.brighter().brighter(), backgroundColor), (float)gradientLine.x2, (float)gradientLine.y2, (Color)shape.transformY1(backgroundColor, backgroundColor.brighter().brighter()));
        Paint old = g2d.getPaint();
        g2d.setPaint(gp);
        g2d.fill(shape.getShape());
        g2d.setPaint(old);
        g2d.setColor(topBlockColor);
        g2d.draw(shape.transformLine(leftX + shape.deltaX(arc + 1), topY + shape.deltaY(1), rightX - shape.deltaX(arc - 1), topY + shape.deltaY(1)));
        if (!rightEdge) {
            g2d.setColor(rightBlockColor);
            g2d.draw(shape.transformLine(rightX - shape.deltaX(1), topY + shape.deltaY(arc - 1), rightX - shape.deltaX(1), bottomY));
        }
        g2d.setColor(boundsColor);
        g2d.draw(shape.getShape());
    }

    public static int getSelectionTabVShift() {
        return 2;
    }

    protected void paintBorder(Graphics2D g2d, ShapeInfo shape, Color borderColor) {
        ShapeTransform shaper = shape.path.copy().reset();
        Insets paintBorder = shape.path.transformInsets(this.myBorder.getEffectiveBorder());
        int topY = shape.labelPath.getMaxY() + shape.labelPath.deltaY(1);
        int bottomY = topY + paintBorder.top - 2;
        int middleY = topY + (bottomY - topY) / 2;
        int boundsX = shape.path.getX() + shape.path.deltaX(shape.insets.left);
        int boundsY = this.isHideTabs() ? shape.path.getY() + shape.path.deltaY(shape.insets.top) : shape.labelPath.getMaxY() + shape.path.deltaY(1);
        int boundsHeight = Math.abs(shape.path.getMaxY() - boundsY) - shape.insets.bottom - paintBorder.bottom;
        int boundsWidth = Math.abs(shape.path.getMaxX() - (shape.insets.left + shape.insets.right));
        if (paintBorder.top > 0) {
            if (this.isHideTabs()) {
                if (this.isToDrawBorderIfTabsHidden()) {
                    g2d.setColor(borderColor);
                    g2d.fill(shaper.reset().doRect(boundsX, boundsY, boundsWidth, 1).getShape());
                }
            } else {
                Color tabFillColor = this.getActiveTabColor(null);
                if (tabFillColor == null) {
                    tabFillColor = shape.path.transformY1(shape.to, shape.from);
                }
                g2d.setColor(tabFillColor);
                g2d.fill(shaper.reset().doRect(boundsX, topY + shape.path.deltaY(1), boundsWidth, paintBorder.top - 1).getShape());
                g2d.setColor(borderColor);
                if (paintBorder.top == 2) {
                    Line2D.Float line = shape.path.transformLine(boundsX, topY, boundsX + shape.path.deltaX(boundsWidth - 1), topY);
                    g2d.drawLine((int)line.x1, (int)line.y1, (int)line.x2, (int)line.y2);
                } else if (paintBorder.top > 2) {
                    int deltaY = 0;
                    if (this.myPosition == JBTabsPosition.bottom || this.myPosition == JBTabsPosition.right) {
                        deltaY = 1;
                    }
                    int topLine = topY + shape.path.deltaY(paintBorder.top - 1);
                    g2d.fill(shaper.reset().doRect(boundsX, topLine + deltaY, boundsWidth - 1, 1).getShape());
                }
            }
        }
        g2d.setColor(borderColor);
        g2d.fill(shaper.reset().doRect(boundsX, Math.abs(shape.path.getMaxY() - shape.insets.bottom - paintBorder.bottom), boundsWidth, paintBorder.bottom).getShape());
        g2d.fill(shaper.reset().doRect(boundsX, boundsY, paintBorder.left, boundsHeight).getShape());
        g2d.fill(shaper.reset().doRect(shape.path.getMaxX() - shape.insets.right - paintBorder.right, boundsY, paintBorder.right, boundsHeight).getShape());
    }

    protected boolean isStealthModeEffective() {
        return this.myStealthTabMode && this.getTabCount() == 1 && (this.isSideComponentVertical() || !this.isSideComponentOnTabs()) && this.getTabsPosition() == JBTabsPosition.top;
    }

    private boolean isNavigationVisible() {
        if (this.myStealthTabMode && this.getTabCount() == 1) {
            return false;
        }
        return !this.myVisibleInfos.isEmpty();
    }

    @Override
    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            return;
        }
        if (this.myPaintBlocked) {
            if (this.myImage != null) {
                g.drawImage(this.myImage, 0, 0, this.getWidth(), this.getHeight(), null);
            }
            return;
        }
        super.paint(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.paintSelectionAndBorder((Graphics2D)g);
        TabLabel selected = this.getSelectedLabel();
        if (selected != null) {
            selected.paintImage(g);
        }
        this.mySingleRowLayout.myMoreIcon.paintIcon(this, g);
    }

    private Max computeMaxSize() {
        Max max = new Max();
        for (TabInfo eachInfo : this.myVisibleInfos) {
            TabLabel label = this.myInfo2Label.get(eachInfo);
            max.myLabel.height = Math.max(max.myLabel.height, label.getPreferredSize().height);
            max.myLabel.width = Math.max(max.myLabel.width, label.getPreferredSize().width);
            Toolbar toolbar = this.myInfo2Toolbar.get(eachInfo);
            if (!this.myLayout.isSideComponentOnTabs() || toolbar == null || toolbar.isEmpty()) continue;
            max.myToolbar.height = Math.max(max.myToolbar.height, toolbar.getPreferredSize().height);
            max.myToolbar.width = Math.max(max.myToolbar.width, toolbar.getPreferredSize().width);
        }
        ++max.myToolbar.height;
        return max;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.mySizeBySelected) {
            return this.computeSizeBySelected(true);
        }
        return this.computeSize(new Function<JComponent, Dimension>(){

            public Dimension fun(JComponent component) {
                return component.getMinimumSize();
            }
        }, 1);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mySizeBySelected) {
            return this.computeSizeBySelected(false);
        }
        return this.computeSize(new Function<JComponent, Dimension>(){

            public Dimension fun(JComponent component) {
                return component.getPreferredSize();
            }
        }, 3);
    }

    private Dimension computeSizeBySelected(boolean minimum) {
        JComponent component;
        Dimension size = new Dimension();
        TabInfo tabInfo = this.getSelectedInfo();
        if (tabInfo == null && this.myVisibleInfos.size() > 0) {
            tabInfo = this.myVisibleInfos.get(0);
        }
        JComponent jComponent = component = tabInfo == null ? null : tabInfo.getComponent();
        if (component != null) {
            Dimension tabSize = minimum ? component.getMinimumSize() : component.getPreferredSize();
            size.width = tabSize.width;
            size.height = tabSize.height;
        }
        this.addHeaderSize(size, 3);
        return size;
    }

    private Dimension computeSize(Function<JComponent, Dimension> transform, int tabCount) {
        Dimension size = new Dimension();
        for (TabInfo each : this.myVisibleInfos) {
            JComponent c = each.getComponent();
            if (c == null) continue;
            Dimension eachSize = (Dimension)transform.fun((Object)c);
            size.width = Math.max(eachSize.width, size.width);
            size.height = Math.max(eachSize.height, size.height);
        }
        this.addHeaderSize(size, tabCount);
        return size;
    }

    private void addHeaderSize(Dimension size, int tabsCount) {
        boolean horizontal;
        Dimension header = this.computeHeaderPreferredSize(tabsCount);
        boolean bl = horizontal = this.getTabsPosition() == JBTabsPosition.top || this.getTabsPosition() == JBTabsPosition.bottom;
        if (horizontal) {
            size.height += header.height;
            size.width = Math.max(size.width, header.width);
        } else {
            size.height += Math.max(size.height, header.height);
            size.width += header.width;
        }
        Insets insets = this.getLayoutInsets();
        size.width += insets.left + insets.right + 1;
        size.height += insets.top + insets.bottom + 1;
    }

    private Dimension computeHeaderPreferredSize(int tabsCount) {
        boolean horizontal;
        Iterator<TabInfo> infos = this.myInfo2Label.keySet().iterator();
        Dimension size = new Dimension();
        int currentTab = 0;
        boolean bl = horizontal = this.getTabsPosition() == JBTabsPosition.top || this.getTabsPosition() == JBTabsPosition.bottom;
        while (infos.hasNext()) {
            boolean canGrow = currentTab < tabsCount;
            TabInfo eachInfo = infos.next();
            TabLabel eachLabel = this.myInfo2Label.get(eachInfo);
            Dimension eachPrefSize = eachLabel.getPreferredSize();
            if (horizontal) {
                if (canGrow) {
                    size.width += eachPrefSize.width;
                }
                size.height = Math.max(size.height, eachPrefSize.height);
            } else {
                size.width = Math.max(size.width, eachPrefSize.width);
                if (canGrow) {
                    size.height += eachPrefSize.height;
                }
            }
            ++currentTab;
        }
        if (this.isSingleRow() && this.isGhostsAlwaysVisible()) {
            if (horizontal) {
                size.width += this.getGhostTabLength() * 2;
            } else {
                size.height += this.getGhostTabLength() * 2;
            }
        }
        if (horizontal) {
            size.height += this.myBorder.getTabBorderSize();
        } else {
            size.width += this.myBorder.getTabBorderSize();
        }
        return size;
    }

    @Override
    public int getTabCount() {
        return this.getTabs().size();
    }

    @Override
    public JBTabsPresentation getPresentation() {
        return this;
    }

    @Override
    public ActionCallback removeTab(TabInfo info) {
        return this.removeTab(info, null, true);
    }

    public ActionCallback removeTab(TabInfo info, TabInfo forcedSelectionTransfer, boolean transferFocus) {
        return this.removeTab(info, forcedSelectionTransfer, transferFocus, false);
    }

    private ActionCallback removeTab(TabInfo info, TabInfo forcedSelectionTransfer, boolean transferFocus, boolean isDropTarget) {
        TabInfo toSelect;
        if (!(isDropTarget || info != null && this.getTabs().contains(info))) {
            return new ActionCallback.Done();
        }
        if (isDropTarget && this.myLastLayoutPass != null) {
            this.myLastLayoutPass.myVisibleInfos.remove(info);
        }
        final ActionCallback result = new ActionCallback();
        if (forcedSelectionTransfer == null) {
            toSelect = this.getToSelectOnRemoveOf(info);
        } else {
            assert (this.myVisibleInfos.contains(forcedSelectionTransfer)) : "Cannot find tab for selection transfer, tab=" + forcedSelectionTransfer;
            toSelect = forcedSelectionTransfer;
        }
        if (toSelect != null) {
            boolean clearSelection = info.equals(this.mySelectedInfo);
            this.processRemove(info, false);
            if (clearSelection) {
                this.mySelectedInfo = info;
            }
            this._setSelected(toSelect, transferFocus).doWhenProcessed(new Runnable(){

                @Override
                public void run() {
                    JBTabsImpl.this.removeDeferred().notifyWhenDone(result);
                }
            });
        } else {
            this.processRemove(info, true);
            this.removeDeferred().notifyWhenDone(result);
        }
        if (this.myVisibleInfos.isEmpty()) {
            this.removeDeferredNow();
        }
        this.revalidateAndRepaint(true);
        this.fireTabRemoved(info);
        return result;
    }

    private void processRemove(TabInfo info, boolean forcedNow) {
        this.remove(this.myInfo2Label.get(info));
        this.remove(this.myInfo2Toolbar.get(info));
        JComponent tabComponent = info.getComponent();
        if (!JBTabsImpl.isToDeferRemoveForLater(tabComponent) || forcedNow) {
            this.remove(tabComponent);
        } else {
            this.queueForRemove(tabComponent);
        }
        this.myVisibleInfos.remove(info);
        this.myHiddenInfos.remove(info);
        this.myInfo2Label.remove(info);
        this.myInfo2Toolbar.remove(info);
        this.resetTabsCache();
        this.updateAll(false, false);
        this.myLastPaintedSelection = null;
    }

    public TabInfo findInfo(Component component) {
        for (TabInfo each : this.getTabs()) {
            if (each.getComponent() != component) continue;
            return each;
        }
        return null;
    }

    @Override
    public TabInfo findInfo(MouseEvent event) {
        return this.findInfo(event, false);
    }

    private TabInfo findInfo(MouseEvent event, boolean labelsOnly) {
        Point point = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), this);
        return this._findInfo(point, labelsOnly);
    }

    @Override
    public TabInfo findInfo(Object object) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            TabInfo each = this.getTabAt(i);
            Object eachObject = each.getObject();
            if (eachObject == null || !eachObject.equals(object)) continue;
            return each;
        }
        return null;
    }

    private TabInfo _findInfo(Point point, boolean labelsOnly) {
        Component component = this.findComponentAt(point);
        if (component == null) {
            return null;
        }
        while (component != this || component != null) {
            TabInfo info;
            if (component instanceof TabLabel) {
                return ((TabLabel)component).getInfo();
            }
            if (!labelsOnly && (info = this.findInfo(component)) != null) {
                return info;
            }
            if (component == null) break;
            component = component.getParent();
        }
        return null;
    }

    @Override
    public void removeAllTabs() {
        for (TabInfo each : this.getTabs()) {
            this.removeTab(each);
        }
    }

    private void updateContainer(boolean forced, boolean layoutNow) {
        if (this.myProject != null && !this.myProject.isOpen()) {
            return;
        }
        for (TabInfo each : new ArrayList<TabInfo>(this.myVisibleInfos)) {
            JComponent eachComponent = each.getComponent();
            if (this.getSelectedInfo() == each && this.getSelectedInfo() != null) {
                this.unqueueFromRemove(eachComponent);
                Container parent = eachComponent.getParent();
                if (parent != null && parent != this) {
                    parent.remove(eachComponent);
                }
                if (eachComponent.getParent() != null) continue;
                this.add(eachComponent);
                continue;
            }
            if (eachComponent.getParent() == null) continue;
            if (JBTabsImpl.isToDeferRemoveForLater(eachComponent)) {
                this.queueForRemove(eachComponent);
                continue;
            }
            this.remove(eachComponent);
        }
        this.mySingleRowLayout.scrollSelectionInView();
        this.relayout(forced, layoutNow);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.unqueueFromRemove(comp);
        if (comp instanceof TabLabel) {
            ((TabLabel)comp).apply(this.myUiDecorator.getDecoration());
        }
        super.addImpl(comp, constraints, index);
    }

    private static boolean isToDeferRemoveForLater(JComponent c) {
        return c.getRootPane() != null;
    }

    void relayout(boolean forced, boolean layoutNow) {
        if (!this.myForcedRelayout) {
            this.myForcedRelayout = forced;
        }
        this.revalidateAndRepaint(layoutNow);
    }

    public TabsBorder getTabsBorder() {
        return this.myBorder;
    }

    @Override
    public JBTabs addTabMouseListener(MouseListener listener) {
        this.removeListeners();
        this.myTabMouseListeners.add(listener);
        this.addListeners();
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean isCycleRoot() {
        return false;
    }

    private void addListeners() {
        for (TabInfo eachInfo : this.myVisibleInfos) {
            TabLabel label = this.myInfo2Label.get(eachInfo);
            for (EventListener eachListener : this.myTabMouseListeners) {
                if (eachListener instanceof MouseListener) {
                    label.addMouseListener((MouseListener)eachListener);
                    continue;
                }
                if (eachListener instanceof MouseMotionListener) {
                    label.addMouseMotionListener((MouseMotionListener)eachListener);
                    continue;
                }
                assert (false);
            }
        }
    }

    private void removeListeners() {
        for (TabInfo eachInfo : this.myVisibleInfos) {
            TabLabel label = this.myInfo2Label.get(eachInfo);
            for (EventListener eachListener : this.myTabMouseListeners) {
                if (eachListener instanceof MouseListener) {
                    label.removeMouseListener((MouseListener)eachListener);
                    continue;
                }
                if (eachListener instanceof MouseMotionListener) {
                    label.removeMouseMotionListener((MouseMotionListener)eachListener);
                    continue;
                }
                assert (false);
            }
        }
    }

    private void updateListeners() {
        this.removeListeners();
        this.addListeners();
    }

    @Override
    public JBTabs addListener(TabsListener listener) {
        this.myTabListeners.add(listener);
        return this;
    }

    @Override
    public JBTabs setSelectionChangeHandler(JBTabs.SelectionChangeHandler handler) {
        this.mySelectionChangeHandler = handler;
        return this;
    }

    public void setFocused(boolean focused) {
        if (this.myFocused == focused) {
            return;
        }
        this.myFocused = focused;
        if (this.myPaintFocus) {
            this.repaint();
        }
    }

    @Override
    public int getIndexOf(TabInfo tabInfo) {
        return this.getVisibleInfos().indexOf(tabInfo);
    }

    @Override
    public boolean isHideTabs() {
        return this.myHideTabs;
    }

    @Override
    public void setHideTabs(boolean hideTabs) {
        if (this.isHideTabs() == hideTabs) {
            return;
        }
        this.myHideTabs = hideTabs;
        this.relayout(true, false);
    }

    @Override
    public JBTabsPresentation setPaintBorder(int top, int left, int right, int bottom) {
        return this.myBorder.setPaintBorder(top, left, right, bottom);
    }

    @Override
    public JBTabsPresentation setTabSidePaintBorder(int size) {
        return this.myBorder.setTabSidePaintBorder(size);
    }

    static int getBorder(int size) {
        return size == -1 ? 1 : size;
    }

    private boolean isPaintFocus() {
        return this.myPaintFocus;
    }

    @Override
    public JBTabsPresentation setActiveTabFillIn(Color color) {
        if (!JBTabsImpl.isChanged(this.myActiveTabFillIn, color)) {
            return this;
        }
        this.myActiveTabFillIn = color;
        this.revalidateAndRepaint(false);
        return this;
    }

    private static boolean isChanged(Object oldObject, Object newObject) {
        return !Comparing.equal((Object)oldObject, (Object)newObject);
    }

    @Override
    public JBTabsPresentation setTabLabelActionsAutoHide(boolean autoHide) {
        if (this.myTabLabelActionsAutoHide != autoHide) {
            this.myTabLabelActionsAutoHide = autoHide;
            this.revalidateAndRepaint(false);
        }
        return this;
    }

    protected Color getActiveTabFillIn() {
        return this.myActiveTabFillIn;
    }

    @Override
    public JBTabsPresentation setFocusCycle(boolean root) {
        this.setFocusCycleRoot(root);
        return this;
    }

    @Override
    public JBTabsPresentation setPaintFocus(boolean paintFocus) {
        this.myPaintFocus = paintFocus;
        return this;
    }

    @Override
    public JBTabsPresentation setAlwaysPaintSelectedTab(boolean paintSelected) {
        this.myAlwaysPaintSelectedTab = paintSelected;
        return this;
    }

    private void disposePopupListener() {
        if (this.myActivePopup != null) {
            this.myActivePopup.removePopupMenuListener(this.myPopupListener);
            this.myActivePopup = null;
        }
    }

    @Override
    public JBTabsPresentation setStealthTabMode(boolean stealthTabMode) {
        this.myStealthTabMode = stealthTabMode;
        this.relayout(true, false);
        return this;
    }

    public boolean isStealthTabMode() {
        return this.myStealthTabMode;
    }

    @Override
    public JBTabsPresentation setSideComponentVertical(boolean vertical) {
        this.myHorizontalSide = !vertical;
        for (TabInfo each : this.myVisibleInfos) {
            each.getChangeSupport().firePropertyChange("actionGroup", "new1", "new2");
        }
        this.relayout(true, false);
        return this;
    }

    @Override
    public JBTabsPresentation setSideComponentOnTabs(boolean onTabs) {
        this.mySideComponentOnTabs = onTabs;
        this.relayout(true, false);
        return this;
    }

    @Override
    public JBTabsPresentation setSingleRow(boolean singleRow) {
        this.myLayout = singleRow ? this.mySingleRowLayout : this.myTableLayout;
        this.relayout(true, false);
        return this;
    }

    @Override
    public JBTabsPresentation setGhostsAlwaysVisible(boolean visible) {
        this.myGhostsAlwaysVisible = visible;
        this.relayout(true, false);
        return this;
    }

    public boolean isSizeBySelected() {
        return this.mySizeBySelected;
    }

    public void setSizeBySelected(boolean value) {
        this.mySizeBySelected = value;
    }

    public boolean useSmallLabels() {
        return false;
    }

    public boolean useBoldLabels() {
        return false;
    }

    public boolean hasUnderline() {
        return false;
    }

    public boolean isGhostsAlwaysVisible() {
        return this.myGhostsAlwaysVisible;
    }

    @Override
    public boolean isSingleRow() {
        return this.getEffectiveLayout() == this.mySingleRowLayout;
    }

    public boolean isSideComponentVertical() {
        return !this.myHorizontalSide;
    }

    public boolean isSideComponentOnTabs() {
        return this.mySideComponentOnTabs;
    }

    public TabLayout getEffectiveLayout() {
        if (this.myLayout == this.myTableLayout && this.getTabsPosition() == JBTabsPosition.top) {
            return this.myTableLayout;
        }
        return this.mySingleRowLayout;
    }

    @Override
    public JBTabsPresentation setUiDecorator(UiDecorator decorator) {
        this.myUiDecorator = decorator == null ? ourDefaultDecorator : decorator;
        this.applyDecoration();
        return this;
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.applyDecoration();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JBTabsImpl.this.applyDecoration();
                JBTabsImpl.this.revalidateAndRepaint(false);
            }
        });
    }

    private void applyDecoration() {
        if (this.myUiDecorator != null) {
            UiDecorator.UiDecoration uiDecoration = this.myUiDecorator.getDecoration();
            for (TabLabel each : this.myInfo2Label.values()) {
                each.apply(uiDecoration);
            }
        }
        for (TabInfo each : this.getTabs()) {
            this.adjust(each);
        }
        this.relayout(true, false);
    }

    private void adjust(TabInfo each) {
        UIUtil.removeScrollBorder((Component)each.getComponent());
    }

    public void sortTabs(Comparator<TabInfo> comparator) {
        Collections.sort(this.myVisibleInfos, comparator);
        this.relayout(true, false);
    }

    private boolean isRequestFocusOnLastFocusedComponent() {
        return this.myRequestFocusOnLastFocusedComponent;
    }

    @Override
    public JBTabsPresentation setRequestFocusOnLastFocusedComponent(boolean requestFocusOnLastFocusedComponent) {
        this.myRequestFocusOnLastFocusedComponent = requestFocusOnLastFocusedComponent;
        return this;
    }

    @Override
    public Object getData(String dataId) {
        Object value;
        if (this.myDataProvider != null && (value = this.myDataProvider.getData(dataId)) != null) {
            return value;
        }
        if (SwitchProvider.KEY.getName().equals(dataId) && this.myOwnSwitchProvider) {
            return this;
        }
        if (QuickActionProvider.KEY.getName().equals(dataId)) {
            return this;
        }
        return NAVIGATION_ACTIONS_KEY.is(dataId) ? this : null;
    }

    @Override
    public List<AnAction> getActions(boolean originalProvider) {
        ActionGroup group;
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        TabInfo selection = this.getSelectedInfo();
        if (selection != null && (group = selection.getGroup()) != null) {
            AnAction[] children = group.getChildren(null);
            Collections.addAll(result, children);
        }
        return result;
    }

    @Override
    public DataProvider getDataProvider() {
        return this.myDataProvider;
    }

    public JBTabsImpl setDataProvider(DataProvider dataProvider) {
        this.myDataProvider = dataProvider;
        return this;
    }

    public static boolean isSelectionClick(MouseEvent e, boolean canBeQuick) {
        if ((e.getClickCount() == 1 || canBeQuick) && !e.isPopupTrigger()) {
            return e.getButton() == 1 && !e.isControlDown() && !e.isAltDown() && !e.isMetaDown();
        }
        return false;
    }

    public Rectangle layout(JComponent c, Rectangle bounds) {
        Rectangle now = c.getBounds();
        if (!bounds.equals(now)) {
            c.setBounds(bounds);
        }
        c.putClientProperty(LAYOUT_DONE, Boolean.TRUE);
        return bounds;
    }

    public Rectangle layout(JComponent c, int x, int y, int width, int height) {
        return this.layout(c, new Rectangle(x, y, width, height));
    }

    public static void resetLayout(JComponent c) {
        if (c == null) {
            return;
        }
        c.putClientProperty(LAYOUT_DONE, null);
        c.putClientProperty(STRETCHED_BY_WIDTH, null);
    }

    private void applyResetComponents() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JComponent jc;
            Object done;
            Component each = this.getComponent(i);
            if (!(each instanceof JComponent) || Boolean.TRUE.equals(done = (jc = (JComponent)each).getClientProperty(LAYOUT_DONE))) continue;
            this.layout(jc, new Rectangle(0, 0, 0, 0));
        }
    }

    @Override
    public JBTabsPresentation setTabLabelActionsMouseDeadzone(TimedDeadzone.Length length) {
        this.myTabActionsMouseDeadzone = length;
        List<TabInfo> all = this.getTabs();
        for (TabInfo each : all) {
            TabLabel eachLabel = this.myInfo2Label.get(each);
            eachLabel.updateTabActions();
        }
        return this;
    }

    @Override
    public JBTabsPresentation setTabsPosition(JBTabsPosition position) {
        this.myPosition = position;
        this.relayout(true, false);
        return this;
    }

    @Override
    public JBTabsPosition getTabsPosition() {
        return this.myPosition;
    }

    public TimedDeadzone.Length getTabActionsMouseDeadzone() {
        return this.myTabActionsMouseDeadzone;
    }

    @Override
    public JBTabsPresentation setTabDraggingEnabled(boolean enabled) {
        this.myTabDraggingEnabled = enabled;
        return this;
    }

    public boolean isTabDraggingEnabled() {
        return this.myTabDraggingEnabled;
    }

    @Override
    public JBTabsPresentation setProvideSwitchTargets(boolean provide) {
        this.myOwnSwitchProvider = provide;
        return this;
    }

    void reallocate(TabInfo source, TabInfo target) {
        if (source == target || source == null || target == null) {
            return;
        }
        int targetIndex = this.myVisibleInfos.indexOf(target);
        this.myVisibleInfos.remove(source);
        this.myVisibleInfos.add(targetIndex, source);
        this.invalidate();
        this.relayout(true, true);
    }

    boolean isHorizontalTabs() {
        return this.getTabsPosition() == JBTabsPosition.top || this.getTabsPosition() == JBTabsPosition.bottom;
    }

    @Override
    public void putInfo(Map<String, String> info) {
        TabInfo selected = this.getSelectedInfo();
        if (selected != null) {
            selected.putInfo(info);
        }
    }

    public void setUseBufferedPaint(boolean useBufferedPaint) {
        this.myUseBufferedPaint = useBufferedPaint;
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<SwitchTarget> getTargets(boolean onlyVisible, boolean originalProvider) {
        List<SwitchTarget> additional;
        ArrayList<SwitchTarget> result = new ArrayList<SwitchTarget>();
        for (TabInfo each : this.myVisibleInfos) {
            result.add(new TabTarget(each));
        }
        if (originalProvider && this.mySwitchDelegate != null && (additional = this.mySwitchDelegate.getTargets(onlyVisible, false)) != null) {
            result.addAll(additional);
        }
        return result;
    }

    @Override
    public SwitchTarget getCurrentTarget() {
        SwitchTarget selection;
        if (this.mySwitchDelegate != null && (selection = this.mySwitchDelegate.getCurrentTarget()) != null) {
            return selection;
        }
        return new TabTarget(this.getSelectedInfo());
    }

    @Override
    public void resetDropOver(TabInfo tabInfo) {
        if (this.myDropInfo != null) {
            TabInfo dropInfo = this.myDropInfo;
            this.myDropInfo = null;
            this.myShowDropLocation = true;
            this.setDropInfoIndex(-1);
            if (!this.isDisposed()) {
                this.removeTab(dropInfo, null, false, true);
            }
        }
    }

    @Override
    public Image startDropOver(TabInfo tabInfo, RelativePoint point) {
        this.myDropInfo = tabInfo;
        int index = this.myLayout.getDropIndexFor(point.getPoint((Component)this));
        this.setDropInfoIndex(index);
        this.addTab(this.myDropInfo, index, true, true);
        TabLabel label = this.myInfo2Label.get(this.myDropInfo);
        Dimension size = label.getPreferredSize();
        label.setBounds(0, 0, size.width, size.height);
        BufferedImage img = UIUtil.createImage((int)size.width, (int)size.height, (int)2);
        Graphics2D g = img.createGraphics();
        label.paintOffscreen(g);
        g.dispose();
        this.relayout(true, false);
        return img;
    }

    @Override
    public void processDropOver(TabInfo over, RelativePoint point) {
        int index = this.myLayout.getDropIndexFor(point.getPoint((Component)this));
        if (index != this.getDropInfoIndex()) {
            this.setDropInfoIndex(index);
            this.relayout(true, false);
        }
    }

    public int getDropInfoIndex() {
        return this.myDropInfoIndex;
    }

    public boolean isEmptyVisible() {
        return this.myVisibleInfos.isEmpty();
    }

    public int getInterTabSpaceLength() {
        return 1;
    }

    @Override
    public String toString() {
        return "JBTabs visible=" + this.myVisibleInfos + " selected=" + this.mySelectedInfo;
    }

    private class TabTarget
    extends ComparableObject.Impl
    implements SwitchTarget {
        private final TabInfo myInfo;

        private TabTarget(TabInfo info) {
            this.myInfo = info;
        }

        @Override
        public ActionCallback switchTo(boolean requestFocus) {
            return JBTabsImpl.this.select(this.myInfo, requestFocus);
        }

        @Override
        public boolean isVisible() {
            return this.getRectangle() != null;
        }

        @Override
        public RelativeRectangle getRectangle() {
            TabLabel label = JBTabsImpl.this.myInfo2Label.get(this.myInfo);
            if (label.getRootPane() == null) {
                return null;
            }
            Rectangle b = label.getBounds();
            b.x += 2;
            b.width -= 4;
            b.y += 2;
            b.height -= 4;
            return new RelativeRectangle((Component)label.getParent(), b);
        }

        @Override
        public Component getComponent() {
            return JBTabsImpl.this.myInfo2Label.get(this.myInfo);
        }

        public String toString() {
            return this.myInfo.getText();
        }

        public Object[] getEqualityObjects() {
            return new Object[]{this.myInfo};
        }
    }

    private static class DefaultDecorator
    implements UiDecorator {
        private DefaultDecorator() {
        }

        @Override
        public UiDecorator.UiDecoration getDecoration() {
            return new UiDecorator.UiDecoration(null, new Insets(0, 4, 0, 5));
        }
    }

    private static class SelectPreviousAction
    extends BaseNavigationAction {
        private SelectPreviousAction(JBTabsImpl tabs, ActionManager mgr) {
            super("PreviousTab", tabs, mgr);
        }

        @Override
        protected void _update(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            e.getPresentation().setEnabled(tabs.findEnabledBackward(selectedIndex, true) != null);
        }

        @Override
        protected void _actionPerformed(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            TabInfo tabInfo = tabs.findEnabledBackward(selectedIndex, true);
            if (tabInfo != null) {
                tabs.select(tabInfo, true);
            }
        }
    }

    private static class SelectNextAction
    extends BaseNavigationAction {
        private SelectNextAction(JBTabsImpl tabs, ActionManager mgr) {
            super("NextTab", tabs, mgr);
        }

        @Override
        protected void _update(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            e.getPresentation().setEnabled(tabs.findEnabledForward(selectedIndex, true) != null);
        }

        @Override
        protected void _actionPerformed(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            TabInfo tabInfo = tabs.findEnabledForward(selectedIndex, true);
            if (tabInfo != null) {
                tabs.select(tabInfo, true);
            }
        }
    }

    private static abstract class BaseNavigationAction
    extends AnAction {
        private final ShadowAction myShadow;
        private final ActionManager myActionManager;
        private final JBTabsImpl myTabs;

        protected BaseNavigationAction(String copyFromID, JBTabsImpl tabs, ActionManager mgr) {
            this.myActionManager = mgr;
            this.myTabs = tabs;
            this.myShadow = new ShadowAction(this, this.myActionManager.getAction(copyFromID), tabs);
            Disposer.register((Disposable)tabs, (Disposable)this.myShadow);
            this.setEnabledInModalContext(true);
        }

        @Override
        public final void update(AnActionEvent e) {
            JBTabsImpl tabs = e.getData(NAVIGATION_ACTIONS_KEY);
            e.getPresentation().setVisible(tabs != null);
            if (tabs == null) {
                return;
            }
            tabs = this.findNavigatableTabs(tabs);
            e.getPresentation().setEnabled(tabs != null);
            if (tabs != null) {
                this._update(e, tabs, tabs.getVisibleInfos().indexOf(tabs.getSelectedInfo()));
            }
        }

        protected JBTabsImpl findNavigatableTabs(JBTabsImpl tabs) {
            if (tabs == null || tabs != this.myTabs) {
                return null;
            }
            if (BaseNavigationAction.isNavigatable(tabs)) {
                return tabs;
            }
            for (Container c = tabs.getParent(); c != null; c = c.getParent()) {
                if (!(c instanceof JBTabsImpl) || !BaseNavigationAction.isNavigatable((JBTabsImpl)c)) continue;
                return (JBTabsImpl)c;
            }
            return null;
        }

        private static boolean isNavigatable(JBTabsImpl tabs) {
            int selectedIndex = tabs.getVisibleInfos().indexOf(tabs.getSelectedInfo());
            return tabs.isNavigationVisible() && selectedIndex >= 0 && tabs.myNavigationActionsEnabled;
        }

        public void reconnect(String actionId) {
            this.myShadow.reconnect(this.myActionManager.getAction(actionId));
        }

        protected abstract void _update(AnActionEvent var1, JBTabsImpl var2, int var3);

        @Override
        public final void actionPerformed(AnActionEvent e) {
            JBTabsImpl tabs = e.getData(NAVIGATION_ACTIONS_KEY);
            if ((tabs = this.findNavigatableTabs(tabs)) == null) {
                return;
            }
            int index = tabs.getVisibleInfos().indexOf(tabs.getSelectedInfo());
            if (index == -1) {
                return;
            }
            this._actionPerformed(e, tabs, index);
        }

        protected abstract void _actionPerformed(AnActionEvent var1, JBTabsImpl var2, int var3);
    }

    private static class Max {
        final Dimension myLabel = new Dimension();
        final Dimension myToolbar = new Dimension();

        private Max() {
        }
    }

    protected static class ShapeInfo {
        public ShapeTransform path;
        public ShapeTransform fillPath;
        public ShapeTransform labelPath;
        public int labelBottomY;
        public int labelTopY;
        public int labelLeftX;
        public int labelRightX;
        public Insets insets;
        public Color from;
        public Color to;
    }

    public static class Toolbar
    extends JPanel {
        private final JBTabsImpl myTabs;

        public Toolbar(JBTabsImpl tabs, TabInfo info) {
            this.myTabs = tabs;
            this.setLayout(new BorderLayout());
            ActionGroup group = info.getGroup();
            JComponent side = info.getSideComponent();
            if (group != null) {
                String place = info.getPlace();
                ActionToolbar toolbar = this.myTabs.myActionManager.createActionToolbar(place != null ? place : "unknown", group, this.myTabs.myHorizontalSide);
                toolbar.setTargetComponent(info.getActionsContextComponent());
                JComponent actionToolbar = toolbar.getComponent();
                this.add((Component)actionToolbar, "Center");
            }
            if (side != null) {
                if (group != null) {
                    this.add((Component)side, "East");
                } else {
                    this.add((Component)side, "Center");
                }
            }
        }

        public boolean isEmpty() {
            return this.getComponentCount() == 0;
        }
    }

    class TabActionsAutoHideListener
    extends MouseMotionAdapter
    implements Weighted {
        private TabLabel myCurrentOverLabel;
        private Point myLastOverPoint;

        TabActionsAutoHideListener() {
        }

        @Override
        public double getWeight() {
            return 1.0;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!JBTabsImpl.this.myTabLabelActionsAutoHide) {
                return;
            }
            this.myLastOverPoint = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), JBTabsImpl.this);
            this.processMouseOver();
        }

        void processMouseOver() {
            TabLabel label;
            if (!JBTabsImpl.this.myTabLabelActionsAutoHide) {
                return;
            }
            if (this.myLastOverPoint == null) {
                return;
            }
            if (this.myLastOverPoint.x >= 0 && this.myLastOverPoint.x < JBTabsImpl.this.getWidth() && this.myLastOverPoint.y > 0 && this.myLastOverPoint.y < JBTabsImpl.this.getHeight() && (label = JBTabsImpl.this.myInfo2Label.get(JBTabsImpl.this._findInfo(this.myLastOverPoint, true))) != null) {
                if (this.myCurrentOverLabel != null) {
                    this.myCurrentOverLabel.toggleShowActions(false);
                }
                label.toggleShowActions(true);
                this.myCurrentOverLabel = label;
                return;
            }
            if (this.myCurrentOverLabel != null) {
                this.myCurrentOverLabel.toggleShowActions(false);
                this.myCurrentOverLabel = null;
            }
        }
    }
}

