/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.table;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.table.JBTable;
import com.intellij.util.config.Storage;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BaseTableView
extends JBTable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.table.BaseTableView");

    public BaseTableView(TableModel model) {
        super(model);
    }

    public BaseTableView(TableModel model, TableColumnModel columnModel) {
        super(model, columnModel);
    }

    private static String orderPropertyName(int index) {
        return "Order" + index;
    }

    private static String widthPropertyName(int index) {
        return "Width" + index;
    }

    public static void store(Storage storage, JTable table) {
        TableColumnModel model = table.getTableHeader().getColumnModel();
        int columnCount = model.getColumnCount();
        boolean[] storedColumns = new boolean[columnCount];
        Arrays.fill(storedColumns, false);
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = model.getColumn(i);
            storage.put(BaseTableView.widthPropertyName(i), String.valueOf(column.getWidth()));
            int modelIndex = column.getModelIndex();
            storage.put(BaseTableView.orderPropertyName(i), String.valueOf(modelIndex));
            if (storedColumns[modelIndex]) {
                LOG.error("columnCount: " + columnCount + " current: " + i + " modelINdex: " + modelIndex);
            }
            storedColumns[modelIndex] = true;
        }
    }

    public static void storeWidth(Storage storage, TableColumnModel columns) {
        for (int i = 0; i < columns.getColumnCount(); ++i) {
            storage.put(BaseTableView.widthPropertyName(i), String.valueOf(columns.getColumn(i).getWidth()));
        }
    }

    public static void restore(Storage storage, JTable table) {
        String order;
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        int index = 0;
        ArrayList<String> columnIndices = new ArrayList<String>();
        while ((order = storage.get(BaseTableView.orderPropertyName(index))) != null) {
            columnIndices.add(order);
            if (++index != table.getColumnCount()) continue;
            break;
        }
        index = 0;
        for (String columnIndex : columnIndices) {
            int modelColumnIndex = BaseTableView.indexbyModelIndex(columnModel, Integer.parseInt(columnIndex));
            if (modelColumnIndex > 0 && modelColumnIndex < columnModel.getColumnCount()) {
                columnModel.moveColumn(modelColumnIndex, index);
            }
            ++index;
        }
        for (int i = 0; i < columnIndices.size(); ++i) {
            String width = storage.get(BaseTableView.widthPropertyName(i));
            if (width == null || width.length() <= 0) continue;
            try {
                columnModel.getColumn(i).setPreferredWidth(Integer.parseInt(width));
                continue;
            }
            catch (NumberFormatException e) {
                LOG.error("Bad width: " + width + " at column: " + i + " from: " + storage + " actual columns count: " + columnModel.getColumnCount() + " info count: " + columnIndices.size(), (Throwable)e);
            }
        }
    }

    public static void restoreWidth(Storage storage, TableColumnModel columns) {
        String widthValue;
        int index = 0;
        while ((widthValue = storage.get(BaseTableView.widthPropertyName(index))) != null) {
            try {
                columns.getColumn(index).setPreferredWidth(Integer.parseInt(widthValue));
            }
            catch (NumberFormatException e) {
                LOG.error("Bad width: " + widthValue + " at column: " + index + " from: " + storage, (Throwable)e);
            }
            ++index;
        }
    }

    private static int indexbyModelIndex(TableColumnModel model, int index) {
        for (int i = 0; i < model.getColumnCount(); ++i) {
            if (model.getColumn(i).getModelIndex() != index) continue;
            return i;
        }
        LOG.error("Total: " + model.getColumnCount() + " index: " + index);
        return index;
    }
}

