/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.docking;

import com.intellij.openapi.Disposable;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.docking.DockableContent;
import com.intellij.util.ui.update.Activatable;
import java.awt.Image;
import javax.swing.JComponent;
import org.jdom.Element;

public interface DockContainer
extends Disposable,
Activatable {
    public RelativeRectangle getAcceptArea();

    public RelativeRectangle getAcceptAreaFallback();

    public ContentResponse getContentResponse(DockableContent var1, RelativePoint var2);

    public JComponent getContainerComponent();

    public void add(DockableContent var1, RelativePoint var2);

    public void closeAll();

    public void addListener(Listener var1, Disposable var2);

    public boolean isEmpty();

    public Image startDropOver(DockableContent var1, RelativePoint var2);

    public Image processDropOver(DockableContent var1, RelativePoint var2);

    public void resetDropOver(DockableContent var1);

    public boolean isDisposeWhenEmpty();

    public static interface Listener {
        public void contentAdded(Object var1);

        public void contentRemoved(Object var1);

        public static class Adapter
        implements Listener {
            @Override
            public void contentAdded(Object key) {
            }

            @Override
            public void contentRemoved(Object key) {
            }
        }
    }

    public static interface Persistent
    extends DockContainer {
        public String getDockContainerType();

        public Element getState();
    }

    public static interface Dialog
    extends DockContainer {
    }

    public static enum ContentResponse {
        ACCEPT_MOVE,
        ACCEPT_COPY,
        DENY;


        public boolean canAccept() {
            return this != DENY;
        }
    }
}

