/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.intellij.lang.annotations.JdkConstants;

public class JBTabbedPane
extends JTabbedPane
implements HierarchyListener {
    public static final String LABEL_FROM_TABBED_PANE = "JBTabbedPane.labelFromTabbedPane";
    private int previousSelectedIndex = -1;

    public JBTabbedPane() {
    }

    public JBTabbedPane(@JdkConstants.TabPlacement int tabPlacement) {
        super(tabPlacement);
    }

    public JBTabbedPane(@JdkConstants.TabPlacement int tabPlacement, @JdkConstants.TabLayoutPolicy int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    @Override
    public void setComponentAt(int index, Component component) {
        super.setComponentAt(index, component);
        component.addHierarchyListener(this);
        UIUtil.setNotOpaqueRecursively((Component)component);
        this.setInsets(component);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        JLabel label = new JLabel(title);
        label.setIcon(icon);
        label.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setTabComponentAt(index, label);
        this.updateSelectedTabForeground();
        label.putClientProperty(LABEL_FROM_TABBED_PANE, Boolean.TRUE);
        component.addHierarchyListener(this);
        UIUtil.setNotOpaqueRecursively((Component)component);
        this.setInsets(component);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setSelectedIndex(int index) {
        this.previousSelectedIndex = this.getSelectedIndex();
        super.setSelectedIndex(index);
        this.updateSelectedTabForeground();
        this.revalidate();
        this.repaint();
    }

    private void updateSelectedTabForeground() {
        if (UIUtil.isUnderAquaLookAndFeel() && SystemInfo.isMacOSLion) {
            if (this.getSelectedIndex() != -1 && this.getTabComponentAt(this.getSelectedIndex()) != null) {
                this.getTabComponentAt(this.getSelectedIndex()).setForeground(Color.WHITE);
            }
            if (this.previousSelectedIndex != -1 && this.getTabComponentAt(this.previousSelectedIndex) != null) {
                this.getTabComponentAt(this.previousSelectedIndex).setForeground(JBColor.foreground());
            }
        }
    }

    private void setInsets(Component component) {
        if (component instanceof JComponent) {
            UIUtil.addInsets((JComponent)((JComponent)component), (Insets)this.getInsetsForTabComponent());
        }
    }

    protected Insets getInsetsForTabComponent() {
        return UIUtil.PANEL_SMALL_INSETS;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        UIUtil.setNotOpaqueRecursively((Component)e.getComponent());
        this.repaint();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (!ScreenUtil.isStandardAddRemoveNotify(this)) {
            return;
        }
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.getComponentAt(i).removeHierarchyListener(this);
        }
    }
}

