/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandableItemsHandlerFactory;
import com.intellij.ui.ExpandedItemListCellRendererWrapper;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class JBList
extends JList
implements ComponentWithEmptyText,
ComponentWithExpandableItems<Integer> {
    private StatusText myEmptyText;
    private ExpandableItemsHandler<Integer> myExpandableItemsHandler;
    private AsyncProcessIcon myBusyIcon;
    private boolean myBusy;

    public JBList() {
        this.init();
    }

    public JBList(ListModel dataModel) {
        super(dataModel);
        this.init();
    }

    public JBList(Object ... listData) {
        super(JBList.createDefaultListModel(listData));
        this.init();
    }

    public static DefaultListModel createDefaultListModel(Object ... items) {
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        for (Object item : items) {
            model.add(model.getSize(), item);
        }
        return model;
    }

    public JBList(Collection items) {
        this(ArrayUtil.toObjectArray((Collection)items));
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (!ScreenUtil.isStandardAddRemoveNotify(this)) {
            return;
        }
        if (this.myBusyIcon != null) {
            this.remove(this.myBusyIcon);
            Disposer.dispose((Disposable)this.myBusyIcon);
            this.myBusyIcon = null;
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    public void setPaintBusy(boolean paintBusy) {
        if (this.myBusy == paintBusy) {
            return;
        }
        this.myBusy = paintBusy;
        this.updateBusy();
    }

    private void updateBusy() {
        if (this.myBusy && this.myBusyIcon == null) {
            this.myBusyIcon = new AsyncProcessIcon(this.toString()).setUseMask(false);
            this.myBusyIcon.setOpaque(false);
            this.myBusyIcon.setPaintPassiveIcon(false);
            this.add(this.myBusyIcon);
        }
        if (this.myBusyIcon != null) {
            if (this.myBusy) {
                this.myBusyIcon.resume();
            } else {
                this.myBusyIcon.suspend();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (JBList.this.myBusyIcon != null) {
                            JBList.this.repaint();
                        }
                    }
                });
            }
            if (this.myBusyIcon != null) {
                this.myBusyIcon.updateLocation(this);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myEmptyText.paint(this, g);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getModel().getSize() == 0 && !StringUtil.isEmpty((String)this.getEmptyText().getText())) {
            Dimension s = this.getEmptyText().getPreferredSize();
            Insets insets = this.getInsets();
            if (insets != null) {
                s.width += insets.left + insets.right;
                s.height += insets.top + insets.bottom;
            }
            return s;
        }
        return super.getPreferredSize();
    }

    private void init() {
        this.setSelectionBackground(UIUtil.getListSelectionBackground());
        this.setSelectionForeground(UIUtil.getListSelectionForeground());
        this.myEmptyText = new StatusText(this){

            @Override
            protected boolean isStatusVisible() {
                return JBList.this.isEmpty();
            }
        };
        this.myExpandableItemsHandler = this.createExpandableItemsHandler();
        this.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer());
    }

    public boolean isEmpty() {
        return this.getItemsCount() == 0;
    }

    public int getItemsCount() {
        ListModel model = this.getModel();
        return model == null ? 0 : model.getSize();
    }

    @Override
    public StatusText getEmptyText() {
        return this.myEmptyText;
    }

    public void setEmptyText(String text) {
        this.myEmptyText.setText(text);
    }

    @Override
    public ExpandableItemsHandler<Integer> getExpandableItemsHandler() {
        return this.myExpandableItemsHandler;
    }

    protected ExpandableItemsHandler<Integer> createExpandableItemsHandler() {
        return ExpandableItemsHandlerFactory.install(this);
    }

    @Override
    public void setExpandableItemsEnabled(boolean enabled) {
        this.myExpandableItemsHandler.setEnabled(enabled);
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        if (this.myExpandableItemsHandler == null) {
            super.setCellRenderer(cellRenderer);
            return;
        }
        super.setCellRenderer(new ExpandedItemListCellRendererWrapper(cellRenderer, this.myExpandableItemsHandler));
    }

    public <T> void installCellRenderer(final NotNullFunction<T, JComponent> fun) {
        this.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JComponent comp = (JComponent)fun.fun(value);
                comp.setOpaque(true);
                if (isSelected) {
                    comp.setBackground(list.getSelectionBackground());
                    comp.setForeground(list.getSelectionForeground());
                } else {
                    comp.setBackground(list.getBackground());
                    comp.setForeground(list.getForeground());
                }
                for (JLabel label : UIUtil.findComponentsOfType((JComponent)comp, JLabel.class)) {
                    label.setForeground(UIUtil.getListForeground((boolean)isSelected));
                }
                return comp;
            }
        });
    }

    public void setDataProvider(DataProvider provider) {
        DataManager.registerDataProvider(this, provider);
    }

    public void disableEmptyText() {
        this.getEmptyText().setText("");
    }

    public static class StripedListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!isSelected && index % 2 == 0) {
                this.setBackground(UIUtil.getDecoratedRowColor());
            }
            return this;
        }
    }
}

