/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.classFilter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;

@Tag(value="class-filter")
public class ClassFilter
implements JDOMExternalizable,
Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.classFilter.ClassFilter");
    public static final ClassFilter[] EMPTY_ARRAY = new ClassFilter[0];
    @Attribute(value="pattern")
    public String PATTERN = "";
    @Attribute(value="enabled")
    public boolean ENABLED = true;
    private Matcher myMatcher;

    public ClassFilter() {
    }

    public ClassFilter(String pattern) {
        this.PATTERN = pattern;
        this.ENABLED = true;
    }

    @Transient
    public String getPattern() {
        return this.PATTERN;
    }

    @Transient
    public boolean isEnabled() {
        return this.ENABLED;
    }

    public void setPattern(String pattern) {
        if (pattern != null && !pattern.equals(this.PATTERN)) {
            this.PATTERN = pattern;
            this.myMatcher = null;
        }
    }

    public void setEnabled(boolean value) {
        this.ENABLED = value;
    }

    public String toString() {
        return this.getPattern();
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassFilter)) {
            return false;
        }
        ClassFilter classFilter = (ClassFilter)o;
        if (this.isEnabled() != classFilter.isEnabled()) {
            return false;
        }
        return this.getPattern().equals(classFilter.getPattern());
    }

    public int hashCode() {
        int result = this.PATTERN.hashCode();
        result = 29 * result + (this.ENABLED ? 1 : 0);
        return result;
    }

    public ClassFilter clone() {
        try {
            return (ClassFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public boolean matches(String name) {
        return this.getMatcher(name).matches();
    }

    private Matcher getMatcher(String name) {
        if (this.myMatcher == null) {
            String regex = this.getPattern().replaceAll("\\.", "\\\\.").replaceAll("\\$", "\\\\\\$").replaceAll("\\*", ".*");
            Pattern pattern = Pattern.compile(regex);
            this.myMatcher = pattern.matcher("");
        }
        this.myMatcher.reset(name);
        return this.myMatcher;
    }
}

