/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;

public class UI {
    private static final Map<String, Color> ourColors = new HashMap<String, Color>();

    private UI() {
    }

    public static Color getColor(String id) {
        Color color;
        if (UIUtil.isUnderDarcula() && (color = UIManager.getColor(id)) != null) {
            return color;
        }
        return ourColors.get(id);
    }

    static {
        ourColors.put("panel.border.color", new Color(102, 101, 84));
        ourColors.put("panel.separator.color", new Color(180, 179, 169));
        ourColors.put("panel.custom.background", new Color(250, 249, 245));
        ourColors.put("link.foreground", new Color(82, 99, 155));
        ourColors.put("link.pressed.foreground", (Color)new JBColor(new Color(240, 0, 0), new Color(186, 111, 37)));
        ourColors.put("link.visited.foreground", (Color)new JBColor(new Color(128, 0, 128), new Color(151, 118, 169)));
        ourColors.put("bar.separator.foreground", UI.getColor("panel.separator.color"));
        ourColors.put("bar.selected.separator.foreground", new Color(232, 231, 228));
        ourColors.put("bar.background", UIUtil.getPanelBackground());
        ourColors.put("bar.hover.background", UIUtil.getTreeSelectionBackground());
        ourColors.put("bar.selected.background", UI.getColor("panel.custom.background"));
        ourColors.put("bar.hover.frame.foreground", UIUtil.getTreeSelectionBackground().darker());
        ourColors.put("popup.selected.background", UIUtil.getTreeSelectionBackground());
        ourColors.put("popup.selected.frame.foreground", UIUtil.getTreeSelectionBackground().darker());
        ourColors.put("popup.separator.foreground", (Color)JBColor.GRAY);
        ourColors.put("callout.background", (Color)JBColor.WHITE);
        ourColors.put("callout.frame.color", (Color)JBColor.RED);
        ourColors.put("underline.error", (Color)JBColor.RED);
        ourColors.put("underline.warning", (Color)JBColor.YELLOW);
        ourColors.put("tooltip.error", (Color)JBColor.RED);
        ourColors.put("tooltip.warning", JBColor.YELLOW.darker());
        ourColors.put("toolbar.background", UIUtil.getPanelBackground());
        ourColors.put("toolbar.hover.background", UIUtil.getTreeSelectionBackground());
        ourColors.put("toolbar.selected.background", UI.getColor("panel.custom.background"));
        ourColors.put("toolbar.hover.frame.foreground", UIUtil.getTreeSelectionBackground().darker());
        ourColors.put("speedsearch.background", new Color(244, 249, 181));
        ourColors.put("speedsearch.foreground", (Color)JBColor.BLACK);
    }
}

