/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;

public class TitledSeparator
extends JPanel {
    public static final int TOP_INSET = 7;
    public static final int BOTTOM_INSET = 5;
    public static final int SEPARATOR_LEFT_INSET = 6;
    public static final int SEPARATOR_RIGHT_INSET = 3;
    public static final Border EMPTY_BORDER = IdeBorderFactory.createEmptyBorder(7, 0, 5, 0);
    protected final JBLabel myLabel = new JBLabel(){

        @Override
        public Font getFont() {
            return UIUtil.getTitledBorderFont();
        }
    };
    protected final JSeparator mySeparator = new JSeparator(0);
    private String originalText;

    public TitledSeparator() {
        this("");
    }

    public TitledSeparator(String text) {
        this(text, null);
    }

    public TitledSeparator(String text, JComponent labelFor) {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.myLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.mySeparator, new GridBagConstraints(1, 0, 0, 1, 1.0, 1.0, 10, 2, new Insets(2, 6, 0, 3), 0, 0));
        this.setBorder(EMPTY_BORDER);
        this.setText(text);
        this.setLabelFor(labelFor);
    }

    public String getText() {
        return this.originalText;
    }

    public void setText(String text) {
        this.originalText = text;
        this.myLabel.setText(UIUtil.replaceMnemonicAmpersand((String)this.originalText));
    }

    public void setTitleFont(Font font) {
        this.myLabel.setFont(font);
    }

    public Font getTitleFont() {
        return this.myLabel.getFont();
    }

    public JLabel getLabel() {
        return this.myLabel;
    }

    public JSeparator getSeparator() {
        return this.mySeparator;
    }

    public Component getLabelFor() {
        return this.myLabel.getLabelFor();
    }

    public void setLabelFor(Component labelFor) {
        this.myLabel.setLabelFor(labelFor);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myLabel.setEnabled(enabled);
        this.mySeparator.setEnabled(enabled);
    }
}

