/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;

public class EditorNotificationPanel
extends JPanel {
    protected final JLabel myLabel = new JLabel();
    protected final JLabel myGearLabel = new JLabel();
    protected final JPanel myLinksPanel = new NonOpaquePanel(new HorizontalLayout(JBUI.scale((int)5)));

    public EditorNotificationPanel() {
        super(new BorderLayout());
        NonOpaquePanel panel = new NonOpaquePanel(new BorderLayout());
        panel.add("Center", this.myLabel);
        panel.add("East", this.myLinksPanel);
        panel.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)5, (int)5));
        panel.setMinimumSize(new Dimension(0, 0));
        this.add("Center", panel);
        this.add("East", this.myGearLabel);
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
    }

    public void setText(String text) {
        this.myLabel.setText(text);
    }

    public EditorNotificationPanel text(String text) {
        this.myLabel.setText(text);
        return this;
    }

    public EditorNotificationPanel icon(Icon icon) {
        this.myLabel.setIcon(icon);
        return this;
    }

    @Override
    public Color getBackground() {
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
        return color == null ? UIUtil.getToolTipBackground() : color;
    }

    public HyperlinkLabel createActionLabel(String text, final String actionId) {
        return this.createActionLabel(text, new Runnable(){

            @Override
            public void run() {
                EditorNotificationPanel.this.executeAction(actionId);
            }
        });
    }

    public HyperlinkLabel createActionLabel(String text, final Runnable action) {
        HyperlinkLabel label = new HyperlinkLabel(text, PlatformColors.BLUE, this.getBackground(), PlatformColors.BLUE);
        label.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                action.run();
            }
        });
        this.myLinksPanel.add(label);
        return label;
    }

    protected void executeAction(String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext(this), "unknown", action.getTemplatePresentation(), ActionManager.getInstance(), 0);
        action.beforeActionPerformedUpdate(event);
        action.update(event);
        if (event.getPresentation().isEnabled() && event.getPresentation().isVisible()) {
            action.actionPerformed(event);
        }
    }
}

