/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

public class CommonActionsPanel
extends JPanel {
    private final boolean myDecorateButtons;
    private final ActionToolbarPosition myPosition;
    private Map<Buttons, MyActionButton> myButtons = new HashMap<Buttons, MyActionButton>();
    private final AnActionButton[] myActions;

    CommonActionsPanel(ListenerFactory factory, JComponent contextComponent, ActionToolbarPosition position, AnActionButton[] additionalActions, Comparator<AnActionButton> buttonComparator, String addName, String removeName, String moveUpName, String moveDownName, String editName, Icon addIcon, Buttons ... buttons) {
        super(new BorderLayout());
        int i;
        this.myPosition = position;
        Listener listener = factory.createListener(this);
        AnActionButton[] actions = new AnActionButton[buttons.length + (additionalActions == null ? 0 : additionalActions.length)];
        for (i = 0; i < buttons.length; ++i) {
            Buttons button = buttons[i];
            String name = null;
            switch (button) {
                case ADD: {
                    name = addName;
                    break;
                }
                case EDIT: {
                    name = editName;
                    break;
                }
                case REMOVE: {
                    name = removeName;
                    break;
                }
                case UP: {
                    name = moveUpName;
                    break;
                }
                case DOWN: {
                    name = moveDownName;
                }
            }
            MyActionButton b = button.createButton(listener, name, button == Buttons.ADD && addIcon != null ? addIcon : button.getIcon());
            actions[i] = b;
            this.myButtons.put(button, b);
        }
        if (additionalActions != null && additionalActions.length > 0) {
            i = buttons.length;
            for (AnActionButton button : additionalActions) {
                actions[i++] = button;
            }
        }
        this.myActions = actions;
        for (AnActionButton action : actions) {
            action.setContextComponent(contextComponent);
        }
        if (buttonComparator != null) {
            Arrays.sort(this.myActions, buttonComparator);
        }
        ArrayList toolbarActions = ContainerUtilRt.newArrayList((Object[])this.myActions);
        for (int i2 = 0; i2 < toolbarActions.size(); ++i2) {
            if (!(toolbarActions.get(i2) instanceof AnActionButton.CheckedAnActionButton)) continue;
            toolbarActions.set(i2, ((AnActionButton.CheckedAnActionButton)toolbarActions.get(i2)).getDelegate());
        }
        this.myDecorateButtons = UIUtil.isUnderAquaLookAndFeel() && position == ActionToolbarPosition.BOTTOM;
        ActionManagerEx mgr = (ActionManagerEx)ActionManager.getInstance();
        ActionToolbar toolbar = mgr.createActionToolbar("unknown", new DefaultActionGroup(toolbarActions.toArray(new AnAction[toolbarActions.size()])), position == ActionToolbarPosition.BOTTOM || position == ActionToolbarPosition.TOP, this.myDecorateButtons);
        toolbar.getComponent().setOpaque(false);
        toolbar.getComponent().setBorder(null);
        this.add((Component)toolbar.getComponent(), "Center");
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g = (Graphics2D)g2;
        if (this.myDecorateButtons) {
            MacUIUtil.drawToolbarDecoratorBackground((Graphics)g, (int)this.getWidth(), (int)this.getHeight());
        } else {
            super.paintComponent(g);
        }
    }

    public AnActionButton getAnActionButton(Buttons button) {
        return this.myButtons.get((Object)button);
    }

    @Override
    public void addNotify() {
        if (this.getBackground() != null && !this.getBackground().equals(UIUtil.getPanelBackground())) {
            SwingUtilities.updateComponentTreeUI(this.getParent());
        }
        JRootPane pane = this.getRootPane();
        for (AnActionButton button : this.myActions) {
            ShortcutSet shortcut = button.getShortcut();
            if (shortcut == null) continue;
            if (button instanceof MyActionButton && ((MyActionButton)button).isAddButton() && UIUtil.isDialogRootPane((JRootPane)pane)) {
                button.registerCustomShortcutSet(shortcut, pane);
            } else {
                button.registerCustomShortcutSet(shortcut, button.getContextComponent());
            }
            if (!(button instanceof MyActionButton) || !((MyActionButton)button).isRemoveButton()) continue;
            CommonActionsPanel.registerDeleteHook((MyActionButton)button);
        }
        super.addNotify();
    }

    private static void registerDeleteHook(final MyActionButton removeButton) {
        new AnAction("Delete Hook"){

            @Override
            public void actionPerformed(AnActionEvent e) {
                removeButton.actionPerformed(e);
            }

            @Override
            public boolean isDumbAware() {
                return removeButton.isDumbAware();
            }

            @Override
            public void update(AnActionEvent e) {
                JComponent contextComponent = removeButton.getContextComponent();
                if (contextComponent instanceof JTable && ((JTable)contextComponent).isEditing()) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                SpeedSearchSupply supply = SpeedSearchSupply.getSupply(contextComponent);
                if (supply != null && supply.isPopupActive()) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                removeButton.update(e);
            }
        }.registerCustomShortcutSet(CustomShortcutSet.fromString("DELETE", "BACK_SPACE"), removeButton.getContextComponent());
    }

    public void setEnabled(Buttons button, boolean enabled) {
        MyActionButton b = this.myButtons.get((Object)button);
        if (b != null) {
            b.setEnabled(enabled);
        }
    }

    public ActionToolbarPosition getPosition() {
        return this.myPosition;
    }

    public static ShortcutSet getCommonShortcut(Buttons button) {
        switch (button) {
            case ADD: {
                return CommonShortcuts.getNewForDialogs();
            }
            case EDIT: {
                return CustomShortcutSet.fromString("ENTER");
            }
            case REMOVE: {
                return CustomShortcutSet.fromString(SystemInfo.isMac ? "meta BACK_SPACE" : "alt DELETE");
            }
            case UP: {
                return CommonShortcuts.MOVE_UP;
            }
            case DOWN: {
                return CommonShortcuts.MOVE_DOWN;
            }
        }
        return null;
    }

    static interface ListenerFactory {
        public Listener createListener(CommonActionsPanel var1);
    }

    static class MyActionButton
    extends AnActionButton
    implements DumbAware {
        private final Buttons myButton;
        private final Listener myListener;

        MyActionButton(Buttons button, Listener listener, String name, Icon icon) {
            super(name, name, icon);
            this.myButton = button;
            this.myListener = listener;
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            this.myButton.performAction(this.myListener);
        }

        @Override
        public ShortcutSet getShortcut() {
            return CommonActionsPanel.getCommonShortcut(this.myButton);
        }

        @Override
        public void updateButton(AnActionEvent e) {
            super.updateButton(e);
            if (!e.getPresentation().isEnabled()) {
                return;
            }
            JComponent c = this.getContextComponent();
            if (c instanceof JTable || c instanceof JList) {
                InputEvent inputEvent;
                if (this.myButton == Buttons.EDIT && (inputEvent = e.getInputEvent()) instanceof KeyEvent && c instanceof JTable && ((JTable)c).isEditing() && !(inputEvent.getComponent() instanceof ActionButtonComponent)) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                ListSelectionModel model = c instanceof JTable ? ((JTable)c).getSelectionModel() : ((JList)c).getSelectionModel();
                int size = c instanceof JTable ? ((JTable)c).getRowCount() : ((JList)c).getModel().getSize();
                int min = model.getMinSelectionIndex();
                int max = model.getMaxSelectionIndex();
                if (this.myButton == Buttons.UP && min < 1 || this.myButton == Buttons.DOWN && max == size - 1 || this.myButton != Buttons.ADD && size == 0 || this.myButton == Buttons.EDIT && (min != max || min == -1)) {
                    e.getPresentation().setEnabled(false);
                } else {
                    e.getPresentation().setEnabled(this.isEnabled());
                }
            }
        }

        boolean isAddButton() {
            return this.myButton == Buttons.ADD;
        }

        boolean isRemoveButton() {
            return this.myButton == Buttons.REMOVE;
        }
    }

    public static interface Listener {
        public void doAdd();

        public void doRemove();

        public void doUp();

        public void doDown();

        public void doEdit();

        public static class Adapter
        implements Listener {
            @Override
            public void doAdd() {
            }

            @Override
            public void doRemove() {
            }

            @Override
            public void doUp() {
            }

            @Override
            public void doDown() {
            }

            @Override
            public void doEdit() {
            }
        }
    }

    public static enum Buttons {
        ADD,
        REMOVE,
        EDIT,
        UP,
        DOWN;

        public static Buttons[] ALL;

        public Icon getIcon() {
            switch (this) {
                case ADD: {
                    return IconUtil.getAddIcon();
                }
                case EDIT: {
                    return IconUtil.getEditIcon();
                }
                case REMOVE: {
                    return IconUtil.getRemoveIcon();
                }
                case UP: {
                    return IconUtil.getMoveUpIcon();
                }
                case DOWN: {
                    return IconUtil.getMoveDownIcon();
                }
            }
            return null;
        }

        MyActionButton createButton(Listener listener, String name, Icon icon) {
            return new MyActionButton(this, listener, name == null ? StringUtil.capitalize((String)this.name().toLowerCase()) : name, icon);
        }

        public String getText() {
            return StringUtil.capitalize((String)this.name().toLowerCase());
        }

        public void performAction(Listener listener) {
            switch (this) {
                case ADD: {
                    listener.doAdd();
                    break;
                }
                case EDIT: {
                    listener.doEdit();
                    break;
                }
                case REMOVE: {
                    listener.doRemove();
                    break;
                }
                case UP: {
                    listener.doUp();
                    break;
                }
                case DOWN: {
                    listener.doDown();
                }
            }
        }

        static {
            ALL = new Buttons[]{ADD, REMOVE, EDIT, UP, DOWN};
        }
    }
}

