/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.EditableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;

public class CollectionListModel<T>
extends AbstractListModel
implements EditableModel {
    private final List<T> myItems;

    public CollectionListModel(Collection<? extends T> items) {
        this.myItems = new ArrayList<T>(items);
    }

    public CollectionListModel(List<? extends T> items) {
        this((Collection<? extends T>)items);
    }

    public CollectionListModel(T ... items) {
        this.myItems = ContainerUtilRt.newArrayList((Object[])items);
    }

    @Override
    public int getSize() {
        return this.myItems.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.myItems.get(index);
    }

    public void add(T element) {
        int i = this.myItems.size();
        this.myItems.add(element);
        this.fireIntervalAdded(this, i, i);
    }

    public void add(int i, T element) {
        this.myItems.add(i, element);
        this.fireIntervalAdded(this, i, i);
    }

    public void add(List<? extends T> elements) {
        if (elements.isEmpty()) {
            return;
        }
        int i = this.myItems.size();
        this.myItems.addAll(elements);
        this.fireIntervalAdded(this, i, i + elements.size() - 1);
    }

    public void remove(T element) {
        int i = this.myItems.indexOf(element);
        if (this.myItems.remove(element)) {
            this.fireIntervalRemoved(this, i, i);
        }
    }

    public void setElementAt(T element, int index) {
        this.myItems.set(index, element);
        this.fireContentsChanged(this, index, index);
    }

    public void remove(int index) {
        this.myItems.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void removeAll() {
        int size = this.myItems.size();
        if (size > 0) {
            this.myItems.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }
    }

    public void contentsChanged(T element) {
        int i = this.myItems.indexOf(element);
        this.fireContentsChanged(this, i, i);
    }

    public void sort(Comparator<T> comparator) {
        Collections.sort(this.myItems, comparator);
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.myItems);
    }

    public void replaceAll(List<? extends T> elements) {
        this.removeAll();
        this.add(elements);
    }

    public void addRow() {
    }

    public void removeRow(int index) {
        this.remove(index);
    }

    public void exchangeRows(int oldIndex, int newIndex) {
        Collections.swap(this.myItems, oldIndex, newIndex);
        this.fireContentsChanged(this, oldIndex, oldIndex);
        this.fireContentsChanged(this, newIndex, newIndex);
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return true;
    }

    public String toString() {
        return this.getClass().getName() + " (" + this.getSize() + " elements)";
    }

    public List<T> toList() {
        return new ArrayList<T>(this.myItems);
    }

    public int getElementIndex(T item) {
        return this.myItems.indexOf(item);
    }
}

