/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public abstract class AnActionButton
extends AnAction
implements ShortcutProvider {
    private boolean myEnabled = true;
    private boolean myVisible = true;
    private ShortcutSet myShortcut;
    private AnAction myAction = null;
    private JComponent myContextComponent;
    private Set<AnActionButtonUpdater> myUpdaters;

    public AnActionButton(String text) {
        super(text);
    }

    public AnActionButton(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    public AnActionButton(String text, Icon icon) {
        this(text, null, icon);
    }

    public AnActionButton() {
    }

    public static AnActionButton fromAction(AnAction action) {
        Presentation presentation = action.getTemplatePresentation();
        return action instanceof CheckedActionGroup ? new CheckedAnActionButton(presentation, action) : new AnActionButtonWrapper(presentation, action);
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible) {
        this.myVisible = visible;
    }

    @Override
    public final void update(AnActionEvent e) {
        boolean enabled;
        boolean myActionVisible = true;
        boolean myActionEnabled = true;
        if (this.myAction != null) {
            this.myAction.update(e);
            myActionEnabled = e.getPresentation().isEnabled();
            myActionVisible = e.getPresentation().isVisible();
        }
        boolean bl = enabled = this.isEnabled() && this.isContextComponentOk() && myActionEnabled;
        if (enabled && this.myUpdaters != null) {
            for (AnActionButtonUpdater updater : this.myUpdaters) {
                if (updater.isEnabled(e)) continue;
                enabled = false;
                break;
            }
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(this.isVisible() && myActionVisible);
        if (enabled) {
            this.updateButton(e);
        }
    }

    public final void addCustomUpdater(AnActionButtonUpdater updater) {
        if (this.myUpdaters == null) {
            this.myUpdaters = new SmartHashSet();
        }
        this.myUpdaters.add(updater);
    }

    public void updateButton(AnActionEvent e) {
        JComponent component = this.getContextComponent();
        e.getPresentation().setEnabled(component != null && component.isShowing() && component.isEnabled());
    }

    @Override
    public ShortcutSet getShortcut() {
        return this.myShortcut;
    }

    public void setShortcut(ShortcutSet shortcut) {
        this.myShortcut = shortcut;
    }

    public void setContextComponent(JComponent contextComponent) {
        this.myContextComponent = contextComponent;
    }

    public JComponent getContextComponent() {
        return this.myContextComponent;
    }

    public DataContext getDataContext() {
        return DataManager.getInstance().getDataContext(this.getContextComponent());
    }

    private boolean isContextComponentOk() {
        return this.myContextComponent == null || this.myContextComponent.isVisible() && UIUtil.getParentOfType(JLayeredPane.class, (Component)this.myContextComponent) != null;
    }

    public final RelativePoint getPreferredPopupPoint() {
        Container c = this.myContextComponent;
        ActionToolbar toolbar = null;
        while (!((c = c.getParent()) == null || c instanceof JComponent && (toolbar = (ActionToolbar)((JComponent)c).getClientProperty("ACTION_TOOLBAR")) != null)) {
        }
        if (toolbar instanceof JComponent) {
            for (Component comp : ((JComponent)((Object)toolbar)).getComponents()) {
                if (!(comp instanceof ActionButtonComponent) || !(comp instanceof AnActionHolder) || ((AnActionHolder)((Object)comp)).getAction() != this) continue;
                return new RelativePoint((Component)comp.getParent(), new Point(comp.getX(), comp.getY() + comp.getHeight()));
            }
        }
        return null;
    }

    public static class AnActionEventWrapper
    extends AnActionEvent {
        private final AnActionButton myPeer;

        private AnActionEventWrapper(AnActionEvent e, AnActionButton peer) {
            super(e.getInputEvent(), e.getDataContext(), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers());
            this.myPeer = peer;
        }

        public void showPopup(JBPopup popup) {
            popup.show(this.myPeer.getPreferredPopupPoint());
        }
    }

    private static class AnActionButtonWrapper
    extends AnActionButton {
        private final AnAction myAction;

        public AnActionButtonWrapper(Presentation presentation, AnAction action) {
            super(presentation.getText(), presentation.getDescription(), presentation.getIcon());
            this.myAction = action;
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            this.myAction.actionPerformed(new AnActionEventWrapper(e, this));
        }

        @Override
        public void updateButton(AnActionEvent e) {
            this.myAction.update(e);
            boolean enabled = e.getPresentation().isEnabled();
            boolean visible = e.getPresentation().isVisible();
            if (enabled && visible) {
                super.updateButton(e);
            }
        }

        @Override
        public boolean isDumbAware() {
            return this.myAction.isDumbAware();
        }
    }

    public static class CheckedAnActionButton
    extends AnActionButtonWrapper
    implements CheckedActionGroup {
        private final AnAction myDelegate;

        public CheckedAnActionButton(Presentation presentation, AnAction action) {
            super(presentation, action);
            this.myDelegate = action;
        }

        public AnAction getDelegate() {
            return this.myDelegate;
        }
    }
}

