/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.LocalTimeCounter;
import java.io.IOException;

public abstract class LightVirtualFileBase
extends VirtualFile {
    private FileType myFileType;
    private String myName = "";
    private long myModStamp = LocalTimeCounter.currentTime();
    private boolean myIsWritable = true;
    private boolean myValid = true;
    private VirtualFile myOriginalFile;
    private static final MyVirtualFileSystem ourFileSystem = new MyVirtualFileSystem();

    public LightVirtualFileBase(String name, FileType fileType, long modificationStamp) {
        this.myName = name;
        this.myFileType = fileType;
        this.myModStamp = modificationStamp;
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    public VirtualFile getOriginalFile() {
        return this.myOriginalFile;
    }

    public void setOriginalFile(VirtualFile originalFile) {
        this.myOriginalFile = originalFile;
    }

    @Override
    public VirtualFileSystem getFileSystem() {
        return ourFileSystem;
    }

    public FileType getAssignedFileType() {
        return this.myFileType;
    }

    @Override
    public String getPath() {
        return "/" + this.getName();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean isWritable() {
        return this.myIsWritable;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myValid;
    }

    public void setValid(boolean valid) {
        this.myValid = valid;
    }

    @Override
    public VirtualFile getParent() {
        return null;
    }

    @Override
    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    public long getModificationStamp() {
        return this.myModStamp;
    }

    protected void setModificationStamp(long stamp) {
        this.myModStamp = stamp;
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    @Override
    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            e.printStackTrace();
            assert (false);
            return 0L;
        }
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @Override
    public void setWritable(boolean b) {
        this.myIsWritable = b;
    }

    @Override
    public void rename(Object requestor, String newName) throws IOException {
        this.myName = newName;
    }

    private static class MyVirtualFileSystem
    extends DeprecatedVirtualFileSystem
    implements NonPhysicalFileSystem {
        private static final String PROTOCOL = "mock";

        private MyVirtualFileSystem() {
            this.startEventPropagation();
        }

        @Override
        public String getProtocol() {
            return PROTOCOL;
        }

        @Override
        public VirtualFile findFileByPath(String path) {
            return null;
        }

        @Override
        public void refresh(boolean asynchronous) {
        }

        @Override
        public VirtualFile refreshAndFindFileByPath(String path) {
            return null;
        }

        @Override
        public void deleteFile(Object requestor, VirtualFile vFile) throws IOException {
        }

        @Override
        public void moveFile(Object requestor, VirtualFile vFile, VirtualFile newParent) throws IOException {
        }

        @Override
        public VirtualFile copyFile(Object requestor, VirtualFile vFile, VirtualFile newParent, String copyName) throws IOException {
            throw new IOException("Cannot copy files");
        }

        @Override
        public void renameFile(Object requestor, VirtualFile vFile, String newName) throws IOException {
        }

        @Override
        public VirtualFile createChildFile(Object requestor, VirtualFile vDir, String fileName) throws IOException {
            throw new IOException("Cannot create files");
        }

        @Override
        public VirtualFile createChildDirectory(Object requestor, VirtualFile vDir, String dirName) throws IOException {
            throw new IOException("Cannot create directories");
        }
    }
}

