/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class RefactoringMessageDialog
extends DialogWrapper {
    private final String myMessage;
    private final String myHelpTopic;
    private final Icon myIcon;
    private final boolean myIsCancelButtonVisible;

    public RefactoringMessageDialog(String title, String message, String helpTopic, String iconId, boolean showCancelButton, Project project) {
        super(project, false);
        this.setTitle(title);
        this.myMessage = message;
        this.myHelpTopic = helpTopic;
        this.myIsCancelButtonVisible = showCancelButton;
        this.myIcon = UIManager.getIcon(iconId);
        this.init();
    }

    @Override
    protected Action[] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        if (this.myIsCancelButtonVisible) {
            actions.add(this.getCancelAction());
        }
        if (this.myHelpTopic != null) {
            actions.add(this.getHelpAction());
        }
        return actions.toArray(new Action[actions.size()]);
    }

    @Override
    protected JComponent createNorthPanel() {
        JLabel label = new JLabel(this.myMessage);
        label.setUI(new MultiLineLabelUI());
        JPanel panel = new JPanel(new BorderLayout(10, 0));
        if (this.myIcon != null) {
            panel.add((Component)new JLabel(this.myIcon), "West");
            panel.add((Component)label, "Center");
        } else {
            panel.add((Component)label, "West");
        }
        return panel;
    }

    @Override
    protected JComponent createCenterPanel() {
        return null;
    }

    @Override
    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpTopic);
    }
}

