/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;

public class PackageWrapper {
    private final PsiManager myManager;
    private final String myQualifiedName;

    public PackageWrapper(PsiManager manager, String qualifiedName) {
        this.myManager = manager;
        this.myQualifiedName = qualifiedName;
    }

    public PackageWrapper(PsiPackage aPackage) {
        this.myManager = aPackage.getManager();
        this.myQualifiedName = aPackage.getQualifiedName();
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public PsiDirectory[] getDirectories() {
        String qName = this.myQualifiedName;
        while (qName.endsWith(".")) {
            qName = StringUtil.trimEnd((String)qName, (String)".");
        }
        PsiPackage aPackage = JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(qName);
        if (aPackage != null) {
            return aPackage.getDirectories();
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    public boolean exists() {
        return JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(this.myQualifiedName) != null;
    }

    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    public boolean equalToPackage(PsiPackage aPackage) {
        return aPackage != null && this.myQualifiedName.equals(aPackage.getQualifiedName());
    }

    public static PackageWrapper create(PsiPackage aPackage) {
        return new PackageWrapper(aPackage);
    }
}

