/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.IsConstantExpressionVisitor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterable;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class PsiUtil
extends PsiUtilCore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.util.PsiUtil");
    public static final int ACCESS_LEVEL_PUBLIC = 4;
    public static final int ACCESS_LEVEL_PROTECTED = 3;
    public static final int ACCESS_LEVEL_PACKAGE_LOCAL = 2;
    public static final int ACCESS_LEVEL_PRIVATE = 1;
    public static final Key<Boolean> VALID_VOID_TYPE_IN_CODE_FRAGMENT = Key.create((String)"VALID_VOID_TYPE_IN_CODE_FRAGMENT");
    private static final String[] accessModifiers = new String[]{"private", "packageLocal", "protected", "public"};
    public static final Key<LanguageLevel> FILE_LANGUAGE_LEVEL_KEY = Key.create((String)"FORCE_LANGUAGE_LEVEL");
    public static final Comparator<PsiElement> BY_POSITION = new Comparator<PsiElement>(){

        @Override
        public int compare(PsiElement o1, PsiElement o2) {
            return PsiUtilCore.compareElementsByPosition(o1, o2);
        }
    };

    private PsiUtil() {
    }

    public static boolean isOnAssignmentLeftHand(PsiExpression expr) {
        PsiElement parent = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class);
        return parent instanceof PsiAssignmentExpression && PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent).getLExpression(), expr, false);
    }

    public static boolean isAccessibleFromPackage(PsiModifierListOwner element, PsiPackage aPackage) {
        if (element.hasModifierProperty("public")) {
            return true;
        }
        return !element.hasModifierProperty("private") && JavaPsiFacade.getInstance(element.getProject()).isInPackage(element, aPackage);
    }

    public static boolean isAccessedForWriting(PsiExpression expr) {
        if (PsiUtil.isOnAssignmentLeftHand(expr)) {
            return true;
        }
        PsiElement parent = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class);
        if (parent instanceof PsiPrefixExpression) {
            IElementType tokenType = ((PsiPrefixExpression)parent).getOperationTokenType();
            return tokenType == JavaTokenType.PLUSPLUS || tokenType == JavaTokenType.MINUSMINUS;
        }
        if (parent instanceof PsiPostfixExpression) {
            IElementType tokenType = ((PsiPostfixExpression)parent).getOperationTokenType();
            return tokenType == JavaTokenType.PLUSPLUS || tokenType == JavaTokenType.MINUSMINUS;
        }
        return false;
    }

    public static boolean isAccessedForReading(PsiExpression expr) {
        PsiElement parent = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class);
        return !(parent instanceof PsiAssignmentExpression) || !PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent).getLExpression(), expr, false) || ((PsiAssignmentExpression)parent).getOperationTokenType() != JavaTokenType.EQ;
    }

    public static boolean isAccessible(PsiMember member, PsiElement place, PsiClass accessObjectClass) {
        return PsiUtil.isAccessible(place.getProject(), member, place, accessObjectClass);
    }

    public static boolean isAccessible(Project project, PsiMember member, PsiElement place, PsiClass accessObjectClass) {
        return JavaPsiFacade.getInstance(project).getResolveHelper().isAccessible(member, place, accessObjectClass);
    }

    public static JavaResolveResult getAccessObjectClass(PsiExpression expression) {
        JavaResolveResult resolveResult;
        PsiType lub;
        if (expression instanceof PsiSuperExpression) {
            return JavaResolveResult.EMPTY;
        }
        PsiType type = expression.getType();
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolveGenerics();
        }
        if (type instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type).getLeastUpperBound()) instanceof PsiClassType) {
            return ((PsiClassType)lub).resolveGenerics();
        }
        if (type == null && expression instanceof PsiReferenceExpression && (resolveResult = ((PsiReferenceExpression)expression).advancedResolve(false)).getElement() instanceof PsiClass) {
            return resolveResult;
        }
        return JavaResolveResult.EMPTY;
    }

    public static boolean isConstantExpression(PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        IsConstantExpressionVisitor visitor = new IsConstantExpressionVisitor();
        expression.accept(visitor);
        return visitor.myIsConstant;
    }

    public static void addException(PsiMethod method, String exceptionFQName) throws IncorrectOperationException {
        PsiClass exceptionClass = JavaPsiFacade.getInstance(method.getProject()).findClass(exceptionFQName, method.getResolveScope());
        PsiUtil.addException(method, exceptionClass, exceptionFQName);
    }

    public static void addException(PsiMethod method, PsiClass exceptionClass) throws IncorrectOperationException {
        PsiUtil.addException(method, exceptionClass, exceptionClass.getQualifiedName());
    }

    private static void addException(PsiMethod method, PsiClass exceptionClass, String exceptionName) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref;
        assert (exceptionClass != null || exceptionName != null) : "One of exceptionName, exceptionClass must be not null";
        PsiReferenceList throwsList = method.getThrowsList();
        PsiJavaCodeReferenceElement[] refs = throwsList.getReferenceElements();
        boolean replaced = false;
        for (PsiJavaCodeReferenceElement ref2 : refs) {
            if (ref2.isReferenceTo(exceptionClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)ref2.resolve();
            if (exceptionClass == null || aClass == null) continue;
            if (aClass.isInheritor(exceptionClass, true)) {
                PsiJavaCodeReferenceElement ref1;
                if (replaced) {
                    ref2.delete();
                    continue;
                }
                PsiElementFactory factory = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
                if (exceptionName != null) {
                    ref1 = factory.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
                } else {
                    PsiClassType type = factory.createType(exceptionClass);
                    ref1 = factory.createReferenceElementByType(type);
                }
                ref2.replace(ref1);
                replaced = true;
                continue;
            }
            if (!exceptionClass.isInheritor(aClass, true)) continue;
            return;
        }
        if (replaced) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
        if (exceptionName != null) {
            ref = factory.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
        } else {
            PsiClassType type = factory.createType(exceptionClass);
            ref = factory.createReferenceElementByType(type);
        }
        throwsList.add(ref);
    }

    public static void removeException(PsiMethod method, String exceptionClass) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = method.getThrowsList().getReferenceElements()) {
            if (!ref.getCanonicalText().equals(exceptionClass)) continue;
            ref.delete();
        }
    }

    public static boolean isVariableNameUnique(String name, PsiElement place) {
        PsiResolveHelper helper = JavaPsiFacade.getInstance(place.getProject()).getResolveHelper();
        return helper.resolveAccessibleReferencedVariable(name, place) == null;
    }

    public static PsiElement getTopLevelEnclosingCodeBlock(PsiElement element, PsiElement scope) {
        PsiElement blockSoFar = null;
        while (element != null) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpression) || parent instanceof PsiLambdaExpression) {
                if (element instanceof PsiCodeBlock || element instanceof PsiForStatement || element instanceof PsiForeachStatement) {
                    blockSoFar = element;
                }
                if (parent instanceof PsiMethod && parent.getParent() instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)parent.getParent()) || parent instanceof PsiClassInitializer && !(parent.getParent() instanceof PsiAnonymousClass)) break;
                if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element) {
                    blockSoFar = element;
                }
                if (parent instanceof PsiClassLevelDeclarationStatement) {
                    parent = parent.getParent();
                }
                if (element instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)element)) break;
                if (element instanceof PsiFile && PsiUtilCore.getTemplateLanguageFile(element) != null) {
                    return element;
                }
            }
            if (element == scope) break;
            element = parent;
        }
        return blockSoFar;
    }

    public static boolean isLocalOrAnonymousClass(PsiClass psiClass) {
        return psiClass instanceof PsiAnonymousClass || PsiUtil.isLocalClass(psiClass);
    }

    public static boolean isLocalClass(PsiClass psiClass) {
        PsiElement parent = psiClass.getParent();
        return parent instanceof PsiDeclarationStatement && parent.getParent() instanceof PsiCodeBlock;
    }

    public static boolean isAbstractClass(PsiClass clazz) {
        PsiModifierList modifierList = clazz.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty("abstract");
    }

    public static PsiElement getVariableCodeBlock(PsiVariable variable, PsiElement context) {
        PsiElement codeBlock = null;
        if (variable instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)variable).getDeclarationScope();
            if (declarationScope instanceof PsiCatchSection) {
                codeBlock = ((PsiCatchSection)declarationScope).getCatchBlock();
            } else if (declarationScope instanceof PsiForeachStatement) {
                codeBlock = ((PsiForeachStatement)declarationScope).getBody();
            } else if (declarationScope instanceof PsiMethod) {
                codeBlock = ((PsiMethod)declarationScope).getBody();
            } else if (declarationScope instanceof PsiLambdaExpression) {
                codeBlock = ((PsiLambdaExpression)declarationScope).getBody();
            }
        } else {
            if (variable instanceof PsiResourceVariable) {
                PsiElement resourceList = variable.getParent();
                return resourceList != null ? resourceList.getParent() : null;
            }
            if (variable instanceof PsiLocalVariable && variable.getParent() instanceof PsiForStatement) {
                return variable.getParent();
            }
            if (variable instanceof PsiField && context != null) {
                PsiClass aClass = ((PsiField)variable).getContainingClass();
                while (context != null && context.getParent() != aClass) {
                    if (!((context = context.getParent()) instanceof PsiClassLevelDeclarationStatement)) continue;
                    return null;
                }
                return context instanceof PsiMethod ? ((PsiMethod)context).getBody() : (context instanceof PsiClassInitializer ? ((PsiClassInitializer)context).getBody() : null);
            }
            PsiElement scope = variable.getParent() == null ? null : variable.getParent().getParent();
            codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock(variable, scope);
            if (codeBlock != null && codeBlock.getParent() instanceof PsiSwitchStatement) {
                codeBlock = codeBlock.getParent().getParent();
            }
        }
        return codeBlock;
    }

    public static boolean isIncrementDecrementOperation(PsiElement element) {
        IElementType sign;
        return element instanceof PsiPostfixExpression ? (sign = ((PsiPostfixExpression)element).getOperationTokenType()) == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS : element instanceof PsiPrefixExpression && ((sign = ((PsiPrefixExpression)element).getOperationTokenType()) == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS);
    }

    @AccessLevel
    public static int getAccessLevel(PsiModifierList modifierList) {
        if (modifierList.hasModifierProperty("private")) {
            return 1;
        }
        if (modifierList.hasModifierProperty("packageLocal")) {
            return 2;
        }
        if (modifierList.hasModifierProperty("protected")) {
            return 3;
        }
        return 4;
    }

    @PsiModifier.ModifierConstant
    public static String getAccessModifier(@AccessLevel int accessLevel) {
        String modifier = accessLevel > accessModifiers.length ? null : accessModifiers[accessLevel - 1];
        return modifier;
    }

    public static boolean isStatement(PsiElement element) {
        PsiElement parent = element.getParent();
        if (element instanceof PsiExpressionListStatement) {
            PsiExpression[] expressions;
            if (!(parent instanceof PsiForStatement)) {
                return false;
            }
            PsiForStatement forStatement = (PsiForStatement)parent;
            if (element != forStatement.getInitialization() && element != forStatement.getUpdate()) {
                return false;
            }
            PsiExpressionList expressionList = ((PsiExpressionListStatement)element).getExpressionList();
            for (PsiExpression expression : expressions = expressionList.getExpressions()) {
                if (PsiUtil.isStatement(expression)) continue;
                return false;
            }
            return true;
        }
        if (element instanceof PsiExpressionStatement) {
            return PsiUtil.isStatement(((PsiExpressionStatement)element).getExpression());
        }
        if (element instanceof PsiDeclarationStatement) {
            if (parent instanceof PsiCodeBlock) {
                return true;
            }
            if (parent instanceof PsiCodeFragment) {
                return true;
            }
            if (!(parent instanceof PsiForStatement) || ((PsiForStatement)parent).getBody() == element) {
                return false;
            }
        }
        if (element instanceof PsiStatement) {
            return true;
        }
        if (element instanceof PsiAssignmentExpression) {
            return true;
        }
        if (PsiUtil.isIncrementDecrementOperation(element)) {
            return true;
        }
        if (element instanceof PsiMethodCallExpression) {
            return true;
        }
        if (element instanceof PsiNewExpression) {
            return !(((PsiNewExpression)element).getType() instanceof PsiArrayType);
        }
        return element instanceof PsiCodeBlock;
    }

    public static PsiElement getEnclosingStatement(PsiElement element) {
        while (element != null) {
            if (element.getParent() instanceof PsiCodeBlock) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public static PsiElement getElementInclusiveRange(PsiElement scope, TextRange range) {
        PsiElement psiElement;
        for (psiElement = scope.findElementAt(range.getStartOffset()); psiElement != null && !psiElement.getTextRange().contains(range); psiElement = psiElement.getParent()) {
            if (psiElement != scope) continue;
            return null;
        }
        return psiElement;
    }

    public static PsiClass resolveClassInType(PsiType type) {
        PsiType lub;
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.resolveClassInType(((PsiArrayType)type).getComponentType());
        }
        if (type instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type).getLeastUpperBound()) instanceof PsiClassType) {
            return ((PsiClassType)lub).resolve();
        }
        return null;
    }

    public static PsiClass resolveClassInClassTypeOnly(PsiType type) {
        return type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
    }

    public static PsiClassType.ClassResolveResult resolveGenericsClassInType(PsiType type) {
        PsiType lub;
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            return classType.resolveGenerics();
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.resolveGenericsClassInType(((PsiArrayType)type).getComponentType());
        }
        if (type instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type).getLeastUpperBound()) instanceof PsiClassType) {
            return ((PsiClassType)lub).resolveGenerics();
        }
        return PsiClassType.ClassResolveResult.EMPTY;
    }

    public static PsiType convertAnonymousToBaseType(PsiType type) {
        PsiClass psiClass = PsiUtil.resolveClassInType(type);
        if (psiClass instanceof PsiAnonymousClass) {
            int dims = type.getArrayDimensions();
            type = ((PsiAnonymousClass)psiClass).getBaseClassType();
            while (dims != 0) {
                type = type.createArrayType();
                --dims;
            }
        }
        return type;
    }

    public static boolean isApplicable(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiExpressionList argList) {
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList) != 1;
    }

    public static boolean isApplicable(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiExpression[] argList) {
        PsiType[] types = (PsiType[])ContainerUtil.map2Array((Object[])argList, PsiType.class, PsiExpression.EXPRESSION_TO_TYPE);
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, types, PsiUtil.getLanguageLevel(method)) != 1;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiExpressionList argList) {
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList.getExpressionTypes(), PsiUtil.getLanguageLevel(argList));
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiType[] args, LanguageLevel languageLevel) {
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, args, languageLevel, true, true);
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiType[] args, LanguageLevel languageLevel, boolean allowUncheckedConversion, boolean checkVarargs) {
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, args, languageLevel, allowUncheckedConversion, checkVarargs, ApplicabilityChecker.ASSIGNABILITY_CHECKER);
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiType[] args, LanguageLevel languageLevel, boolean allowUncheckedConversion, boolean checkVarargs, ApplicabilityChecker function) {
        boolean isRaw;
        PsiParameter[] parms = method.getParameterList().getParameters();
        if (args.length < parms.length - 1) {
            return 1;
        }
        PsiClass containingClass = method.getContainingClass();
        boolean bl = isRaw = containingClass != null && PsiUtil.isRawSubstitutor(method, substitutorForMethod) && PsiUtil.isRawSubstitutor(containingClass, substitutorForMethod);
        if (!PsiUtil.areFirstArgumentsApplicable(args, parms, languageLevel, substitutorForMethod, isRaw, allowUncheckedConversion, function)) {
            return 1;
        }
        if (args.length == parms.length) {
            if (parms.length == 0) {
                return 3;
            }
            PsiType parmType = PsiUtil.getParameterType(parms[parms.length - 1], languageLevel, substitutorForMethod);
            PsiType argType = args[args.length - 1];
            if (argType == null) {
                return 1;
            }
            if (function.isApplicable(parmType, argType, allowUncheckedConversion, parms.length - 1)) {
                return 3;
            }
            if (isRaw) {
                PsiType erasedParamType = TypeConversionUtil.erasure(parmType);
                PsiType erasedArgType = TypeConversionUtil.erasure(argType);
                if (erasedArgType != null && erasedParamType != null && function.isApplicable(erasedParamType, erasedArgType, allowUncheckedConversion, parms.length - 1)) {
                    return 3;
                }
            }
        }
        if (checkVarargs && method.isVarArgs() && languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0) {
            if (args.length < parms.length) {
                return 2;
            }
            PsiParameter lastParameter = parms[parms.length - 1];
            if (!lastParameter.isVarArgs()) {
                return 1;
            }
            PsiType lastParmType = PsiUtil.getParameterType(lastParameter, languageLevel, substitutorForMethod);
            if (!(lastParmType instanceof PsiArrayType)) {
                return 1;
            }
            if ((lastParmType = ((PsiArrayType)lastParmType).getComponentType()) instanceof PsiCapturedWildcardType && !JavaVersionService.getInstance().isAtLeast(((PsiCapturedWildcardType)lastParmType).getContext(), JavaSdkVersion.JDK_1_8)) {
                lastParmType = ((PsiCapturedWildcardType)lastParmType).getWildcard();
            }
            for (int i = parms.length - 1; i < args.length; ++i) {
                PsiType argType = args[i];
                if (argType != null && function.isApplicable(lastParmType, argType, allowUncheckedConversion, i)) continue;
                return 1;
            }
            return 2;
        }
        return 1;
    }

    private static boolean areFirstArgumentsApplicable(PsiType[] args, PsiParameter[] parms, LanguageLevel languageLevel, PsiSubstitutor substitutorForMethod, boolean isRaw, boolean allowUncheckedConversion, ApplicabilityChecker function) {
        for (int i = 0; i < parms.length - 1; ++i) {
            PsiType type = args[i];
            if (type == null) {
                return false;
            }
            PsiParameter parameter = parms[i];
            PsiType substitutedParmType = PsiUtil.getParameterType(parameter, languageLevel, substitutorForMethod);
            if (isRaw) {
                PsiType substErasure = TypeConversionUtil.erasure(substitutedParmType);
                PsiType typeErasure = TypeConversionUtil.erasure(type);
                if (substErasure == null || typeErasure == null || function.isApplicable(substErasure, typeErasure, allowUncheckedConversion, i)) continue;
                return false;
            }
            if (function.isApplicable(substitutedParmType, type, allowUncheckedConversion, i)) continue;
            return false;
        }
        return true;
    }

    private static PsiType getParameterType(PsiParameter parameter, LanguageLevel languageLevel, PsiSubstitutor substitutor) {
        PsiType parmType = parameter.getType();
        if (parmType instanceof PsiClassType) {
            parmType = ((PsiClassType)parmType).setLanguageLevel(languageLevel);
        }
        return substitutor.substitute(parmType);
    }

    public static boolean equalOnClass(PsiSubstitutor s1, PsiSubstitutor s2, PsiClass aClass) {
        return PsiUtil.equalOnEquivalentClasses(s1, aClass, s2, aClass);
    }

    public static boolean equalOnEquivalentClasses(PsiSubstitutor s1, PsiClass aClass, PsiSubstitutor s2, PsiClass bClass) {
        PsiTypeParameter[] typeParameters2;
        if (aClass.hasTypeParameters() != bClass.hasTypeParameters()) {
            return true;
        }
        PsiTypeParameter[] typeParameters1 = aClass.getTypeParameters();
        if (typeParameters1.length != (typeParameters2 = bClass.getTypeParameters()).length) {
            return false;
        }
        for (int i = 0; i < typeParameters1.length; ++i) {
            PsiType substituted2 = s2.substitute(typeParameters2[i]);
            PsiType substituted1 = s1.substitute(typeParameters1[i]);
            if (Comparing.equal((Object)s1.substituteWithBoundsPromotion(typeParameters1[i]), (Object)substituted2) || Comparing.equal((Object)s2.substituteWithBoundsPromotion(typeParameters2[i]), (Object)substituted1) || Comparing.equal((Object)substituted1, (Object)substituted2)) continue;
            return false;
        }
        if (aClass.hasModifierProperty("static")) {
            return true;
        }
        PsiClass containingClass1 = aClass.getContainingClass();
        PsiClass containingClass2 = bClass.getContainingClass();
        if (containingClass1 != null && containingClass2 != null) {
            return PsiUtil.equalOnEquivalentClasses(s1, containingClass1, s2, containingClass2);
        }
        return containingClass1 == null && containingClass2 == null;
    }

    public static boolean isCompileTimeConstant(PsiField field) {
        return field.hasModifierProperty("final") && (TypeConversionUtil.isPrimitiveAndNotNull(field.getType()) || field.getType().equalsToText("java.lang.String")) && field.hasInitializer() && PsiUtil.isConstantExpression(field.getInitializer());
    }

    public static boolean allMethodsHaveSameSignature(PsiMethod[] methods) {
        if (methods.length == 0) {
            return true;
        }
        MethodSignature methodSignature = methods[0].getSignature(PsiSubstitutor.EMPTY);
        for (int i = 1; i < methods.length; ++i) {
            PsiMethod method = methods[i];
            if (methodSignature.equals(method.getSignature(PsiSubstitutor.EMPTY))) continue;
            return false;
        }
        return true;
    }

    public static PsiExpression deparenthesizeExpression(PsiExpression expression) {
        while (true) {
            if (expression instanceof PsiParenthesizedExpression) {
                expression = ((PsiParenthesizedExpression)expression).getExpression();
                continue;
            }
            if (!(expression instanceof PsiTypeCastExpression)) break;
            expression = ((PsiTypeCastExpression)expression).getOperand();
        }
        return expression;
    }

    public static boolean isInnerClass(PsiClass aClass) {
        return !aClass.hasModifierProperty("static") && aClass.getContainingClass() != null;
    }

    public static PsiElement findModifierInList(PsiModifierList modifierList, String modifier) {
        PsiElement[] children;
        for (PsiElement child : children = modifierList.getChildren()) {
            if (!child.getText().equals(modifier)) continue;
            return child;
        }
        return null;
    }

    public static PsiClass getTopLevelClass(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiClassOwner) {
            PsiClass[] classes;
            for (PsiClass aClass : classes = ((PsiClassOwner)file).getClasses()) {
                if (!PsiTreeUtil.isAncestor(aClass, element, false)) continue;
                return aClass;
            }
        }
        return null;
    }

    public static PsiModifierListOwner getEnclosingStaticElement(PsiElement place, PsiClass aClass) {
        LOG.assertTrue(aClass == null || !place.isPhysical() || PsiTreeUtil.isContextAncestor(aClass, place, false));
        for (PsiElement parent = place; parent != aClass && !(parent instanceof PsiFile); parent = parent.getParent()) {
            if (!(parent instanceof PsiModifierListOwner) || !((PsiModifierListOwner)parent).hasModifierProperty("static")) continue;
            return (PsiModifierListOwner)parent;
        }
        return null;
    }

    public static PsiType getTypeByPsiElement(PsiElement element) {
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getReturnType();
        }
        return null;
    }

    public static PsiType captureToplevelWildcards(PsiType type, PsiElement context) {
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result = ((PsiClassType)type).resolveGenerics();
            PsiClass aClass = result.getElement();
            if (aClass != null) {
                PsiSubstitutor substitutor = result.getSubstitutor();
                HashMap substitutionMap = null;
                for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiType substituted = substitutor.substitute(typeParameter);
                    if (!(substituted instanceof PsiWildcardType)) continue;
                    if (substitutionMap == null) {
                        substitutionMap = new HashMap(substitutor.getSubstitutionMap());
                    }
                    substitutionMap.put(typeParameter, PsiCapturedWildcardType.create((PsiWildcardType)substituted, context, typeParameter));
                }
                if (substitutionMap != null) {
                    PsiElementFactory factory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
                    PsiSubstitutor newSubstitutor = factory.createSubstitutor((Map<PsiTypeParameter, PsiType>)substitutionMap);
                    return factory.createType(aClass, newSubstitutor);
                }
            }
        } else if (type instanceof PsiArrayType) {
            return PsiUtil.captureToplevelWildcards(((PsiArrayType)type).getComponentType(), context).createArrayType();
        }
        return type;
    }

    public static boolean isInsideJavadocComment(PsiElement element) {
        return PsiTreeUtil.getParentOfType(element, PsiDocComment.class, true) != null;
    }

    public static List<PsiTypeElement> getParameterTypeElements(PsiParameter parameter) {
        PsiTypeElement typeElement = parameter.getTypeElement();
        return typeElement != null && typeElement.getType() instanceof PsiDisjunctionType ? PsiTreeUtil.getChildrenOfTypeAsList(typeElement, PsiTypeElement.class) : Collections.singletonList(typeElement);
    }

    public static void checkIsIdentifier(PsiManager manager, String text) throws IncorrectOperationException {
        if (!PsiNameHelper.getInstance(manager.getProject()).isIdentifier(text)) {
            throw new IncorrectOperationException(PsiBundle.message("0.is.not.an.identifier", text));
        }
    }

    public static VirtualFile getJarFile(PsiElement candidate) {
        VirtualFile file = candidate.getContainingFile().getVirtualFile();
        if (file != null && file.getFileSystem().getProtocol().equals("jar")) {
            return VfsUtilCore.getVirtualFileForJar(file);
        }
        return file;
    }

    public static boolean isAnnotationMethod(PsiElement element) {
        if (!(element instanceof PsiAnnotationMethod)) {
            return false;
        }
        PsiClass psiClass = ((PsiAnnotationMethod)element).getContainingClass();
        return psiClass != null && psiClass.isAnnotationType();
    }

    @PsiModifier.ModifierConstant
    public static String getMaximumModifierForMember(PsiClass aClass) {
        return PsiUtil.getMaximumModifierForMember(aClass, true);
    }

    @PsiModifier.ModifierConstant
    public static String getMaximumModifierForMember(PsiClass aClass, boolean allowPublicAbstract) {
        String modifier = "public";
        if (!allowPublicAbstract && aClass.hasModifierProperty("abstract") && !aClass.isEnum()) {
            modifier = "protected";
        } else if (aClass.hasModifierProperty("packageLocal") || aClass.isEnum()) {
            modifier = "packageLocal";
        } else if (aClass.hasModifierProperty("private")) {
            modifier = "private";
        }
        return modifier;
    }

    public static Iterator<PsiTypeParameter> typeParametersIterator(PsiTypeParameterListOwner owner) {
        return PsiUtil.typeParametersIterable(owner).iterator();
    }

    public static Iterable<PsiTypeParameter> typeParametersIterable(PsiTypeParameterListOwner owner) {
        ArrayList<PsiTypeParameter> result = null;
        for (PsiTypeParameterListOwner currentOwner = owner; currentOwner != null; currentOwner = currentOwner.getContainingClass()) {
            PsiTypeParameter[] typeParameters = currentOwner.getTypeParameters();
            if (typeParameters.length > 0) {
                if (result == null) {
                    result = new ArrayList<PsiTypeParameter>(typeParameters.length);
                }
                for (int i = typeParameters.length - 1; i >= 0; --i) {
                    result.add(typeParameters[i]);
                }
            }
            if (currentOwner.hasModifierProperty("static")) break;
        }
        if (result == null) {
            return EmptyIterable.getInstance();
        }
        return result;
    }

    public static boolean canBeOverriden(PsiMethod method) {
        PsiClass parentClass = method.getContainingClass();
        return parentClass != null && !method.isConstructor() && !method.hasModifierProperty("static") && !method.hasModifierProperty("final") && !method.hasModifierProperty("private") && !(parentClass instanceof PsiAnonymousClass) && !parentClass.hasModifierProperty("final");
    }

    public static PsiElement[] mapElements(ResolveResult[] candidates) {
        PsiElement[] result = new PsiElement[candidates.length];
        for (int i = 0; i < candidates.length; ++i) {
            result[i] = candidates[i].getElement();
        }
        return result;
    }

    public static PsiMember findEnclosingConstructorOrInitializer(PsiElement expression) {
        PsiMember parent = (PsiMember)PsiTreeUtil.getParentOfType(expression, PsiClassInitializer.class, PsiEnumConstantInitializer.class, PsiMethod.class, PsiField.class);
        if (parent instanceof PsiMethod && !((PsiMethod)parent).isConstructor()) {
            return null;
        }
        if (parent instanceof PsiField && parent.hasModifierProperty("static")) {
            return null;
        }
        return parent;
    }

    public static boolean checkName(PsiElement element, String name, PsiElement context) {
        PsiMetaData data;
        if (element instanceof PsiMetaOwner && (data = ((PsiMetaOwner)((Object)element)).getMetaData()) != null) {
            return name.equals(data.getName(context));
        }
        return element instanceof PsiNamedElement && name.equals(((PsiNamedElement)element).getName());
    }

    public static boolean isRawSubstitutor(PsiTypeParameterListOwner owner, PsiSubstitutor substitutor) {
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(owner)) {
            if (substitutor.substitute(parameter) != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isLanguageLevel5OrHigher(PsiElement element) {
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_5);
    }

    public static boolean isLanguageLevel6OrHigher(PsiElement element) {
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_6);
    }

    public static boolean isLanguageLevel7OrHigher(PsiElement element) {
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_7);
    }

    public static boolean isLanguageLevel8OrHigher(PsiElement element) {
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_8);
    }

    public static boolean isLanguageLevel9OrHigher(PsiElement element) {
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_9);
    }

    public static LanguageLevel getLanguageLevel(PsiElement element) {
        PsiElement context;
        if (element instanceof PsiDirectory) {
            return JavaDirectoryService.getInstance().getLanguageLevel((PsiDirectory)element);
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiJavaFile) {
            return ((PsiJavaFile)file).getLanguageLevel();
        }
        if (file != null && (context = file.getContext()) != null) {
            return PsiUtil.getLanguageLevel(context);
        }
        return PsiUtil.getLanguageLevel(element.getProject());
    }

    public static LanguageLevel getLanguageLevel(Project project) {
        LanguageLevelProjectExtension instance = LanguageLevelProjectExtension.getInstance(project);
        return instance != null ? instance.getLanguageLevel() : LanguageLevel.HIGHEST;
    }

    public static boolean isInstantiatable(PsiClass clazz) {
        return !clazz.hasModifierProperty("abstract") && clazz.hasModifierProperty("public") && PsiUtil.hasDefaultConstructor(clazz);
    }

    public static boolean hasDefaultConstructor(PsiClass clazz) {
        return PsiUtil.hasDefaultConstructor(clazz, false);
    }

    public static boolean hasDefaultConstructor(PsiClass clazz, boolean allowProtected) {
        return PsiUtil.hasDefaultConstructor(clazz, allowProtected, true);
    }

    public static boolean hasDefaultConstructor(PsiClass clazz, boolean allowProtected, boolean checkModifiers) {
        return PsiUtil.hasDefaultCtrInHierarchy(clazz, allowProtected, checkModifiers, null);
    }

    private static boolean hasDefaultCtrInHierarchy(PsiClass clazz, boolean allowProtected, boolean checkModifiers, Set<PsiClass> visited) {
        PsiMethod[] constructors = clazz.getConstructors();
        if (constructors.length > 0) {
            for (PsiMethod cls : constructors) {
                if (checkModifiers && !cls.hasModifierProperty("public") && (!allowProtected || !cls.hasModifierProperty("protected")) || cls.getParameterList().getParametersCount() != 0) continue;
                return true;
            }
        } else {
            PsiClass superClass = clazz.getSuperClass();
            if (superClass == null) {
                return true;
            }
            if (visited == null) {
                visited = new THashSet();
            }
            if (!visited.add((PsiClass)clazz)) {
                return false;
            }
            return PsiUtil.hasDefaultCtrInHierarchy(superClass, true, true, (Set<PsiClass>)visited);
        }
        return false;
    }

    public static PsiType extractIterableTypeParameter(PsiType psiType, boolean eraseTypeParameter) {
        PsiType type = PsiUtil.substituteTypeParameter(psiType, "java.lang.Iterable", 0, eraseTypeParameter);
        return type != null ? type : PsiUtil.substituteTypeParameter(psiType, "java.util.Collection", 0, eraseTypeParameter);
    }

    public static PsiType substituteTypeParameter(PsiType psiType, String superClass, int typeParamIndex, boolean eraseTypeParameter) {
        if (psiType == null) {
            return null;
        }
        if (!(psiType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)psiType;
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        if (psiClass == null) {
            return null;
        }
        PsiClass baseClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(superClass, psiClass.getResolveScope());
        if (baseClass == null) {
            return null;
        }
        if (!psiClass.isEquivalentTo(baseClass) && !psiClass.isInheritor(baseClass, true)) {
            return null;
        }
        PsiTypeParameter[] parameters = baseClass.getTypeParameters();
        if (parameters.length <= typeParamIndex) {
            return PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor(baseClass, psiClass, classResolveResult.getSubstitutor());
        PsiType type = substitutor.substitute(parameters[typeParamIndex]);
        if (type == null && eraseTypeParameter) {
            return TypeConversionUtil.typeParameterErasure(parameters[typeParamIndex]);
        }
        return type;
    }

    public static void setModifierProperty(PsiModifierListOwner owner, @PsiModifier.ModifierConstant String property, boolean value) {
        PsiModifierList modifierList = owner.getModifierList();
        assert (modifierList != null) : owner;
        modifierList.setModifierProperty(property, value);
    }

    public static boolean isTryBlock(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof PsiTryStatement && element == ((PsiTryStatement)parent).getTryBlock();
    }

    public static boolean isElseBlock(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof PsiIfStatement && element == ((PsiIfStatement)parent).getElseBranch();
    }

    public static boolean isJavaToken(PsiElement element, IElementType type) {
        return element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == type;
    }

    public static boolean isJavaToken(PsiElement element, TokenSet types) {
        return element instanceof PsiJavaToken && types.contains(((PsiJavaToken)element).getTokenType());
    }

    public static boolean isCatchParameter(PsiElement element) {
        return element instanceof PsiParameter && element.getParent() instanceof PsiCatchSection;
    }

    public static boolean isIgnoredName(String name) {
        return "ignore".equals(name) || "ignored".equals(name);
    }

    public static PsiMethod getResourceCloserMethod(PsiResourceVariable resource) {
        PsiType resourceType = resource.getType();
        if (!(resourceType instanceof PsiClassType)) {
            return null;
        }
        return PsiUtil.getResourceCloserMethodForType((PsiClassType)resourceType);
    }

    public static PsiMethod getResourceCloserMethodForType(PsiClassType resourceType) {
        PsiClass resourceClass = resourceType.resolve();
        if (resourceClass == null) {
            return null;
        }
        Project project = resourceClass.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        PsiClass autoCloseable = facade.findClass("java.lang.AutoCloseable", ProjectScope.getLibrariesScope(project));
        if (autoCloseable == null) {
            return null;
        }
        if (!InheritanceUtil.isInheritorOrSelf(resourceClass, autoCloseable, true)) {
            return null;
        }
        PsiMethod[] closes = autoCloseable.findMethodsByName("close", false);
        return closes.length == 1 ? resourceClass.findMethodBySignature(closes[0], true) : null;
    }

    public static PsiExpression skipParenthesizedExprDown(PsiExpression initializer) {
        while (initializer instanceof PsiParenthesizedExpression) {
            initializer = ((PsiParenthesizedExpression)initializer).getExpression();
        }
        return initializer;
    }

    public static PsiElement skipParenthesizedExprUp(PsiElement parent) {
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static void ensureValidType(PsiType type) {
        PsiUtil.ensureValidType(type, null);
    }

    public static void ensureValidType(PsiType type, String customMessage) {
        if (!type.isValid()) {
            TimeoutUtil.sleep((long)1L);
            if (type.isValid()) {
                LOG.error("PsiType resurrected: " + type + " of " + type.getClass() + " " + customMessage);
                return;
            }
            if (type instanceof PsiClassType) {
                try {
                    PsiClass psiClass = ((PsiClassType)type).resolve();
                    if (psiClass != null) {
                        PsiUtil.ensureValid(psiClass);
                    }
                }
                catch (PsiInvalidElementAccessException e) {
                    throw customMessage == null ? e : new RuntimeException(customMessage, e);
                }
            }
            throw new AssertionError((Object)("Invalid type: " + type + " of class " + type.getClass() + " " + customMessage));
        }
    }

    public static String getMemberQualifiedName(PsiMember member) {
        if (member instanceof PsiClass) {
            return ((PsiClass)member).getQualifiedName();
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String className = containingClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        return className + "." + member.getName();
    }

    static boolean checkSameExpression(PsiElement templateExpr, PsiExpression expression) {
        return templateExpr.equals(PsiUtil.skipParenthesizedExprDown(expression));
    }

    public static boolean isCondition(PsiElement expr, PsiElement parent) {
        return parent instanceof PsiIfStatement ? PsiUtil.checkSameExpression(expr, ((PsiIfStatement)parent).getCondition()) : (parent instanceof PsiWhileStatement ? PsiUtil.checkSameExpression(expr, ((PsiWhileStatement)parent).getCondition()) : (parent instanceof PsiForStatement ? PsiUtil.checkSameExpression(expr, ((PsiForStatement)parent).getCondition()) : (parent instanceof PsiDoWhileStatement ? PsiUtil.checkSameExpression(expr, ((PsiDoWhileStatement)parent).getCondition()) : parent instanceof PsiConditionalExpression && PsiUtil.checkSameExpression(expr, ((PsiConditionalExpression)parent).getCondition()))));
    }

    public static PsiReturnStatement[] findReturnStatements(PsiMethod method) {
        return PsiUtil.findReturnStatements(method.getBody());
    }

    public static PsiReturnStatement[] findReturnStatements(PsiCodeBlock body) {
        ArrayList<PsiReturnStatement> vector = new ArrayList<PsiReturnStatement>();
        if (body != null) {
            PsiUtil.addReturnStatements(vector, body);
        }
        return vector.toArray(new PsiReturnStatement[vector.size()]);
    }

    private static void addReturnStatements(ArrayList<PsiReturnStatement> vector, PsiElement element) {
        if (element instanceof PsiReturnStatement) {
            vector.add((PsiReturnStatement)element);
        } else if (!(element instanceof PsiClass) && !(element instanceof PsiLambdaExpression)) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                PsiUtil.addReturnStatements(vector, child);
            }
        }
    }

    public static interface ApplicabilityChecker {
        public static final ApplicabilityChecker ASSIGNABILITY_CHECKER = new ApplicabilityChecker(){

            @Override
            public boolean isApplicable(PsiType left, PsiType right, boolean allowUncheckedConversion, int argId) {
                return TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion);
            }
        };

        public boolean isApplicable(PsiType var1, PsiType var2, boolean var3, int var4);
    }

    public static @interface AccessLevel {
    }
}

