/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import java.lang.ref.Reference;

public class PsiCacheKey<T, H extends PsiElement>
extends Key<SoftReference<Pair<Long, T>>> {
    private final Function<H, T> myFunction;
    private final Key<?> myModifyCause;

    private PsiCacheKey(String name, Function<H, T> function, Key<?> modifyCause) {
        super(name);
        this.myFunction = function;
        this.myModifyCause = modifyCause;
    }

    public final T getValue(H h) {
        Object result = this.getCachedValueOrNull(h);
        if (result != null) {
            return result;
        }
        result = this.myFunction.fun(h);
        long count = this.getModificationCount(h.getManager().getModificationTracker());
        h.putUserData((Key)this, (Object)new SoftReference((Object)new Pair((Object)count, result)));
        return result;
    }

    public final T getCachedValueOrNull(H h) {
        SoftReference ref = (SoftReference)h.getUserData((Key)this);
        Pair data = (Pair)SoftReference.dereference((Reference)ref);
        if (data == null || ((Long)data.getFirst()).longValue() != this.getModificationCount(h.getManager().getModificationTracker())) {
            return null;
        }
        return (T)data.getSecond();
    }

    private long getModificationCount(PsiModificationTracker tracker) {
        if (this.myModifyCause.equals((Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT)) {
            return tracker.getJavaStructureModificationCount();
        }
        if (this.myModifyCause.equals((Object)PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT)) {
            return tracker.getOutOfCodeBlockModificationCount();
        }
        if (this.myModifyCause.equals((Object)PsiModificationTracker.MODIFICATION_COUNT)) {
            return tracker.getModificationCount();
        }
        throw new AssertionError((Object)("No modification tracker found for key " + this.myModifyCause));
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(String name, Function<H, T> function, Key<?> modifyCause) {
        return new PsiCacheKey<T, H>(name, function, modifyCause);
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(String name, Function<H, T> function) {
        return PsiCacheKey.create(name, function, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
    }
}

