/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;

public abstract class CachedValuesManager {
    private static final NotNullLazyKey<CachedValuesManager, Project> INSTANCE_KEY = ServiceManager.createLazyKey(CachedValuesManager.class);
    private final ConcurrentMap<String, Key<CachedValue>> keyForProvider = ContainerUtil.newConcurrentMap();

    public static CachedValuesManager getManager(Project project) {
        return (CachedValuesManager)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    public abstract <T> CachedValue<T> createCachedValue(CachedValueProvider<T> var1, boolean var2);

    public abstract <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(ParameterizedCachedValueProvider<T, P> var1, boolean var2);

    public <T> CachedValue<T> createCachedValue(CachedValueProvider<T> provider) {
        return this.createCachedValue(provider, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, D extends UserDataHolder, P> T getParameterizedCachedValue(D dataHolder, Key<ParameterizedCachedValue<T, P>> key, ParameterizedCachedValueProvider<T, P> provider, boolean trackValue, P parameter) {
        ParameterizedCachedValue value;
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = (ParameterizedCachedValue)dh.getUserData(key);
            if (value == null) {
                value = this.createParameterizedCachedValue(provider, trackValue);
                value = (ParameterizedCachedValue)dh.putUserDataIfAbsent(key, value);
            }
        } else {
            D d = dataHolder;
            synchronized (d) {
                value = (ParameterizedCachedValue)dataHolder.getUserData(key);
                if (value == null) {
                    value = this.createParameterizedCachedValue(provider, trackValue);
                    dataHolder.putUserData(key, (Object)value);
                }
            }
        }
        return value.getValue(parameter);
    }

    public abstract <T, D extends UserDataHolder> T getCachedValue(D var1, Key<CachedValue<T>> var2, CachedValueProvider<T> var3, boolean var4);

    public <T, D extends UserDataHolder> T getCachedValue(D dataHolder, CachedValueProvider<T> provider) {
        return this.getCachedValue(dataHolder, this.getKeyForClass(provider.getClass()), provider, false);
    }

    public static <T> T getCachedValue(final PsiElement psi, final CachedValueProvider<T> provider) {
        CachedValuesManager manager = CachedValuesManager.getManager(psi.getProject());
        return manager.getCachedValue(psi, manager.getKeyForClass(provider.getClass()), new CachedValueProvider<T>(){

            @Override
            public CachedValueProvider.Result<T> compute() {
                CachedValueProvider.Result result = provider.compute();
                if (result != null && !psi.isPhysical()) {
                    return CachedValueProvider.Result.create(result.getValue(), ArrayUtil.append((Object[])result.getDependencyItems(), (Object)psi));
                }
                return result;
            }
        }, false);
    }

    public <T> Key<CachedValue<T>> getKeyForClass(Class<?> providerClass) {
        String name = providerClass.getName();
        assert (name != null) : providerClass + " doesn't have a name; can't be used for cache value provider";
        Key key = (Key)this.keyForProvider.get(name);
        if (key == null) {
            key = (Key)ConcurrencyUtil.cacheOrGet(this.keyForProvider, (Object)name, (Object)Key.create((String)name));
        }
        return key;
    }
}

