/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IdFilter;
import java.util.Collection;
import java.util.Iterator;

public abstract class StubIndex {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubIndex");

    public static StubIndex getInstance() {
        return StubIndexHolder.ourInstance;
    }

    public abstract <Key, Psi extends PsiElement> Collection<Psi> get(StubIndexKey<Key, Psi> var1, Key var2, Project var3, GlobalSearchScope var4);

    public <Key, Psi extends PsiElement> Collection<Psi> get(StubIndexKey<Key, Psi> indexKey, Key key, Project project, GlobalSearchScope scope, IdFilter filter) {
        return this.get(indexKey, key, project, scope);
    }

    public <Key, Psi extends PsiElement> boolean process(StubIndexKey<Key, Psi> indexKey, Key key, Project project, GlobalSearchScope scope, Processor<? super Psi> processor) {
        return this.processElements(indexKey, key, project, scope, PsiElement.class, processor);
    }

    public abstract <Key, Psi extends PsiElement> boolean processElements(StubIndexKey<Key, Psi> var1, Key var2, Project var3, GlobalSearchScope var4, Class<Psi> var5, Processor<? super Psi> var6);

    public <Key, Psi extends PsiElement> boolean process(StubIndexKey<Key, Psi> indexKey, Key key, Project project, GlobalSearchScope scope, IdFilter idFilter, Processor<? super Psi> processor) {
        return this.process(indexKey, key, project, scope, processor);
    }

    public <Key, Psi extends PsiElement> boolean processElements(StubIndexKey<Key, Psi> indexKey, Key key, Project project, GlobalSearchScope scope, IdFilter idFilter, Class<Psi> requiredClass, Processor<? super Psi> processor) {
        return this.process(indexKey, key, project, scope, processor);
    }

    public abstract <Key> Collection<Key> getAllKeys(StubIndexKey<Key, ?> var1, Project var2);

    public abstract <K> boolean processAllKeys(StubIndexKey<K, ?> var1, Project var2, Processor<K> var3);

    public <K> boolean processAllKeys(StubIndexKey<K, ?> indexKey, Processor<K> processor, GlobalSearchScope scope, IdFilter idFilter) {
        return this.processAllKeys(indexKey, (Project)ObjectUtils.assertNotNull((Object)scope.getProject()), processor);
    }

    public <Key, Psi extends PsiElement> Collection<Psi> safeGet(StubIndexKey<Key, Psi> indexKey, Key key, Project project, GlobalSearchScope scope, Class<Psi> requiredClass) {
        return StubIndex.getElements(indexKey, key, project, scope, requiredClass);
    }

    public static <Key, Psi extends PsiElement> Collection<Psi> getElements(StubIndexKey<Key, Psi> indexKey, Key key, Project project, GlobalSearchScope scope, Class<Psi> requiredClass) {
        return StubIndex.getElements(indexKey, key, project, scope, null, requiredClass);
    }

    public static <Key, Psi extends PsiElement> Collection<Psi> getElements(StubIndexKey<Key, Psi> indexKey, Key key, Project project, GlobalSearchScope scope, IdFilter idFilter, Class<Psi> requiredClass) {
        Collection<Psi> collection = StubIndex.getInstance().get(indexKey, key, project, scope, idFilter);
        Iterator<Psi> iterator = collection.iterator();
        while (iterator.hasNext()) {
            PsiElement psi = (PsiElement)iterator.next();
            if (requiredClass.isInstance(psi)) continue;
            iterator.remove();
            VirtualFile faultyContainer = PsiUtilCore.getVirtualFile(psi);
            if (faultyContainer != null && faultyContainer.isValid()) {
                FileBasedIndex.getInstance().requestReindex(faultyContainer);
            }
            StubIndex.getInstance().reportStubPsiMismatch(psi, faultyContainer, requiredClass);
        }
        return collection;
    }

    protected <Psi extends PsiElement> void reportStubPsiMismatch(Psi psi, VirtualFile file, Class<Psi> requiredClass) {
        LOG.error("Invalid stub element type in index: " + file + ". found: " + psi + ". expected: " + requiredClass);
    }

    public abstract void forceRebuild(Throwable var1);

    private static class StubIndexHolder {
        private static final StubIndex ourInstance = ApplicationManager.getApplication().getComponent(StubIndex.class);

        private StubIndexHolder() {
        }
    }
}

