/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;

public class DefaultStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.DefaultStubBuilder");

    @Override
    public StubElement buildStubTree(PsiFile file) {
        return this.buildStubTreeFor(file, this.createStubForFile(file));
    }

    protected StubElement createStubForFile(PsiFile file) {
        PsiFileStubImpl<PsiFile> stub = new PsiFileStubImpl<PsiFile>(file);
        return stub;
    }

    private StubElement buildStubTreeFor(PsiElement root, StubElement parentStub) {
        Stack parentStubs = new Stack();
        Stack parentElements = new Stack();
        parentElements.push((Object)root);
        parentStubs.push((Object)parentStub);
        while (!parentElements.isEmpty()) {
            StubElement<Object> stub = (StubElement)parentStubs.pop();
            PsiElement elt = (PsiElement)parentElements.pop();
            if (elt instanceof StubBasedPsiElement) {
                IStubElementType type = ((StubBasedPsiElement)elt).getElementType();
                if (type.shouldCreateStub(elt.getNode())) {
                    Object s = type.createStub(elt, stub);
                    stub = s;
                }
            } else {
                IElementType type;
                ASTNode node = elt.getNode();
                IElementType iElementType = type = node == null ? null : node.getElementType();
                if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(node)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + elt);
                }
            }
            for (PsiElement child = elt.getLastChild(); child != null; child = child.getPrevSibling()) {
                if (this.skipChildProcessingWhenBuildingStubs(elt, child)) continue;
                parentStubs.push((Object)stub);
                parentElements.push((Object)child);
            }
        }
        return parentStub;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(PsiElement parent, PsiElement element) {
        return false;
    }

    protected StubElement buildStubTreeFor(ASTNode root, StubElement parentStub) {
        Stack parentStubs = new Stack();
        Stack parentNodes = new Stack();
        parentNodes.push((Object)root);
        parentStubs.push((Object)parentStub);
        while (!parentStubs.isEmpty()) {
            IStubElementType type;
            StubElement<Object> stub = (StubElement)parentStubs.pop();
            ASTNode node = (ASTNode)parentNodes.pop();
            IElementType nodeType = node.getElementType();
            if (nodeType instanceof IStubElementType && (type = (IStubElementType)nodeType).shouldCreateStub(node)) {
                Object s;
                PsiElement element = node.getPsi();
                if (!(element instanceof StubBasedPsiElement)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + element);
                }
                LOG.assertTrue((stub = (s = type.createStub(element, stub))) != null, (Object)element);
            }
            for (ASTNode childNode = node.getLastChildNode(); childNode != null; childNode = childNode.getTreePrev()) {
                if (this.skipChildProcessingWhenBuildingStubs(node, childNode)) continue;
                parentNodes.push((Object)childNode);
                parentStubs.push((Object)stub);
            }
        }
        return parentStub;
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(ASTNode parent, ASTNode node) {
        return false;
    }
}

