/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchRequestQuery;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.search.searches.ReferenceDescriptor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.MergeQuery;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import com.intellij.util.containers.ContainerUtil;

public class ReferencesSearch
extends ExtensibleQueryFactory<PsiReference, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.referencesSearch");
    private static final ReferencesSearch INSTANCE = new ReferencesSearch();

    private ReferencesSearch() {
    }

    public static Query<PsiReference> search(PsiElement element) {
        return ReferencesSearch.search(element, GlobalSearchScope.allScope(PsiUtilCore.getProjectInReadAction(element)), false);
    }

    public static Query<PsiReference> search(PsiElement element, SearchScope searchScope) {
        return ReferencesSearch.search(element, searchScope, false);
    }

    public static Query<PsiReference> search(PsiElement element, SearchScope searchScope, boolean ignoreAccessScope) {
        return ReferencesSearch.search(new SearchParameters(element, searchScope, ignoreAccessScope));
    }

    public static Query<PsiReference> search(SearchParameters parameters) {
        Query<PsiReference> result = INSTANCE.createQuery(parameters);
        if (parameters.isSharedOptimizer) {
            return ReferencesSearch.uniqueResults(result);
        }
        SearchRequestCollector requests = parameters.getOptimizer();
        PsiElement element = parameters.getElementToSearch();
        return ReferencesSearch.uniqueResults(new MergeQuery<PsiReference>(result, new SearchRequestQuery(PsiUtilCore.getProjectInReadAction(element), requests)));
    }

    private static UniqueResultsQuery<PsiReference, ReferenceDescriptor> uniqueResults(Query<PsiReference> composite) {
        return new UniqueResultsQuery<PsiReference, ReferenceDescriptor>(composite, ContainerUtil.canonicalStrategy(), ReferenceDescriptor.MAPPER);
    }

    public static void searchOptimized(PsiElement element, SearchScope searchScope, boolean ignoreAccessScope, SearchRequestCollector collector, final Processor<PsiReference> processor) {
        ReferencesSearch.searchOptimized(element, searchScope, ignoreAccessScope, collector, false, new PairProcessor<PsiReference, SearchRequestCollector>(){

            public boolean process(PsiReference psiReference, SearchRequestCollector collector) {
                return processor.process((Object)psiReference);
            }
        });
    }

    public static void searchOptimized(PsiElement element, SearchScope searchScope, boolean ignoreAccessScope, SearchRequestCollector collector, boolean inReadAction, PairProcessor<PsiReference, SearchRequestCollector> processor) {
        SearchRequestCollector nested = new SearchRequestCollector(collector.getSearchSession());
        Query<PsiReference> query = ReferencesSearch.search(new SearchParameters(element, searchScope, ignoreAccessScope, nested));
        collector.searchQuery(new QuerySearchRequest(query, nested, inReadAction, processor));
    }

    public static class SearchParameters {
        private final PsiElement myElementToSearch;
        private final SearchScope myScope;
        private final boolean myIgnoreAccessScope;
        private final SearchRequestCollector myOptimizer;
        private final boolean isSharedOptimizer;

        public SearchParameters(PsiElement elementToSearch, SearchScope scope, boolean ignoreAccessScope, SearchRequestCollector optimizer) {
            this.myElementToSearch = elementToSearch;
            this.myScope = scope;
            this.myIgnoreAccessScope = ignoreAccessScope;
            this.isSharedOptimizer = optimizer != null;
            this.myOptimizer = optimizer == null ? new SearchRequestCollector(new SearchSession()) : optimizer;
        }

        public SearchParameters(PsiElement elementToSearch, SearchScope scope, boolean ignoreAccessScope) {
            this(elementToSearch, scope, ignoreAccessScope, null);
        }

        public PsiElement getElementToSearch() {
            return this.myElementToSearch;
        }

        public SearchScope getScopeDeterminedByUser() {
            return this.myScope;
        }

        @Deprecated
        public SearchScope getScope() {
            return this.myScope;
        }

        public boolean isIgnoreAccessScope() {
            return this.myIgnoreAccessScope;
        }

        public SearchRequestCollector getOptimizer() {
            return this.myOptimizer;
        }

        public SearchScope getEffectiveSearchScope() {
            if (this.myIgnoreAccessScope) {
                return this.myScope;
            }
            SearchScope accessScope = PsiSearchHelper.SERVICE.getInstance(this.myElementToSearch.getProject()).getUseScope(this.myElementToSearch);
            return this.myScope.intersectWith(accessScope);
        }
    }
}

