/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.search.scope.packageSet.FilePatternPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;

public class PatternPackageSet
extends PatternBasedPackageSet {
    public static final String SCOPE_TEST = "test";
    public static final String SCOPE_SOURCE = "src";
    public static final String SCOPE_LIBRARY = "lib";
    public static final String SCOPE_PROBLEM = "problem";
    public static final String SCOPE_ANY = "";
    private final Pattern myPattern;
    private final Pattern myModulePattern;
    private final Pattern myModuleGroupPattern;
    private final String myAspectJSyntaxPattern;
    private final String myScope;
    private final String myModulePatternText;

    public PatternPackageSet(String aspectPattern, String scope, String modulePattern) {
        this.myAspectJSyntaxPattern = aspectPattern;
        this.myScope = scope;
        this.myModulePatternText = modulePattern;
        Pattern mmgp = null;
        Pattern mmp = null;
        if (modulePattern == null || modulePattern.isEmpty()) {
            mmp = null;
        } else if (modulePattern.startsWith("group:")) {
            int idx = modulePattern.indexOf(58, 6);
            if (idx == -1) {
                idx = modulePattern.length();
            }
            mmgp = Pattern.compile(StringUtil.replace((String)modulePattern.substring(6, idx), (String)"*", (String)".*"));
            if (idx < modulePattern.length() - 1) {
                mmp = Pattern.compile(StringUtil.replace((String)modulePattern.substring(idx + 1), (String)"*", (String)".*"));
            }
        } else {
            mmp = Pattern.compile(StringUtil.replace((String)modulePattern, (String)"*", (String)".*"));
        }
        this.myModulePattern = mmp;
        this.myModuleGroupPattern = mmgp;
        this.myPattern = aspectPattern != null ? Pattern.compile(FilePatternPackageSet.convertToRegexp(aspectPattern, '.')) : null;
    }

    @Override
    public boolean contains(VirtualFile file, NamedScopesHolder holder) {
        return this.contains(file, holder.getProject(), holder);
    }

    @Override
    public boolean contains(VirtualFile file, Project project, NamedScopesHolder holder) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        return this.matchesScope(file, project, fileIndex) && (this.myPattern == null || this.myPattern.matcher(PatternPackageSet.getPackageName(file, fileIndex)).matches());
    }

    private boolean matchesScope(VirtualFile file, Project project, ProjectFileIndex fileIndex) {
        if (file == null) {
            return false;
        }
        boolean isSource = fileIndex.isInSourceContent(file);
        if (this.myScope == SCOPE_ANY) {
            return fileIndex.isInContent(file) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, file, fileIndex);
        }
        if (this.myScope == SCOPE_SOURCE) {
            return isSource && !fileIndex.isInTestSourceContent(file) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, file, fileIndex);
        }
        if (this.myScope == SCOPE_LIBRARY) {
            return (fileIndex.isInLibraryClasses(file) || fileIndex.isInLibrarySource(file)) && PatternPackageSet.matchesLibrary(this.myModulePattern, file, fileIndex);
        }
        if (this.myScope == SCOPE_TEST) {
            return isSource && fileIndex.isInTestSourceContent(file) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, file, fileIndex);
        }
        if (this.myScope == SCOPE_PROBLEM) {
            return isSource && WolfTheProblemSolver.getInstance(project).isProblemFile(file) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, file, fileIndex);
        }
        throw new RuntimeException("Unknown scope: " + this.myScope);
    }

    private static String getPackageName(VirtualFile file, ProjectFileIndex fileIndex) {
        return StringUtil.getQualifiedName((String)fileIndex.getPackageNameByDirectory(file.isDirectory() ? file : file.getParent()), (String)file.getNameWithoutExtension());
    }

    @Override
    public PackageSet createCopy() {
        return new PatternPackageSet(this.myAspectJSyntaxPattern, this.myScope, this.myModulePatternText);
    }

    @Override
    public int getNodePriority() {
        return 0;
    }

    @Override
    public String getText() {
        StringBuilder buf = new StringBuilder();
        if (this.myScope != SCOPE_ANY) {
            buf.append(this.myScope);
        }
        if (this.myModulePattern != null || this.myModuleGroupPattern != null) {
            buf.append("[").append(this.myModulePatternText).append("]");
        }
        if (buf.length() > 0) {
            buf.append(':');
        }
        buf.append(this.myAspectJSyntaxPattern);
        return buf.toString();
    }

    @Override
    public String getModulePattern() {
        return this.myModulePatternText;
    }

    @Override
    public boolean isOn(String oldQName) {
        return Comparing.strEqual((String)oldQName, (String)this.myAspectJSyntaxPattern) || Comparing.strEqual((String)(oldQName + "..*"), (String)this.myAspectJSyntaxPattern) || Comparing.strEqual((String)(oldQName + ".*"), (String)this.myAspectJSyntaxPattern);
    }

    @Override
    public String getPattern() {
        return this.myAspectJSyntaxPattern;
    }

    public static boolean matchesLibrary(Pattern libPattern, VirtualFile file, ProjectFileIndex fileIndex) {
        if (libPattern != null) {
            List<OrderEntry> entries = fileIndex.getOrderEntriesForFile(file);
            for (OrderEntry orderEntry : entries) {
                String jdkName;
                String presentableName;
                String fileName;
                String libraryName;
                if (!(orderEntry instanceof LibraryOrderEntry ? ((libraryName = ((LibraryOrderEntry)orderEntry).getLibraryName()) != null ? libPattern.matcher(libraryName).matches() : libPattern.matcher(fileName = new File(presentableName = orderEntry.getPresentableName()).getName()).matches()) : orderEntry instanceof JdkOrderEntry && (jdkName = ((JdkOrderEntry)orderEntry).getJdkName()) != null && libPattern.matcher(jdkName).matches())) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

