/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import javax.swing.Icon;
import org.jdom.Element;

public class TodoAttributes
implements Cloneable {
    private Icon myIcon;
    private TextAttributes myTextAttributes;
    private boolean myShouldUseCustomColors;
    private static final String ATTRIBUTE_ICON = "icon";
    private static final String ICON_DEFAULT = "default";
    private static final String ICON_QUESTION = "question";
    private static final String ICON_IMPORTANT = "important";
    private static final String ELEMENT_OPTION = "option";
    private static final String USE_CUSTOM_COLORS_ATT = "useCustomColors";

    public TodoAttributes(Element element, TextAttributes defaultTodoAttributes) throws InvalidDataException {
        String icon = element.getAttributeValue(ATTRIBUTE_ICON, ICON_DEFAULT);
        if (ICON_DEFAULT.equals(icon)) {
            this.myIcon = AllIcons.General.TodoDefault;
        } else if (ICON_QUESTION.equals(icon)) {
            this.myIcon = AllIcons.General.TodoQuestion;
        } else if (ICON_IMPORTANT.equals(icon)) {
            this.myIcon = AllIcons.General.TodoImportant;
        } else {
            throw new InvalidDataException(icon);
        }
        this.myTextAttributes = element.getChild(ELEMENT_OPTION) == null ? defaultTodoAttributes : new TextAttributes(element);
        String useCustomColors = element.getAttributeValue(USE_CUSTOM_COLORS_ATT);
        this.myShouldUseCustomColors = useCustomColors != null && Boolean.valueOf(useCustomColors) != false;
    }

    TodoAttributes(Icon icon, TextAttributes textAttributes) {
        this.myIcon = icon;
        this.myTextAttributes = textAttributes;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public TextAttributes getTextAttributes() {
        return this.getCustomizedTextAttributes();
    }

    public TextAttributes getCustomizedTextAttributes() {
        return this.myTextAttributes;
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String icon;
        if (this.myIcon == AllIcons.General.TodoDefault) {
            icon = ICON_DEFAULT;
        } else if (this.myIcon == AllIcons.General.TodoQuestion) {
            icon = ICON_QUESTION;
        } else if (this.myIcon == AllIcons.General.TodoImportant) {
            icon = ICON_IMPORTANT;
        } else {
            throw new WriteExternalException("");
        }
        element.setAttribute(ATTRIBUTE_ICON, icon);
        this.myTextAttributes.writeExternal(element);
        element.setAttribute(USE_CUSTOM_COLORS_ATT, Boolean.toString(this.shouldUseCustomTodoColor()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TodoAttributes)) {
            return false;
        }
        TodoAttributes attributes = (TodoAttributes)o;
        return this.myIcon == attributes.myIcon && !(this.myTextAttributes == null ? attributes.myTextAttributes != null : !this.myTextAttributes.equals(attributes.myTextAttributes)) && this.myShouldUseCustomColors == attributes.myShouldUseCustomColors;
    }

    public int hashCode() {
        int result = this.myIcon != null ? this.myIcon.hashCode() : 0;
        result = 29 * result + (this.myTextAttributes != null ? this.myTextAttributes.hashCode() : 0);
        result = 29 * result + Boolean.valueOf(this.myShouldUseCustomColors).hashCode();
        return result;
    }

    public boolean shouldUseCustomTodoColor() {
        return this.myShouldUseCustomColors;
    }

    public void setUseCustomTodoColor(boolean useCustomColors, TextAttributes defaultTodoAttributes) {
        this.myShouldUseCustomColors = useCustomColors;
        if (!useCustomColors) {
            this.myTextAttributes = defaultTodoAttributes;
        }
    }

    public TodoAttributes clone() {
        try {
            TextAttributes textAttributes = this.myTextAttributes.clone();
            TodoAttributes attributes = (TodoAttributes)super.clone();
            attributes.myTextAttributes = textAttributes;
            attributes.myShouldUseCustomColors = this.myShouldUseCustomColors;
            return attributes;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

