/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.codeInsight.ContainerProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.SingleTargetRequestResultProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

public class SearchRequestCollector {
    private final Object lock = new Object();
    private final List<PsiSearchRequest> myWordRequests = ContainerUtil.newArrayList();
    private final List<QuerySearchRequest> myQueryRequests = ContainerUtil.newArrayList();
    private final List<Processor<Processor<PsiReference>>> myCustomSearchActions = ContainerUtil.newArrayList();
    private final SearchSession mySession;

    public SearchRequestCollector(SearchSession session) {
        this.mySession = session;
    }

    public SearchSession getSearchSession() {
        return this.mySession;
    }

    public void searchWord(String word, SearchScope searchScope, boolean caseSensitive, PsiElement searchTarget) {
        short searchContext = (short)(0xB | (searchTarget instanceof PsiFileSystemItem ? 4 : 0));
        this.searchWord(word, searchScope, searchContext, caseSensitive, searchTarget);
    }

    public void searchWord(String word, SearchScope searchScope, short searchContext, boolean caseSensitive, PsiElement searchTarget) {
        this.searchWord(word, searchScope, searchContext, caseSensitive, SearchRequestCollector.getContainerName(searchTarget), (RequestResultProcessor)new SingleTargetRequestResultProcessor(searchTarget));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchWord(String word, SearchScope searchScope, short searchContext, boolean caseSensitive, String containerName, RequestResultProcessor processor) {
        if (!SearchRequestCollector.makesSenseToSearch(word, searchScope)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            PsiSearchRequest request = new PsiSearchRequest(searchScope, word, searchContext, caseSensitive, containerName, processor);
            this.myWordRequests.add(request);
        }
    }

    public void searchWord(String word, SearchScope searchScope, short searchContext, boolean caseSensitive, PsiElement searchTarget, RequestResultProcessor processor) {
        this.searchWord(word, searchScope, searchContext, caseSensitive, SearchRequestCollector.getContainerName(searchTarget), processor);
    }

    private static String getContainerName(final PsiElement target) {
        return ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            public String compute() {
                PsiElement container = SearchRequestCollector.getContainer(target);
                return container instanceof PsiNamedElement ? ((PsiNamedElement)container).getName() : null;
            }
        });
    }

    private static PsiElement getContainer(PsiElement refElement) {
        for (ContainerProvider provider : (ContainerProvider[])ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container = provider.getContainer(refElement);
            if (container == null) continue;
            return container;
        }
        return refElement.getParent();
    }

    @Deprecated
    public void searchWord(String word, SearchScope searchScope, short searchContext, boolean caseSensitive, RequestResultProcessor processor) {
        this.searchWord(word, searchScope, searchContext, caseSensitive, (String)null, processor);
    }

    private static boolean makesSenseToSearch(String word, SearchScope searchScope) {
        if (searchScope instanceof LocalSearchScope && ((LocalSearchScope)searchScope).getScope().length == 0) {
            return false;
        }
        if (searchScope == GlobalSearchScope.EMPTY_SCOPE) {
            return false;
        }
        return !StringUtil.isEmpty((String)word);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchQuery(QuerySearchRequest request) {
        assert (request.collector != this);
        assert (request.collector.getSearchSession() == this.mySession);
        Object object = this.lock;
        synchronized (object) {
            this.myQueryRequests.add(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchCustom(Processor<Processor<PsiReference>> searchAction) {
        Object object = this.lock;
        synchronized (object) {
            this.myCustomSearchActions.add(searchAction);
        }
    }

    public List<QuerySearchRequest> takeQueryRequests() {
        return this.takeRequests(this.myQueryRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> takeRequests(List<T> list) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<T> requests = new ArrayList<T>(list);
            list.clear();
            return requests;
        }
    }

    public List<PsiSearchRequest> takeSearchRequests() {
        return this.takeRequests(this.myWordRequests);
    }

    public List<Processor<Processor<PsiReference>>> takeCustomSearchActions() {
        return this.takeRequests(this.myCustomSearchActions);
    }

    public String toString() {
        return this.myWordRequests.toString().replace(',', '\n') + ";" + this.myQueryRequests;
    }
}

