/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IdFilter;

public abstract class PsiShortNamesCache {
    public static final ExtensionPointName<PsiShortNamesCache> EP_NAME = ExtensionPointName.create((String)"com.intellij.java.shortNamesCache");

    public static PsiShortNamesCache getInstance(Project project) {
        return ServiceManager.getService(project, PsiShortNamesCache.class);
    }

    public PsiFile[] getFilesByName(String name) {
        return PsiFile.EMPTY_ARRAY;
    }

    public String[] getAllFileNames() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public abstract PsiClass[] getClassesByName(String var1, GlobalSearchScope var2);

    public abstract String[] getAllClassNames();

    public boolean processAllClassNames(Processor<String> processor) {
        return ContainerUtil.process((Object[])this.getAllClassNames(), processor);
    }

    public boolean processAllClassNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter) {
        return ContainerUtil.process((Object[])this.getAllClassNames(), processor);
    }

    public abstract void getAllClassNames(HashSet<String> var1);

    public abstract PsiMethod[] getMethodsByName(String var1, GlobalSearchScope var2);

    public abstract PsiMethod[] getMethodsByNameIfNotMoreThan(String var1, GlobalSearchScope var2, int var3);

    public abstract PsiField[] getFieldsByNameIfNotMoreThan(String var1, GlobalSearchScope var2, int var3);

    public abstract boolean processMethodsWithName(String var1, GlobalSearchScope var2, Processor<PsiMethod> var3);

    public boolean processMethodsWithName(String name, final Processor<? super PsiMethod> processor, GlobalSearchScope scope, IdFilter filter) {
        return this.processMethodsWithName(name, scope, new Processor<PsiMethod>(){

            public boolean process(PsiMethod method) {
                return processor.process((Object)method);
            }
        });
    }

    public boolean processAllMethodNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter) {
        return ContainerUtil.process((Object[])this.getAllFieldNames(), processor);
    }

    public boolean processAllFieldNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter) {
        return ContainerUtil.process((Object[])this.getAllFieldNames(), processor);
    }

    public abstract String[] getAllMethodNames();

    public abstract void getAllMethodNames(HashSet<String> var1);

    public abstract PsiField[] getFieldsByName(String var1, GlobalSearchScope var2);

    public abstract String[] getAllFieldNames();

    public abstract void getAllFieldNames(HashSet<String> var1);

    public boolean processFieldsWithName(String name, Processor<? super PsiField> processor, GlobalSearchScope scope, IdFilter filter) {
        return ContainerUtil.process((Object[])this.getFieldsByName(name, scope), processor);
    }

    public boolean processClassesWithName(String name, Processor<? super PsiClass> processor, GlobalSearchScope scope, IdFilter filter) {
        return ContainerUtil.process((Object[])this.getClassesByName(name, scope), processor);
    }
}

